/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.exception.batUpdExcept;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;

public class batUpdExceptClient
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.exception.batUpdExcept";
    private static final int MAXUPDATECOUNT_ENTRIES = 4;
    private static final int UPDATECOUNTERROR_LOCATION = 3;
    private static final int DRIVERCONTINUES_ERRORSTATE = -3;
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String drManager = null;
    private transient DatabaseMetaData dbmd = null;
    private Properties sqlp = null;
    private boolean supbatupdflag;
    private boolean isThrown = false;
    private int[] intialVal = new int[4];
    private String sReason = null;
    private String sSqlState = null;
    private String sVendorCode = null;
    private String sIntialVal = null;
    private String sUsr;
    private String sPass;
    private String sUrl;
    private int vendorCode = 0;
    private int maxVal = 0;
    private int minVal = 0;
    private int[] updateCount = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        batUpdExceptClient theTests = new batUpdExceptClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.sUrl = p.getProperty("db1", "");
                this.sUsr = p.getProperty("user1", "");
                this.sPass = p.getProperty("password1", "");
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
                this.supbatupdflag = this.dbmd.supportsBatchUpdates();
                this.logTrace("Driver Supports BatchUpdates  : " + this.supbatupdflag);
                if (!this.supbatupdflag) {
                    this.logTrace("Driver does not support Batch Updates ");
                    throw new EETest.Fault("Driver does not support Batch Updates ");
                }
                this.stmt = this.conn.createStatement();
                StringTokenizer sToken = null;
                this.sReason = this.sqlp.getProperty("Reason_BatUpdExec");
                this.logTrace("Reason : " + this.sReason);
                this.sSqlState = this.sqlp.getProperty("SQLState_BatUpdExec");
                this.logTrace("SQLState : " + this.sSqlState);
                this.sVendorCode = this.sqlp.getProperty("VendorCode_BatUpdExec");
                this.logTrace("VendorCode : " + this.sVendorCode);
                this.sIntialVal = this.sqlp.getProperty("IntialValue_BatUpdExec");
                this.logTrace("IntialVal : " + this.sIntialVal);
                this.sVendorCode = this.sVendorCode.trim();
                this.vendorCode = Integer.valueOf(this.sVendorCode);
                this.sIntialVal = this.sIntialVal.substring(this.sIntialVal.indexOf(123) + 1, this.sIntialVal.lastIndexOf(125));
                sToken = new StringTokenizer(this.sIntialVal, ",");
                this.updateCount = new int[sToken.countTokens()];
                int i = 0;
                while (sToken.hasMoreTokens()) {
                    this.updateCount[i++] = Integer.parseInt(sToken.nextToken());
                }
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage());
                throw new EETest.Fault("Set Up Failed", ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup Failed");
        }
    }

    public void testGetUpdateCounts() throws EETest.Fault {
        try {
            this.isThrown = false;
            this.loading(this.stmt);
        }
        catch (BatchUpdateException b) {
            this.isThrown = true;
            boolean isFailure = false;
            int[] retVal = b.getUpdateCounts();
            this.msg.setMsg("The Length of return array " + retVal.length);
            this.msg.setMsg("The Length of orginal array " + this.intialVal.length);
            if (retVal.length < 4) {
                for (int i = 0; i < retVal.length; ++i) {
                    this.msg.addOutputMsg(" " + this.intialVal[i], " " + retVal[i]);
                    if (this.intialVal[i] == retVal[i]) continue;
                    isFailure = true;
                    this.msg.printTestError(" getUpdateCount doesnot return the correct number of effected rows in the update count offset. ", "call to testGetUpdateCount Failed!");
                    break;
                }
            } else if (retVal.length == 4) {
                this.msg.addOutputMsg("-3", "" + retVal[3]);
                if (retVal[3] != -3) {
                    isFailure = true;
                    this.msg.printTestError("Driver Continues after error but does not return an error state of -3 in the correct update count offset. ", "call to testGetUpdateCount Failed!");
                }
            } else if (retVal.length > 4) {
                isFailure = true;
                this.msg.printTestError("More entries returned in update count than queries executed. ", "call to testGetUpdateCount Failed!");
            }
            if (isFailure) {
                throw new EETest.Fault("Call to getUpdateCounts is Failed!", b);
            }
            this.msg.setMsg(" getUpdateCounts returns the number of rows affected ");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getUpdateCounts Failed!");
        }
        catch (Exception ex) {
            this.msg.printError(ex, "Call to getUpdateCount Failed!");
        }
        if (!this.isThrown) {
            this.msg.printTestError("BatchUpdateException not thrown", "Call to getUpdateCount Fails");
        }
    }

    public void loading(Statement stmt) throws BatchUpdateException, SQLException, Exception {
        Statement state = this.conn.createStatement();
        int i = 0;
        ResultSet result = null;
        boolean isReturn = false;
        String sInsCount = null;
        try {
            String sUpdCoffee = this.sqlp.getProperty("Coffee_UpdTab");
            String sDelCoffee = this.sqlp.getProperty("Coffee_DelTab");
            String sInsCoffee = this.sqlp.getProperty("Coffee_InsTab");
            String sSelCoffee = this.sqlp.getProperty("Coffee_SelTab");
            String sUpdCount = this.sqlp.getProperty("Coffee_Updcount_Query");
            String sDelCount = this.sqlp.getProperty("Coffee_Delcount_Query");
            sInsCount = this.sqlp.getProperty("Coffee_Inscount_Query");
            result = state.executeQuery(sUpdCount);
            isReturn = result.next();
            if (isReturn) {
                this.intialVal[i++] = result.getInt(1);
            }
            if (isReturn = (result = state.executeQuery(sDelCount)).next()) {
                this.intialVal[i++] = result.getInt(1);
            }
            this.msg.setMsg("calling addBatch method");
            stmt.addBatch(sUpdCoffee);
            stmt.addBatch(sDelCoffee);
            stmt.addBatch(sInsCoffee);
            stmt.addBatch(sSelCoffee);
            this.msg.setMsg("calling executeBatch method");
            stmt.executeBatch();
        }
        catch (BatchUpdateException e) {
            this.msg.setMsg(e.toString());
            result = state.executeQuery(sInsCount);
            isReturn = result.next();
            if (isReturn) {
                this.intialVal[i++] = result.getInt(1);
            }
            throw e;
        }
    }

    public void testBatchUpdateException01() throws EETest.Fault {
        try {
            this.isThrown = false;
            throw new BatchUpdateException();
        }
        catch (BatchUpdateException b) {
            this.isThrown = true;
            if (b.getMessage() != null || b.getSQLState() != null || b.getErrorCode() != 0 || b.getUpdateCounts() != null) {
                this.msg.printSQLError(b, "BatchUpdateException() Constructor Fails");
            } else {
                this.msg.setMsg("BatchUpdateException() constructor is implemented");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "BatchUpdateException() Constructor Fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("BatchUpdateException not thrown", "Call to BatchUpdateException() constructor Fails");
        }
    }

    public void testBatchUpdateException02() throws EETest.Fault {
        try {
            this.isThrown = false;
            throw new BatchUpdateException(this.updateCount);
        }
        catch (BatchUpdateException b) {
            this.isThrown = true;
            if (b.getMessage() != null || b.getSQLState() != null || b.getErrorCode() != 0) {
                this.msg.printSQLError(b, "BatchUpdateException() Constructor Fails");
            } else if (!this.checkForUpdateCount(b.getUpdateCounts())) {
                this.msg.printTestError("BatchUpdateException(int []) Constructor Fails", "Call to BatchUpdateException(int []) Constructor Fails");
            } else {
                this.msg.setMsg("BatchUpdateException(int []) Constructor is implemented");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "BatchUpdateException() Constructor Fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("BatchUpdateException(int []) not thrown", "BatchUpdateException(int []) Constructor Fails");
        }
    }

    public void testBatchUpdateException03() throws EETest.Fault {
        try {
            this.isThrown = false;
            throw new BatchUpdateException(this.sReason, this.updateCount);
        }
        catch (BatchUpdateException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            if (b.getSQLState() != null || b.getErrorCode() != 0) {
                this.msg.printTestError("BatchUpdateException(String,int []) Constructor Fails", "Call to BatchUpdateException(String,int []) constructor Fails");
            } else if (!this.checkForUpdateCount(b.getUpdateCounts()) || !this.sReason.equals(b.getMessage())) {
                this.msg.printTestError("BatchUpdateException(String,int []) Constructor Fails", "Call to BatchUpdateException(String,int []) constructor Fails");
            } else {
                this.msg.setMsg("Call to BatchUpdateException(String,int []) constructor Passes");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "Call to BatchUpdateException(String,int []) constructor Fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("Call to BatchUpdateException(String,int []) constructor Fails", "Call to BatchUpdateException(String,int []) constructor Fails");
        }
    }

    public void testBatchUpdateException04() throws EETest.Fault {
        try {
            this.isThrown = false;
            throw new BatchUpdateException(this.sReason, this.sSqlState, this.updateCount);
        }
        catch (BatchUpdateException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            if (b.getErrorCode() != 0) {
                this.msg.printTestError("BatchUpdateException(string,string,int[]) Constructor Fails", "Call to BatchUpdateException(string,string,int[]) Constructor Fails");
            } else if (!(this.checkForUpdateCount(b.getUpdateCounts()) && this.sReason.equals(b.getMessage()) && this.sSqlState.equals(b.getSQLState()))) {
                this.msg.printTestError("BatchUpdateException(string,string,int[]) Constructor Fails", "Call to BatchUpdateException(string,string,int[]) Constructor Fails");
            } else {
                this.msg.setMsg("BatchUpdateException(string,string,int[]) Constructor is implemented");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "Call to BatchUpdateException(string,string,int[]) Constructor Fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("BatchUpdateException(string,string,int[]) Constructor not thrown", "Call to BatchUpdateException(string,string,int[]) Constructor Fails");
        }
    }

    public void testBatchUpdateException05() throws EETest.Fault {
        try {
            this.isThrown = false;
            throw new BatchUpdateException(this.sReason, this.sSqlState, this.vendorCode, this.updateCount);
        }
        catch (BatchUpdateException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            if (!(this.checkForUpdateCount(b.getUpdateCounts()) && this.sReason.equals(b.getMessage()) && this.sSqlState.equals(b.getSQLState()) && this.vendorCode == b.getErrorCode())) {
                this.msg.printTestError("BatchUpdateException(string,string,int,int []) Constructor Fails", "Call to BatchUpdateException(string,string,int,int[]) Constructor Fails");
            } else {
                this.msg.setMsg("BatchUpdateException(string,string,int,int []) Constructor is implemented");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "Call to BatchUpdateException(string,string,int,int[]) Constructor Fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("BatchUpdateException(string,string,int,int[]) Constructor Fails", "Call to BatchUpdateException(string,string,int,int[]) Constructor Fails");
        }
    }

    public boolean checkForUpdateCount(int[] retVal) {
        for (int i = 0; i < retVal.length; ++i) {
            this.msg.setMsg("IntialVal : " + this.updateCount[i] + " ReturnVal :" + retVal[i]);
            if (this.updateCount[i] == retVal[i]) continue;
            return false;
        }
        return true;
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.stmt.close();
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

