/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.session.servletejbjdbc;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.integration.util.DBSupport;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import java.util.Properties;

public class TellerBean
implements SessionBean {
    private SessionContext sctx = null;
    private DBSupport DB;
    public String tellerName;

    public void ejbCreate(String name, Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.tellerName = name;
        if (p != null) {
            try {
                TestUtil.logTrace((String)"initialize remote logging");
                TestUtil.init((Properties)p);
                this.DB.initDB(true, true);
            }
            catch (RemoteLoggingInitException e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new CreateException(e.getMessage());
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new CreateException("unable to initialize DB table " + e);
            }
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
        try {
            TestUtil.logTrace((String)"initialize database support access object");
            this.DB = new DBSupport();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to initialize DB. Exception: " + e);
        }
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void transfer(int from, int to, double amt) {
        TestUtil.logTrace((String)"transfer");
        this.withdraw(from, amt);
        this.deposit(to, amt);
    }

    public double balance(int acct) {
        double balance;
        TestUtil.logTrace((String)"balance");
        try {
            balance = this.DB.balance(acct);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in balance: " + e);
        }
        return balance;
    }

    public double deposit(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"deposit");
        try {
            balance = this.DB.deposit(acct, amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in deposit: " + e);
        }
        return balance;
    }

    public double withdraw(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"withdraw");
        try {
            balance = this.DB.withdraw(acct, amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in withdraw: " + e);
        }
        return balance;
    }

    public String getAllAccounts() {
        String accounts = null;
        try {
            accounts = this.DB.getAllAccounts();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in getAllAccounts: " + e);
        }
        return accounts;
    }
}

