/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.repositoryconnection;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.compiler.ModelingUnitCompiler;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modellinking.ModelingUnitLinkResolver;
import org.eclipse.mylyn.docs.intent.client.compiler.saver.CompilerInformationsSaver;
import org.eclipse.mylyn.docs.intent.client.compiler.utils.IntentCompilerInformationHolder;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.query.UnitGetter;

public class CompilationJob
extends Job {
    public static final String COMPILATION_JOB_NAME = "Compiling Intent Document";
    private Repository repository;
    private RepositoryObjectHandler repositoryObjectHandler;

    public CompilationJob(Repository repository, RepositoryObjectHandler repositoryObjectHandler) {
        super(COMPILATION_JOB_NAME);
        this.repository = repository;
        this.repositoryObjectHandler = repositoryObjectHandler;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        final RepositoryAdapter repositoryAdapter = this.repositoryObjectHandler.getRepositoryAdapter();
        if (repositoryAdapter != null) {
            repositoryAdapter.execute(new IntentCommand(){

                public void execute() {
                    CompilationJob.this.compile(monitor, repositoryAdapter);
                }
            });
        }
        return Status.OK_STATUS;
    }

    private void compile(IProgressMonitor monitor, RepositoryAdapter repositoryAdapter) {
        ModelingUnitCompiler compiler = null;
        ModelingUnitLinkResolver resolver = null;
        ArrayList<ModelingUnit> modelingUnitsToCompile = new ArrayList<ModelingUnit>();
        Resource resourceIndex = repositoryAdapter.getResource("/INTENT/IntentDocument");
        IntentCompilerInformationHolder informationHolder = IntentCompilerInformationHolder.getInstance();
        informationHolder.initialize();
        if (!monitor.isCanceled()) {
            try {
                resolver = new ModelingUnitLinkResolver(this.repository, informationHolder);
            }
            catch (RepositoryConnectionException e) {
                IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Compilation Failed during link resolver intialization", (Throwable)e);
            }
        }
        if (!monitor.isCanceled()) {
            compiler = new ModelingUnitCompiler(this.repository, resolver, informationHolder, BasicMonitor.toMonitor((IProgressMonitor)monitor));
            for (EObject resourceContent : resourceIndex.getContents()) {
                modelingUnitsToCompile.addAll((Collection<ModelingUnit>)UnitGetter.getAllModelingUnitsContainedInElement((EObject)resourceContent));
            }
        }
        if (!monitor.isCanceled()) {
            compiler.compile(modelingUnitsToCompile);
        }
        if (!monitor.isCanceled()) {
            IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Compiler] compiled " + informationHolder.getDeclaredResources().size() + " resources, " + informationHolder.getCompilationStatusList().size() + " errors detected");
            this.saveCompilationInformations(repositoryAdapter, informationHolder, monitor);
            IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Compiler] Saved on repository");
        }
    }

    public void saveCompilationInformations(RepositoryAdapter repositoryAdapter, IntentCompilerInformationHolder compilationInformationHolder, IProgressMonitor monitor) {
        repositoryAdapter.openSaveContext();
        CompilerInformationsSaver saver = new CompilerInformationsSaver(monitor);
        if (monitor != null && !monitor.isCanceled()) {
            saver.saveOnRepository(compilationInformationHolder, this.repositoryObjectHandler);
        }
        try {
            repositoryAdapter.save();
        }
        catch (ReadOnlyException readOnlyException) {
        }
        catch (SaveException saveException) {
            try {
                repositoryAdapter.undo();
            }
            catch (ReadOnlyException readOnlyException) {}
        }
        repositoryAdapter.closeContext();
    }
}

