/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.compare.match;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.match.statistic.MetamodelFilter;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.docs.intent.compare.match.FeatureInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentElementFilter
extends MetamodelFilter {
    protected final Map<EStructuralFeature, FeatureInformation> featuresToInformation = new EMFCompareMap();
    protected List<EStructuralFeature> unusedFeatures;
    private final Map<EClass, List<EStructuralFeature>> eClassToFilteredFeaturesList = new EMFCompareMap();
    private List<EStructuralFeature> featuresToIgnore;

    public void defineFeaturesToIgnore(List<EStructuralFeature> featuresToIgnoreList) {
        this.featuresToIgnore = featuresToIgnoreList;
    }

    public void analyseModel(EObject root) {
        this.processEObject(root);
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            this.processEObject(eObj);
        }
        this.unusedFeatures = null;
        this.eClassToFilteredFeaturesList.clear();
    }

    public void clear() {
        this.featuresToInformation.clear();
        this.unusedFeatures = null;
        this.eClassToFilteredFeaturesList.clear();
    }

    public List<EStructuralFeature> getFilteredFeatures(EObject eObj) {
        if (this.eClassToFilteredFeaturesList.containsKey(eObj.eClass())) {
            return this.eClassToFilteredFeaturesList.get(eObj.eClass());
        }
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        Collection<EStructuralFeature> unused = this.getUnusedFeatures();
        for (EStructuralFeature feat : eObj.eClass().getEAllStructuralFeatures()) {
            if (unused.contains(feat)) continue;
            result.add(feat);
        }
        this.eClassToFilteredFeaturesList.put(eObj.eClass(), result);
        return result;
    }

    private void buildUnusedFeatures() {
        this.unusedFeatures = new ArrayList<EStructuralFeature>();
        this.unusedFeatures.addAll(this.featuresToIgnore);
        for (EStructuralFeature feat : this.featuresToInformation.keySet()) {
            if (!this.featuresToInformation.get(feat).hasUniqueValue()) continue;
            this.unusedFeatures.add(this.featuresToInformation.get(feat).getFeature());
        }
    }

    private Collection<EStructuralFeature> getUnusedFeatures() {
        if (this.unusedFeatures == null) {
            this.buildUnusedFeatures();
        }
        return this.unusedFeatures;
    }

    private void processEObject(EObject eObj) {
        for (EStructuralFeature feat : eObj.eClass().getEAllStructuralFeatures()) {
            if (feat.isDerived()) continue;
            FeatureInformation featureInformation = this.featuresToInformation.get(feat);
            if (featureInformation == null) {
                featureInformation = new FeatureInformation(feat);
                this.featuresToInformation.put(feat, featureInformation);
            }
            Object value = eObj.eGet(feat);
            this.treatFeatureAccordingToType(feat, featureInformation, value);
        }
    }

    private void treatFeatureAccordingToType(EStructuralFeature feat, FeatureInformation featureInformation, Object value) {
        if (feat instanceof EReference) {
            if (feat.isMany()) {
                Collection values = (Collection)value;
                if (values.size() == 0) {
                    featureInformation.processValue("0");
                }
            } else if (value == null) {
                featureInformation.processValue("0");
            }
        } else if (value != null) {
            featureInformation.processValue(value.toString());
        } else {
            featureInformation.processValue("null");
        }
    }
}

