/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.replay.ReplayOperator;

@Experimental(value="Replaying of Multi is an experimental feature in Mutiny 1.4.0")
public class MultiReplay {
    private long numberOfItemsToReplay = Long.MAX_VALUE;

    public MultiReplay upTo(long numberOfItemsToReplay) {
        this.numberOfItemsToReplay = ParameterValidation.positive(numberOfItemsToReplay, "numberOfItemsToReplay");
        return this;
    }

    public <T> Multi<T> ofMulti(Multi<T> upstream) {
        return new ReplayOperator<T>(ParameterValidation.nonNull(upstream, "upstream"), this.numberOfItemsToReplay);
    }

    public <T> Multi<T> ofSeedAndMulti(Iterable<T> seed, Multi<T> upstream) {
        return new ReplayOperator<T>(ParameterValidation.nonNull(upstream, "upstream"), this.numberOfItemsToReplay, ParameterValidation.nonNull(seed, "seed"));
    }
}

