/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.context;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.util.Property;

public class ContextsTest
extends TestCase {
    private static final Property<String> P1 = Property.get((String)"p1", String.class).withDefault((Object)"bar");

    public void testEmptyContext() {
        ContextsTest.assertFalse((boolean)Contexts.EMPTY_CONTEXT.containsKey(P1));
        ContextsTest.assertNull((Object)Contexts.EMPTY_CONTEXT.get(P1));
        ContextsTest.assertEquals((String)"bar", (String)((String)Contexts.EMPTY_CONTEXT.getOrDefault(P1)));
        ContextsTest.assertFalse((boolean)Contexts.EMPTY_CONTEXT.containsKey(String.class));
        ContextsTest.assertNull((Object)Contexts.EMPTY_CONTEXT.get(String.class));
    }

    public void testSingletonContext1() {
        IContext ctx = Contexts.of(P1, null);
        ContextsTest.assertTrue((boolean)ctx.containsKey(P1));
        ContextsTest.assertNull((Object)ctx.get(P1));
        ContextsTest.assertNull((Object)ctx.getOrDefault(P1));
        ContextsTest.assertFalse((boolean)ctx.containsKey(String.class));
        ContextsTest.assertNull((Object)ctx.get(String.class));
    }

    public void testSingletonContext2() {
        IContext ctx = Contexts.of(String.class, null);
        ContextsTest.assertTrue((boolean)ctx.containsKey(String.class));
        ContextsTest.assertNull((Object)ctx.get(String.class));
        ContextsTest.assertFalse((boolean)ctx.containsKey(P1));
        ContextsTest.assertNull((Object)ctx.get(P1));
        ContextsTest.assertEquals((String)"bar", (String)((String)ctx.getOrDefault(P1)));
    }

    public void testSingletonContext3() {
        String value = "foo";
        IContext ctx = Contexts.of(P1, (Object)value);
        ContextsTest.assertTrue((boolean)ctx.containsKey(P1));
        ContextsTest.assertEquals((String)value, (String)((String)ctx.get(P1)));
        ContextsTest.assertEquals((String)value, (String)((String)ctx.getOrDefault(P1)));
        ContextsTest.assertFalse((boolean)ctx.containsKey(String.class));
        ContextsTest.assertNull((Object)ctx.get(String.class));
    }

    public void testSingletonContext4() {
        String value = "foo";
        IContext ctx = Contexts.of(String.class, (Object)value);
        ContextsTest.assertTrue((boolean)ctx.containsKey(String.class));
        ContextsTest.assertEquals((String)value, (String)((String)ctx.get(String.class)));
        ContextsTest.assertFalse((boolean)ctx.containsKey(P1));
        ContextsTest.assertNull((Object)ctx.get(P1));
        ContextsTest.assertEquals((String)"bar", (String)((String)ctx.getOrDefault(P1)));
    }

    public void testCompositeContext1() {
        IContext child = Contexts.of(P1, null);
        IContext ctx1 = Contexts.with((IContext[])new IContext[]{child, Contexts.EMPTY_CONTEXT});
        ContextsTest.assertTrue((boolean)ctx1.containsKey(P1));
        ContextsTest.assertNull((Object)ctx1.get(P1));
        ContextsTest.assertNull((Object)ctx1.getOrDefault(P1));
        IContext ctx2 = Contexts.with((IContext[])new IContext[]{Contexts.EMPTY_CONTEXT, child});
        ContextsTest.assertTrue((boolean)ctx2.containsKey(P1));
        ContextsTest.assertNull((Object)ctx2.get(P1));
        ContextsTest.assertNull((Object)ctx2.getOrDefault(P1));
    }

    public void testCompositeContext2() {
        IContext child = Contexts.of(String.class, null);
        IContext ctx1 = Contexts.with((IContext[])new IContext[]{child, Contexts.EMPTY_CONTEXT});
        ContextsTest.assertTrue((boolean)ctx1.containsKey(String.class));
        ContextsTest.assertNull((Object)ctx1.get(String.class));
        IContext ctx2 = Contexts.with((IContext[])new IContext[]{Contexts.EMPTY_CONTEXT, child});
        ContextsTest.assertTrue((boolean)ctx2.containsKey(String.class));
        ContextsTest.assertNull((Object)ctx2.get(String.class));
    }

    public void testCompositeContext3() {
        String value = "foo";
        IContext child = Contexts.of(P1, (Object)value);
        IContext ctx1 = Contexts.with((IContext[])new IContext[]{child, Contexts.EMPTY_CONTEXT});
        ContextsTest.assertTrue((boolean)ctx1.containsKey(P1));
        ContextsTest.assertSame((Object)value, (Object)ctx1.get(P1));
        ContextsTest.assertSame((Object)value, (Object)ctx1.getOrDefault(P1));
        IContext ctx2 = Contexts.with((IContext[])new IContext[]{Contexts.EMPTY_CONTEXT, child});
        ContextsTest.assertTrue((boolean)ctx2.containsKey(P1));
        ContextsTest.assertSame((Object)value, (Object)ctx2.get(P1));
        ContextsTest.assertSame((Object)value, (Object)ctx2.getOrDefault(P1));
    }

    public void testCompositeContext4() {
        String value = "foo";
        IContext child = Contexts.of(String.class, (Object)value);
        IContext ctx1 = Contexts.with((IContext[])new IContext[]{child, Contexts.EMPTY_CONTEXT});
        ContextsTest.assertTrue((boolean)ctx1.containsKey(String.class));
        ContextsTest.assertSame((Object)value, (Object)ctx1.get(String.class));
        IContext ctx2 = Contexts.with((IContext[])new IContext[]{Contexts.EMPTY_CONTEXT, child});
        ContextsTest.assertTrue((boolean)ctx2.containsKey(String.class));
        ContextsTest.assertSame((Object)value, (Object)ctx2.get(String.class));
    }

    public void testCompositeContext5() {
        String value1 = "foo";
        IContext child1 = Contexts.of(P1, (Object)value1);
        String value2 = "bar";
        IContext child2 = Contexts.of(P1, (Object)value2);
        IContext ctx1 = Contexts.with((IContext[])new IContext[]{child1, child2});
        ContextsTest.assertTrue((boolean)ctx1.containsKey(P1));
        ContextsTest.assertSame((Object)value1, (Object)ctx1.get(P1));
        ContextsTest.assertSame((Object)value1, (Object)ctx1.getOrDefault(P1));
        IContext ctx2 = Contexts.with((IContext[])new IContext[]{child2, child1});
        ContextsTest.assertTrue((boolean)ctx2.containsKey(P1));
        ContextsTest.assertSame((Object)value2, (Object)ctx2.get(P1));
        ContextsTest.assertSame((Object)value2, (Object)ctx2.getOrDefault(P1));
    }

    public void testCompositeContext6() {
        String value1 = "foo";
        IContext child1 = Contexts.of(String.class, (Object)value1);
        String value2 = "bar";
        IContext child2 = Contexts.of(String.class, (Object)value2);
        IContext ctx1 = Contexts.with((IContext[])new IContext[]{child1, child2});
        ContextsTest.assertTrue((boolean)ctx1.containsKey(String.class));
        ContextsTest.assertSame((Object)value1, (Object)ctx1.get(String.class));
        IContext ctx2 = Contexts.with((IContext[])new IContext[]{child2, child1});
        ContextsTest.assertTrue((boolean)ctx2.containsKey(String.class));
        ContextsTest.assertSame((Object)value2, (Object)ctx2.get(String.class));
    }

    public void testCompositeContext7() {
        IContext child1 = Contexts.of(P1, (Object)"foo");
        IContext child2 = Contexts.of(P1, null);
        IContext ctx = Contexts.with((IContext[])new IContext[]{Contexts.EMPTY_CONTEXT, Contexts.with((IContext[])new IContext[]{child2, child1})});
        ContextsTest.assertEquals(Arrays.asList(Contexts.EMPTY_CONTEXT, child2, child1), (Object)((Contexts.CompositeContext)ctx).contexts);
        ContextsTest.assertTrue((boolean)ctx.containsKey(P1));
        ContextsTest.assertNull((Object)ctx.get(P1));
        ContextsTest.assertNull((Object)ctx.getOrDefault(P1));
        ContextsTest.assertFalse((boolean)ctx.containsKey(String.class));
        ContextsTest.assertNull((Object)ctx.get(String.class));
    }

    public void testCompositeContext8() {
        IContext child1 = Contexts.of(String.class, (Object)"foo");
        IContext child2 = Contexts.of(String.class, null);
        IContext ctx = Contexts.with((IContext[])new IContext[]{Contexts.EMPTY_CONTEXT, Contexts.with((IContext[])new IContext[]{child2, child1})});
        ContextsTest.assertEquals(Arrays.asList(Contexts.EMPTY_CONTEXT, child2, child1), (Object)((Contexts.CompositeContext)ctx).contexts);
        ContextsTest.assertTrue((boolean)ctx.containsKey(String.class));
        ContextsTest.assertNull((Object)ctx.get(String.class));
        ContextsTest.assertFalse((boolean)ctx.containsKey(P1));
        ContextsTest.assertNull((Object)ctx.get(P1));
        ContextsTest.assertEquals((String)"bar", (String)((String)ctx.getOrDefault(P1)));
    }
}

