/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class SavedStateJob
extends WorkspaceJob {
    private final String pluginId;
    private final IResourceChangeListener listener;

    public SavedStateJob(String pluginId, IResourceChangeListener listener) {
        super("SavedState");
        this.pluginId = pluginId;
        if (this.pluginId == null) {
            throw new IllegalArgumentException();
        }
        this.listener = listener;
        if (this.listener == null) {
            throw new IllegalArgumentException();
        }
        this.setSystem(true);
        this.setPriority(20);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        ISavedState savedState = ResourcesPlugin.getWorkspace().addSaveParticipant(this.pluginId, (ISaveParticipant)new SaveParticipant());
        if (savedState != null) {
            savedState.processResourceChangeEvents(this.listener);
        }
        return Status.OK_STATUS;
    }

    private static class SaveParticipant
    implements ISaveParticipant {
        private SaveParticipant() {
        }

        public void doneSaving(ISaveContext context) {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
        }

        public void saving(ISaveContext context) throws CoreException {
            if (context.getKind() == 1) {
                context.needDelta();
            }
        }
    }
}

