/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.handly.util.BoundedLruCache;
import org.eclipse.handly.util.LruCache;

public class BoundedLruCacheTest
extends TestCase {
    public void test1() {
        BoundedLruCache cache = new BoundedLruCache(2);
        BoundedLruCacheTest.assertEquals((int)2, (int)cache.maxSize());
        cache.put((Object)"a", (Object)1);
        cache.put((Object)"b", (Object)2);
        cache.put((Object)"c", (Object)3);
        BoundedLruCacheTest.assertEquals((int)2, (int)cache.size());
        BoundedLruCacheTest.assertEquals(Arrays.asList("c", "b"), new ArrayList(cache.snapshot().keySet()));
        cache.setMaxSize(3);
        cache.put((Object)"d", (Object)4);
        BoundedLruCacheTest.assertEquals((int)3, (int)cache.size());
        BoundedLruCacheTest.assertEquals(Arrays.asList("d", "c", "b"), new ArrayList(cache.snapshot().keySet()));
        cache.setMaxSize(1);
        BoundedLruCacheTest.assertEquals((int)1, (int)cache.size());
        BoundedLruCacheTest.assertEquals((int)4, (int)((Integer)cache.get((Object)"d")));
        try {
            cache.setMaxSize(0);
            BoundedLruCacheTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test2() {
        BoundedLruCache<String, Integer> cache = new BoundedLruCache<String, Integer>(2){

            protected void evict(LruCache.Entry<String, Integer> entry) {
                if (((String)entry.key).equals("e")) {
                    this.clear();
                } else if ((Integer)entry.value != 777) {
                    super.evict(entry);
                }
            }
        };
        BoundedLruCacheTest.assertEquals((int)2, (int)cache.maxSize());
        cache.put((Object)"a", (Object)777);
        cache.put((Object)"b", (Object)1);
        cache.put((Object)"c", (Object)2);
        BoundedLruCacheTest.assertEquals((int)2, (int)cache.size());
        BoundedLruCacheTest.assertEquals(Arrays.asList("c", "a"), new ArrayList(cache.snapshot().keySet()));
        cache.setMaxSize(1);
        BoundedLruCacheTest.assertEquals((int)1, (int)cache.size());
        BoundedLruCacheTest.assertEquals((int)777, (int)((Integer)cache.get((Object)"a")));
        cache.put((Object)"d", (Object)777);
        cache.put((Object)"e", (Object)3);
        BoundedLruCacheTest.assertEquals((int)3, (int)cache.size());
        BoundedLruCacheTest.assertEquals(Arrays.asList("e", "d", "a"), new ArrayList(cache.snapshot().keySet()));
        cache.get((Object)"a");
        BoundedLruCacheTest.assertEquals(Arrays.asList("a", "e", "d"), new ArrayList(cache.snapshot().keySet()));
        cache.setMaxSize(2);
        BoundedLruCacheTest.assertTrue((boolean)cache.isEmpty());
    }

    public void test3() {
        try {
            new BoundedLruCache(0);
            BoundedLruCacheTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

