/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.impl;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.impl.ModuleImpl;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utils {
    private Utils() {
    }

    public static void identifyCyclicDependency(ModuleImpl m, Logger logger) {
        StringBuffer tree = new StringBuffer();
        tree.append(m.getName());
        Vector<Module> traversed = new Vector<Module>();
        boolean success = Utils.traverseAndFind(m, m, traversed);
        if (success) {
            traversed.remove(0);
            for (Module mod : traversed) {
                tree.append("-->" + mod.getName());
            }
            tree.append("-->" + m.getName());
            logger.log(Level.SEVERE, "Cyclic dependency : " + tree.toString());
        }
    }

    private static boolean traverseAndFind(Module toTraverse, ModuleImpl toFind, Vector<Module> traversed) {
        traversed.add(toTraverse);
        for (ModuleDependency md : toTraverse.getModuleDefinition().getDependencies()) {
            ModulesRegistry registry = toTraverse.getRegistry();
            for (Module mod : registry.getModules()) {
                if (!mod.getName().equals(md.getName()) || mod == null) continue;
                if (mod.getName().equals(toFind.getName())) {
                    return true;
                }
                if (!Utils.traverseAndFind(mod, toFind, traversed)) continue;
                return true;
            }
        }
        traversed.remove(toTraverse);
        return false;
    }
}

