/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.builtin.AbstractStaticallyDecorableBuiltInBean;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.event.FastEvent;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public class RequestContextControllerBean
extends AbstractStaticallyDecorableBuiltInBean<RequestContextController> {
    public RequestContextControllerBean(BeanManagerImpl beanManager) {
        super(beanManager, RequestContextController.class);
    }

    @Override
    protected RequestContextController newInstance(InjectionPoint ip, CreationalContext<RequestContextController> creationalContext) {
        return new InjectableRequestContextController(this.beanManager, this.getUnboundRequestContext());
    }

    private RequestContext getUnboundRequestContext() {
        Bean bean = this.beanManager.resolve(this.beanManager.getBeans((Type)((Object)RequestContext.class), UnboundLiteral.INSTANCE));
        WeldCreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (RequestContext)this.beanManager.getReference(bean, (Type)((Object)RequestContext.class), (CreationalContext<?>)ctx);
    }

    private static class InjectableRequestContextController
    implements RequestContextController {
        private final BeanManagerImpl beanManager;
        private final RequestContext requestContext;
        private final AtomicBoolean isActivator;
        private final FastEvent<Object> requestInitializedEvent;
        private final FastEvent<Object> requestBeforeDestroyedEvent;
        private final FastEvent<Object> requestDestroyedEvent;

        InjectableRequestContextController(BeanManagerImpl beanManager, RequestContext requestContext) {
            this.beanManager = beanManager;
            this.requestContext = requestContext;
            this.isActivator = new AtomicBoolean(false);
            this.requestInitializedEvent = FastEvent.of(Object.class, beanManager, Initialized.Literal.REQUEST);
            this.requestBeforeDestroyedEvent = FastEvent.of(Object.class, beanManager, BeforeDestroyed.Literal.REQUEST);
            this.requestDestroyedEvent = FastEvent.of(Object.class, beanManager, Destroyed.Literal.REQUEST);
        }

        @Override
        public boolean activate() {
            if (this.isRequestContextActive()) {
                return false;
            }
            this.requestContext.activate();
            this.requestInitializedEvent.fire(this.toString());
            this.isActivator.set(true);
            return true;
        }

        @Override
        public void deactivate() throws ContextNotActiveException {
            if (!this.isRequestContextActive()) {
                throw BeanManagerLogger.LOG.contextNotActive(RequestScoped.class);
            }
            if (this.isActivator.get()) {
                try {
                    this.requestBeforeDestroyedEvent.fire(this.toString());
                    this.requestContext.invalidate();
                    this.requestContext.deactivate();
                }
                finally {
                    this.requestDestroyedEvent.fire(this.toString());
                }
            }
        }

        private boolean isRequestContextActive() {
            return this.beanManager.isContextActive(RequestScoped.class);
        }
    }
}

