/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.LocalTransaction;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TxnConverter;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;

class LocalTxnConverter
extends TxnConverter {
    LocalTxnConverter(TransactionList transactionList, TxnLoggingStore store) {
        super(transactionList, store);
    }

    @Override
    String getPrefix() {
        return Thread.currentThread() + " ToTxnLogConverter.LocalTxnConverter.";
    }

    void convert(TransactionInformation txnInfo) throws BrokerException {
        int state;
        if (ToTxnLogConverter.DEBUG) {
            logger.log(4, this.getPrefix() + " convertLocalToTxnLogFormat " + txnInfo);
        }
        if ((state = txnInfo.getState().getState()) != 5) {
            String msg = this.getPrefix() + " convertLocalToTxnLogFormat: ignoring state  " + state + " for " + txnInfo;
            logger.log(8, msg);
        }
        TransactionWork txnWork = new TransactionWork();
        this.getSentMessages(txnInfo, txnWork);
        this.getConsumedMessages(txnInfo, txnWork);
        TransactionUID txid = txnInfo.getTID();
        JMQXid xid = txnInfo.getState().getXid();
        LocalTransaction localTxn = new LocalTransaction(txid, state, xid, txnWork);
        TransactionState newState = new TransactionState(txnInfo.getState());
        localTxn.setTransactionState(newState);
        this.store.logTxn(localTxn);
        this.deleteSentMessagesFromStore(txnWork);
    }
}

