/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ManagedJobConfig;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="configure-managed-jobs")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@AccessRequired(resource={"domain/managed-job-config"}, action={"update"})
public class ConfigureManagedJobs
implements AdminCommand {
    @Inject
    Domain domain;
    @Param(name="in-memory-retention-period", optional=true)
    String inMemoryRetentionPeriod;
    @Param(name="job-retention-period", optional=true)
    String jobRetentionPeriod;
    @Param(name="cleanup-initial-delay", optional=true)
    String initialDelay;
    @Param(name="cleanup-poll-interval", optional=true)
    String pollInterval;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        ManagedJobConfig managedJobConfig = (ManagedJobConfig)this.domain.getExtensionByType(ManagedJobConfig.class);
        if (managedJobConfig == null) {
            logger.warning("NCLS-CORE-00081");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(KernelLoggerInfo.getLogger().getResourceBundle().getString("NCLS-CORE-00081"));
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<ManagedJobConfig>(){

                @Override
                public Object run(ManagedJobConfig param) throws PropertyVetoException, TransactionFailure {
                    if (ConfigureManagedJobs.this.inMemoryRetentionPeriod != null) {
                        param.setInMemoryRetentionPeriod(ConfigureManagedJobs.this.inMemoryRetentionPeriod);
                    }
                    if (ConfigureManagedJobs.this.jobRetentionPeriod != null) {
                        param.setJobRetentionPeriod(ConfigureManagedJobs.this.jobRetentionPeriod);
                    }
                    if (ConfigureManagedJobs.this.pollInterval != null) {
                        param.setPollInterval(ConfigureManagedJobs.this.pollInterval);
                    }
                    if (ConfigureManagedJobs.this.initialDelay != null) {
                        param.setInitialDelay(ConfigureManagedJobs.this.initialDelay);
                    }
                    return param;
                }
            }, managedJobConfig);
        }
        catch (TransactionFailure e) {
            logger.warning("NCLS-CORE-00080");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }
}

