/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CompletedJob;
import com.sun.enterprise.v3.admin.JobManagerService;
import java.io.File;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobInfos;
import org.glassfish.api.admin.progress.JobPersistence;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="job-persistence")
public class JobPersistenceService
implements JobPersistence {
    protected Marshaller jaxbMarshaller;
    protected Unmarshaller jaxbUnmarshaller;
    protected JobInfos jobInfos;
    @Inject
    private JobManagerService jobManager;
    protected JAXBContext jaxbContext;
    protected static final Logger logger = KernelLoggerInfo.getLogger();
    protected static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(JobPersistenceService.class);

    @Override
    public void persist(Object obj) {
        JobInfo jobInfo = (JobInfo)obj;
        this.jobInfos = this.jobManager.getCompletedJobs(this.jobManager.getJobsFile());
        this.doPersist(this.jobInfos, jobInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPersist(JobInfos jobInfos, JobInfo jobInfo) {
        File file;
        File file2 = file = jobInfo.getJobsFile();
        synchronized (file2) {
            if (jobInfos == null) {
                jobInfos = new JobInfos();
            }
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{JobInfos.class});
                this.jaxbMarshaller = jaxbContext.createMarshaller();
                this.jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                CopyOnWriteArrayList<JobInfo> jobList = new CopyOnWriteArrayList<JobInfo>(jobInfos.getJobInfoList());
                jobInfos.setJobInfoList(jobList);
                jobList.add(jobInfo);
                this.jaxbMarshaller.marshal((Object)jobInfos, file);
                this.jobManager.addToCompletedJobs(new CompletedJob(jobInfo.jobId, jobInfo.commandCompletionDate, jobInfo.getJobsFile()));
                this.jobManager.purgeJob(jobInfo.jobId);
            }
            catch (JAXBException e) {
                throw new RuntimeException(adminStrings.getLocalString("error.persisting.jobs", "Error while persisting jobs", new Object[]{jobInfo.jobId, e.getLocalizedMessage()}), e);
            }
        }
    }
}

