/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.Destination;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jms.ra.DirectConnection;
import java.util.logging.Logger;
import javax.jms.JMSException;

public abstract class TemporaryDestination
extends Destination {
    private static final transient String _className = "com.sun.messaging.jms.ra.TemporaryDestination";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSConnection = "javax.jms.Connection.mqjmsra";
    private static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final transient Logger _loggerJC = Logger.getLogger("javax.jms.Connection.mqjmsra");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_TD";
    private static final transient String _lgrMID_EET = "MQJMSRA_TD1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_TD1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_TD2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_TD3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_TD4001: ";
    private transient DirectConnection dc = null;
    private com.sun.messaging.jmq.jmsservice.Destination destination = null;
    private boolean deleted = false;
    private int consumer_count = 0;

    protected TemporaryDestination(DirectConnection dc, Destination.Type _type, Destination.TemporaryType _tType) throws JMSException {
        super("temporary_destination://" + (Object)((Object)_tType) + "/" + dc._getConnectionIdentifierForTemporaryDestination() + "/" + dc.nextTemporaryDestinationId());
        String _name = super.getName();
        this.dc = dc;
        this.destination = new com.sun.messaging.jmq.jmsservice.Destination(_name, _type, Destination.Life.TEMPORARY);
    }

    protected TemporaryDestination(String _name, Destination.Type _type) throws JMSException {
        super(_name);
        this.destination = new com.sun.messaging.jmq.jmsservice.Destination(_name, _type, Destination.Life.TEMPORARY);
    }

    public void delete() throws JMSException {
        this._delete();
        this.dc.removeTemporaryDestination(this);
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    public boolean _isDeleted() {
        return this.deleted;
    }

    protected com.sun.messaging.jmq.jmsservice.Destination _getDestination() {
        return this.destination;
    }

    protected void _delete() throws JMSException {
        if (this.dc == null) {
            String deleteMsg = "MQJMSRA_TD4001: delete():Can only delete user created TemporaryDestinations";
            _loggerJC.warning(deleteMsg);
            throw new JMSException(deleteMsg);
        }
        if (this.dc._hasConsumers(this)) {
            String deleteMsg = "MQJMSRA_TD4001: delete():Cannot delete TemporaryDestination with active consumers";
            _loggerJC.warning(deleteMsg);
            throw new JMSException(deleteMsg);
        }
        this.dc._deleteDestination(this, this.destination);
        this.deleted = true;
    }

    protected int _incrementConsumerCount() {
        return ++this.consumer_count;
    }

    protected int _decrementConsumerCount() {
        --this.consumer_count;
        assert (this.consumer_count >= 0);
        return this.consumer_count;
    }

    protected int _getConsumerCount() {
        return this.consumer_count;
    }
}

