/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.zip;

import com.sun.messaging.jmq.jmsclient.Debug;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class Compressor {
    private Deflater deflater = new Deflater();
    private static Compressor compressor = new Compressor();
    private boolean debug = Boolean.getBoolean("imq.zip.debug");

    private Compressor() {
    }

    public static Compressor getInstance() {
        return compressor;
    }

    public synchronized int compress(byte[] body, int offset, int length, OutputStream os) throws IOException {
        int compressedLength = -1;
        Deflater def = this.getDefaultDeflater();
        DeflaterOutputStream defos = new DeflaterOutputStream(os, def);
        defos.write(body, offset, length);
        defos.finish();
        int totalIn = def.getTotalIn();
        compressedLength = def.getTotalOut();
        if (this.debug) {
            Debug.getPrintStream().println("**** compressor total in: " + totalIn);
            Debug.getPrintStream().println("**** compressor total out: " + compressedLength);
        }
        def.reset();
        return compressedLength;
    }

    private Deflater getDeflater(boolean noWrap, int strategy, int level) {
        Deflater def = null;
        if (noWrap) {
            throw new RuntimeException("No wrap deflater is not Unsupported.");
        }
        def = this.deflater;
        def.setStrategy(strategy);
        def.setLevel(level);
        return def;
    }

    private Deflater getDefaultDeflater() {
        return this.getDeflater(false, 0, -1);
    }
}

