/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.logging.LogCleanerUtil;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletMapping;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.MappingImpl;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationDispatcherForward;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationRequest;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.core.DispatchTargetsInfo;
import org.apache.catalina.core.RequestFacadeHelper;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.MessageBytes;

public final class ApplicationDispatcher
implements RequestDispatcher {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final String LAST_DISPATCH_REQUEST_PATH_ATTR = "org.apache.catalina.core.ApplicationDispatcher.lastDispatchRequestPathAttr";
    private Boolean crossContextFlag = null;
    private Context context = null;
    private static final String info = "org.apache.catalina.core.ApplicationDispatcher/1.0";
    private String name = null;
    private String pathInfo = null;
    private String queryString = null;
    private String requestURI = null;
    private String servletPath = null;
    private Wrapper wrapper = null;
    private HttpServletMapping mappingForDispatch;

    public ApplicationDispatcher(Wrapper wrapper, HttpServletMapping mappingForDispatch, String requestURI, String servletPath, String pathInfo, String queryString, String name) {
        this.wrapper = wrapper;
        this.mappingForDispatch = mappingForDispatch;
        this.context = (Context)wrapper.getParent();
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.name = name;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "servletPath= " + LogCleanerUtil.neutralizeForLog((String)this.servletPath) + ", pathInfo= " + LogCleanerUtil.neutralizeForLog((String)this.pathInfo) + ", queryString= " + LogCleanerUtil.neutralizeForLog((String)queryString) + ", name= " + LogCleanerUtil.neutralizeForLog((String)this.name));
        }
    }

    public String getInfo() {
        return info;
    }

    @Override
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response, DispatcherType.FORWARD);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) throws ServletException, IOException {
        boolean isCommit;
        if (DispatcherType.FORWARD != dispatcherType && DispatcherType.ERROR != dispatcherType && DispatcherType.ASYNC != dispatcherType) {
            throw new IllegalArgumentException("Illegal dispatcher type");
        }
        boolean bl = isCommit = DispatcherType.FORWARD == dispatcherType || DispatcherType.ERROR == dispatcherType;
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedDispatch dp = new PrivilegedDispatch(request, response, dispatcherType);
                AccessController.doPrivileged(dp);
                if (!isCommit || request.isAsyncStarted()) return;
                ApplicationDispatcherForward.commit(request, response, this.context, this.wrapper);
                return;
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (!(e instanceof ServletException)) throw (IOException)e;
                throw (ServletException)e;
            }
        } else {
            this.doDispatch(request, response, dispatcherType);
            if (!isCommit || request.isAsyncStarted()) return;
            ApplicationDispatcherForward.commit(request, response, this.context, this.wrapper);
        }
    }

    private void doDispatch(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) throws ServletException, IOException {
        if (DispatcherType.ASYNC != dispatcherType) {
            if (response.isCommitted()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Forward on committed response --> ISE");
                }
                throw new IllegalStateException(rb.getString("AS-WEB-CORE-00086"));
            }
            try {
                response.resetBuffer();
            }
            catch (IllegalStateException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Forward resetBuffer() returned ISE: " + e.toString(), e);
                }
                throw e;
            }
        }
        if (DispatcherType.INCLUDE != dispatcherType) {
            DispatchTargetsInfo dtInfo = (DispatchTargetsInfo)request.getAttribute(LAST_DISPATCH_REQUEST_PATH_ATTR);
            if (dtInfo == null) {
                dtInfo = new DispatchTargetsInfo();
                request.setAttribute(LAST_DISPATCH_REQUEST_PATH_ATTR, dtInfo);
            }
            if (this.servletPath == null && this.pathInfo == null) {
                dtInfo.addDispatchTarget(this.wrapper.getServletName(), true);
            } else {
                dtInfo.addDispatchTarget(this.getCombinedPath(), false);
            }
        }
        State state = new State(request, response, dispatcherType);
        ServletRequest sr = this.wrapRequest(state);
        this.wrapResponse(state);
        HttpServletRequest hrequest = state.hrequest;
        HttpServletResponse hresponse = state.hresponse;
        if (hrequest == null || hresponse == null) {
            this.processRequest(request, response, state);
        } else if (this.servletPath == null && this.pathInfo == null) {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)sr;
            wrequest.setRequestURI(hrequest.getRequestURI());
            wrequest.setContextPath(hrequest.getContextPath());
            wrequest.setServletPath(hrequest.getServletPath());
            wrequest.setPathInfo(hrequest.getPathInfo());
            wrequest.setQueryString(hrequest.getQueryString());
            this.processRequest(request, response, state);
        } else {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)sr;
            if (DispatcherType.FORWARD == dispatcherType && hrequest.getAttribute("javax.servlet.forward.request_uri") == null || DispatcherType.ASYNC == dispatcherType && hrequest.getAttribute("javax.servlet.async.request_uri") == null) {
                wrequest.initSpecialAttributes(hrequest.getRequestURI(), hrequest.getContextPath(), hrequest.getServletPath(), hrequest.getPathInfo(), hrequest.getQueryString());
            }
            String targetContextPath = this.context.getPath();
            RequestFacadeHelper reqFacHelper = RequestFacadeHelper.getInstance(wrequest);
            String originContextPath = null;
            originContextPath = reqFacHelper != null ? reqFacHelper.getContextPath(false) : wrequest.getContextPath();
            if (originContextPath != null && originContextPath.equals(targetContextPath)) {
                targetContextPath = hrequest.getContextPath();
            }
            wrequest.setContextPath(targetContextPath);
            wrequest.setRequestURI(this.requestURI);
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            this.processRequest(request, response, state);
        }
        this.recycleRequestWrapper(state);
        this.unwrapRequest(state);
        this.unwrapResponse(state);
    }

    private void processRequest(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        if (request != null) {
            if (state.dispatcherType != DispatcherType.ERROR) {
                state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
                this.invoke(state.outerRequest, response, state);
            } else {
                this.invoke(state.outerRequest, response, state);
            }
        }
    }

    private String getCombinedPath() {
        if (this.servletPath == null) {
            return null;
        }
        if (this.pathInfo == null) {
            return this.servletPath;
        }
        return this.servletPath + this.pathInfo;
    }

    @Override
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        State state = new State(request, response, DispatcherType.INCLUDE);
        this.wrapResponse(state);
        if (this.name != null) {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                wrequest.setServletPath(this.servletPath);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
            try {
                this.invoke(state.outerRequest, state.outerResponse, state);
            }
            finally {
                this.recycleRequestWrapper(state);
                this.unwrapRequest(state);
                this.unwrapResponse(state);
            }
        }
        ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
        wrequest.initSpecialAttributes(this.requestURI, this.context.getPath(), this.servletPath, this.pathInfo, this.queryString);
        wrequest.setQueryParams(this.queryString);
        wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
        try {
            this.invoke(state.outerRequest, state.outerResponse, state);
        }
        finally {
            this.recycleRequestWrapper(state);
            this.unwrapRequest(state);
            this.unwrapResponse(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        boolean crossContext = false;
        if (this.crossContextFlag != null && this.crossContextFlag.booleanValue()) {
            crossContext = true;
        }
        if (crossContext) {
            this.context.getManager().lockSession(request);
        }
        try {
            if (crossContext) {
                this.context.getManager().preRequestDispatcherProcess(request, response);
            }
            this.doInvoke(request, response, crossContext, state);
            if (crossContext) {
                this.context.getManager().postRequestDispatcherProcess(request, response);
            }
        }
        finally {
            if (crossContext) {
                this.context.getManager().unlockSession(request);
            }
            this.crossContextFlag = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvoke(ServletRequest request, ServletResponse response, boolean crossContext, State state) throws IOException, ServletException {
        ClassLoader oldCCL = null;
        if (crossContext) {
            oldCCL = Thread.currentThread().getContextClassLoader();
            ClassLoader contextClassLoader = this.context.getLoader().getClassLoader();
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        HttpServletResponse hresponse = state.hresponse;
        Servlet servlet = null;
        IOException ioException = null;
        ServletException servletException = null;
        RuntimeException runtimeException = null;
        boolean unavailable = false;
        if (this.wrapper.isUnavailable()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00087"), this.wrapper.getName());
            log.log(Level.WARNING, msg);
            if (hresponse != null) {
                long available = this.wrapper.getAvailable();
                if (available > 0L && available < Long.MAX_VALUE) {
                    hresponse.setDateHeader("Retry-After", available);
                }
                hresponse.sendError(503, msg);
            }
            unavailable = true;
        }
        String allocateServletMsg = MessageFormat.format(rb.getString("AS-WEB-CORE-00088"), this.wrapper.getName());
        try {
            if (!unavailable) {
                servlet = this.wrapper.allocate();
            }
        }
        catch (ServletException e) {
            log.log(Level.SEVERE, allocateServletMsg, StandardWrapper.getRootCause(e));
            servletException = e;
            servlet = null;
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, allocateServletMsg, e);
            servletException = new ServletException(allocateServletMsg, e);
            servlet = null;
        }
        ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
        ApplicationFilterChain filterChain = factory.createFilterChain(request, this.wrapper, servlet);
        InstanceSupport support = ((StandardWrapper)this.wrapper).getInstanceSupport();
        String servletServiceExceptionMsg = MessageFormat.format(rb.getString("AS-WEB-CORE-00090"), this.wrapper.getName());
        RequestFacadeHelper reqFacHelper = RequestFacadeHelper.getInstance(request);
        try {
            String jspFile = this.wrapper.getJspFile();
            if (jspFile != null) {
                request.setAttribute("org.apache.catalina.jsp_file", jspFile);
            }
            support.fireInstanceEvent(InstanceEvent.EventType.BEFORE_DISPATCH_EVENT, servlet, request, response);
            if (servlet != null) {
                if (reqFacHelper != null) {
                    reqFacHelper.incrementDispatchDepth();
                    if (reqFacHelper.isMaxDispatchDepthReached()) {
                        String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00089"), org.apache.catalina.connector.Request.getMaxDispatchDepth());
                        throw new ServletException(msg);
                    }
                }
                if (filterChain != null) {
                    filterChain.setWrapper((StandardWrapper)this.wrapper);
                    filterChain.doFilter(request, response);
                } else {
                    ((StandardWrapper)this.wrapper).service(request, response, servlet);
                }
            }
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
        }
        catch (ClientAbortException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            ioException = e;
        }
        catch (IOException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            log.log(Level.WARNING, servletServiceExceptionMsg, e);
            ioException = e;
        }
        catch (UnavailableException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            log.log(Level.WARNING, servletServiceExceptionMsg, e);
            servletException = e;
            this.wrapper.unavailable(e);
        }
        catch (ServletException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            Throwable rootCause = StandardWrapper.getRootCause(e);
            if (!(rootCause instanceof ClientAbortException)) {
                log.log(Level.WARNING, servletServiceExceptionMsg, rootCause);
            }
            servletException = e;
        }
        catch (RuntimeException e) {
            support.fireInstanceEvent(InstanceEvent.EventType.AFTER_DISPATCH_EVENT, servlet, request, response);
            log.log(Level.WARNING, servletServiceExceptionMsg, e);
            runtimeException = e;
        }
        finally {
            if (reqFacHelper != null) {
                reqFacHelper.decrementDispatchDepth();
            }
        }
        try {
            if (filterChain != null) {
                filterChain.release();
            }
        }
        catch (Throwable e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00091"), this.wrapper.getName());
            log.log(Level.SEVERE, msg, e);
        }
        String deallocateServletExceptionMsg = MessageFormat.format(rb.getString("AS-WEB-CORE-00088"), this.wrapper.getName());
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException e) {
            log.log(Level.SEVERE, deallocateServletExceptionMsg, e);
            servletException = e;
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, deallocateServletExceptionMsg, e);
            servletException = new ServletException(deallocateServletExceptionMsg, e);
        }
        if (oldCCL != null) {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        if (ioException != null) {
            throw ioException;
        }
        if (servletException != null) {
            throw servletException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void unwrapRequest(State state) {
        if (state.wrapRequest == null) {
            return;
        }
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null && !(current instanceof Request) && !(current instanceof RequestFacade)) {
            if (current == state.wrapRequest) {
                ServletRequest next = ((ServletRequestWrapper)current).getRequest();
                if (previous == null) {
                    state.outerRequest = next;
                    break;
                }
                ((ServletRequestWrapper)previous).setRequest(next);
                break;
            }
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
    }

    private void unwrapResponse(State state) {
        if (state.wrapResponse == null) {
            return;
        }
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null && !(current instanceof Response) && !(current instanceof ResponseFacade)) {
            if (current == state.wrapResponse) {
                ServletResponse next = ((ServletResponseWrapper)current).getResponse();
                if (previous == null) {
                    state.outerResponse = next;
                    break;
                }
                ((ServletResponseWrapper)previous).setResponse(next);
                break;
            }
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
    }

    private ServletRequest wrapRequest(State state) {
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null) {
            if (state.hrequest == null && current instanceof HttpServletRequest) {
                state.hrequest = (HttpServletRequest)current;
            }
            if ("org.apache.catalina.servlets.InvokerHttpRequest".equals(current.getClass().getName()) || !(current instanceof ServletRequestWrapper) || current instanceof ApplicationHttpRequest || current instanceof ApplicationRequest) break;
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        ServletRequestWrapper wrapper = null;
        if (current instanceof ApplicationHttpRequest || current instanceof org.apache.catalina.connector.Request || current instanceof HttpServletRequest) {
            HttpServletRequest hcurrent = (HttpServletRequest)current;
            boolean crossContext = false;
            if (state.outerRequest instanceof ApplicationHttpRequest || state.outerRequest instanceof org.apache.catalina.connector.Request || state.outerRequest instanceof HttpServletRequest) {
                HttpServletRequest houterRequest = (HttpServletRequest)state.outerRequest;
                Object contextPath = houterRequest.getAttribute("javax.servlet.include.context_path");
                if (contextPath == null) {
                    contextPath = houterRequest.getContextPath();
                }
                crossContext = !this.context.getPath().equals(contextPath);
            }
            this.crossContextFlag = crossContext;
            if (this.name != null) {
                this.mappingForDispatch = this.computeNamedDispatchHttpServletMapping(this.context, hcurrent);
            }
            if (DispatcherType.ASYNC.equals((Object)state.dispatcherType)) {
                this.mappingForDispatch = hcurrent.getHttpServletMapping();
            }
            wrapper = new ApplicationHttpRequest(hcurrent, this.context, crossContext, this.mappingForDispatch, state.dispatcherType);
        } else {
            wrapper = new ApplicationRequest(current);
        }
        if (previous == null) {
            state.outerRequest = wrapper;
        } else {
            ((ServletRequestWrapper)previous).setRequest(wrapper);
        }
        state.wrapRequest = wrapper;
        return wrapper;
    }

    private HttpServletMapping computeNamedDispatchHttpServletMapping(Context context, HttpServletRequest hcurrent) {
        MappingImpl result = null;
        Mapper mapper = context.getMapper();
        if (null == mapper) {
            return null;
        }
        MessageBytes uriMB = MessageBytes.newInstance();
        CharChunk cc = uriMB.getCharChunk();
        MappingData mappingData = new MappingData();
        String requestURI = hcurrent.getRequestURI();
        if (null == requestURI) {
            return null;
        }
        try {
            cc.append(requestURI, 0, requestURI.length());
            mapper.map(uriMB, mappingData);
        }
        catch (Exception ex) {
            return null;
        }
        result = new MappingImpl(mappingData);
        return result;
    }

    private ServletResponse wrapResponse(State state) {
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null) {
            if (state.hresponse == null && current instanceof HttpServletResponse) {
                state.hresponse = (HttpServletResponse)current;
                if (DispatcherType.INCLUDE != state.dispatcherType) {
                    return null;
                }
            }
            if (!(current instanceof ServletResponseWrapper) || current instanceof ApplicationHttpResponse || current instanceof ApplicationResponse) break;
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
        ServletResponseWrapper wrapper = null;
        wrapper = current instanceof ApplicationHttpResponse || current instanceof HttpResponse || current instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)current, DispatcherType.INCLUDE == state.dispatcherType) : new ApplicationResponse(current, DispatcherType.INCLUDE == state.dispatcherType);
        if (previous == null) {
            state.outerResponse = wrapper;
        } else {
            ((ServletResponseWrapper)previous).setResponse(wrapper);
        }
        state.wrapResponse = wrapper;
        return wrapper;
    }

    private void recycleRequestWrapper(State state) {
        if (state.wrapRequest instanceof ApplicationHttpRequest) {
            ((ApplicationHttpRequest)state.wrapRequest).recycle();
        }
    }

    private static class State {
        ServletRequest outerRequest = null;
        ServletResponse outerResponse = null;
        ServletRequest wrapRequest = null;
        ServletResponse wrapResponse = null;
        DispatcherType dispatcherType;
        HttpServletRequest hrequest = null;
        HttpServletResponse hresponse = null;

        State(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) {
            this.outerRequest = request;
            this.outerResponse = response;
            this.dispatcherType = dispatcherType;
        }
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction<Void> {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public Void run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedDispatch
    implements PrivilegedExceptionAction<Void> {
        private ServletRequest request;
        private ServletResponse response;
        private DispatcherType dispatcherType;

        PrivilegedDispatch(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) {
            this.request = request;
            this.response = response;
            this.dispatcherType = dispatcherType;
        }

        @Override
        public Void run() throws Exception {
            ApplicationDispatcher.this.doDispatch(this.request, this.response, this.dispatcherType);
            return null;
        }
    }
}

