/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.beans;

import com.sun.faces.config.beans.FeatureBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.util.ToolsUtil;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RenderKitBean
extends FeatureBean {
    private static final Logger logger = ToolsUtil.getLogger("javax.enterprise.resource.webcontainer.jsf.config.beans");
    private String renderKitClass;
    private String renderKitId = "HTML_BASIC";
    private Map<String, RendererBean> renderers = new TreeMap<String, RendererBean>();

    public String getRenderKitClass() {
        return this.renderKitClass;
    }

    public void setRenderKitClass(String renderKitClass) {
        this.renderKitClass = renderKitClass;
    }

    public String getRenderKitId() {
        return this.renderKitId;
    }

    public void setRenderKitId(String renderKitId) {
        this.renderKitId = renderKitId;
    }

    public void addRenderer(RendererBean descriptor) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addRenderer(" + descriptor.getComponentFamily() + "," + descriptor.getRendererType() + ")");
        }
        this.renderers.put(descriptor.getComponentFamily() + "|" + descriptor.getRendererType(), descriptor);
    }

    public RendererBean getRenderer(String componentFamily, String rendererType) {
        return this.renderers.get(componentFamily + "|" + rendererType);
    }

    public RendererBean[] getRenderers() {
        RendererBean[] results = new RendererBean[this.renderers.size()];
        return this.renderers.values().toArray(results);
    }

    public void removeRenderer(RendererBean descriptor) {
        this.renderers.remove(descriptor.getComponentFamily() + "|" + descriptor.getRendererType());
    }
}

