/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.persist.api.NoPersistPartitionedStoreImpl;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ConsumerSpi;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.NFLPriorityFifoSet;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Consumer
implements ConsumerSpi,
EventBroadcaster,
Serializable {
    transient Logger logger = Globals.getLogger();
    static final long serialVersionUID = 3353669107150988952L;
    public static final String PREFETCH = "prefetch";
    private static boolean DEBUG = false;
    private static final FaultInjection FI = FaultInjection.getInjection();
    protected static final boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG;
    protected static final boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG_CLUSTER_TXN || DEBUG;
    private transient boolean useConsumerFlowControl = false;
    private transient int msgsToConsumer = 0;
    transient Map<PartitionedStore, LinkedHashSet<Destination>> destinationMap = Collections.synchronizedMap(new LinkedHashMap());
    protected transient BrokerResources br = Globals.getBrokerResources();
    private static boolean C_FLOW_CONTROL_ALLOWED = Globals.getConfig().getBooleanProperty("imq.destination.flowControlAllowed", true);
    long lastAckTime = 0L;
    SessionUID sessionuid = null;
    DestinationUID dest;
    ConsumerUID uid;
    transient ConsumerUID stored_uid;
    ConnectionUID conuid = null;
    transient boolean valid = true;
    transient boolean active = true;
    transient boolean paused = false;
    transient int pauseCnt = 0;
    transient int pauseFlowCnt = 0;
    transient int resumeFlowCnt = 0;
    boolean noLocal = false;
    transient boolean busy = false;
    transient Subscription parent = null;
    transient boolean isSpecialRemote = false;
    transient boolean isFailover = false;
    transient int position = 0;
    transient int lockPosition = -1;
    transient EventBroadcastHelper evb = null;
    boolean ackMsgsOnDestroy = true;
    transient int flowCount = 0;
    transient boolean flowPaused = false;
    transient int msgsOut = 0;
    transient int prefetch = -1;
    transient int remotePrefetch = -1;
    transient String creator = null;
    transient boolean requestedRecreation = false;
    protected String selstr = null;
    protected transient Selector selector = null;
    transient NFLPriorityFifoSet msgs;
    protected transient Map<PartitionedStore, SubSet> parentListMap = Collections.synchronizedMap(new LinkedHashMap());
    protected transient Map plistenerMap = Collections.synchronizedMap(new LinkedHashMap());
    private transient Object mlistener = null;
    private transient boolean localConsumerCreationReady = false;
    private static final int DEFAULT_MSG_MAX_CONSECUTIVE_ROLLBACKS = 0;
    public static final int MSG_MAX_CONSECUTIVE_ROLLBACKS = Globals.getConfig().getIntProperty("imq.transaction.message.maxConsecutiveRollbacks", 0);
    private transient HashMap messageRollbacks = new HashMap();
    transient EventListener busylistener = null;
    transient EventListener removeListener = null;
    private transient Object expiredID = null;
    private transient Object purgedID = null;
    private transient Object removedID1 = null;
    private transient Object removedID2 = null;
    private transient Object removedID3 = null;
    private transient Object removedID4 = null;
    transient Object destroyLock = new Object();
    HashSet remotePendingDelivered = new HashSet();
    private transient ArrayList remotePendingResumes = new ArrayList();
    private transient Hashtable lastDestMetrics = new Hashtable();
    private static Map consumers = Collections.synchronizedMap(new HashMap());
    protected static final Set wildcardConsumers = Collections.synchronizedSet(new HashSet());

    public void addRemoveListener(EventBroadcaster l) {
        this.expiredID = l.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.EXPIRED, null);
        this.purgedID = l.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.PURGED, null);
        this.removedID1 = l.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.REMOVED_OLDEST, null);
        this.removedID2 = l.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.REMOVED_LOW_PRIORITY, null);
        this.removedID3 = l.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.REMOVED_REJECTED, null);
        this.removedID4 = l.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.REMOVED_OTHER, null);
    }

    public void removeRemoveListener(EventBroadcaster l) {
        l.removeEventListener(this.expiredID);
        l.removeEventListener(this.purgedID);
        l.removeEventListener(this.removedID1);
        l.removeEventListener(this.removedID2);
        l.removeEventListener(this.removedID3);
        l.removeEventListener(this.removedID4);
    }

    private boolean getParentBusy() {
        return this.parentListMap.size() > 0 && !Consumer.isParentListEmpty(this.parentListMap) || this.parent != null && this.parent.isBusy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isParentListEmpty(Map<PartitionedStore, SubSet> map) {
        Map<PartitionedStore, SubSet> map2 = map;
        synchronized (map2) {
            Iterator<SubSet> itr = map.values().iterator();
            while (itr.hasNext()) {
                if (itr.next().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SubSet getNonEmptyParentList(Map<PartitionedStore, SubSet> map, SubSet lastpl) {
        SubSet pl2 = null;
        SubSet foundpl = null;
        Map<PartitionedStore, SubSet> map2 = map;
        synchronized (map2) {
            for (SubSet pl2 : map.values()) {
                if (pl2.isEmpty()) continue;
                if (lastpl == null) {
                    return pl2;
                }
                foundpl = pl2;
                if (foundpl == lastpl || foundpl.equals(lastpl)) continue;
                return foundpl;
            }
        }
        return foundpl;
    }

    public void setPrefetch(int count) {
        this.prefetch = count;
        this.useConsumerFlowControl = C_FLOW_CONTROL_ALLOWED;
    }

    @Override
    public void setPrefetch(int count, boolean useConsumerFlowControl) {
        this.prefetch = count;
        this.useConsumerFlowControl = useConsumerFlowControl;
    }

    public void setRemotePrefetch(int count) {
        this.remotePrefetch = count;
    }

    public int getRemotePrefetch() {
        return this.remotePrefetch;
    }

    public static int calcPrefetch(Consumer consumer, int cprefetch) {
        Destination d = consumer.getFirstDestination();
        Subscription sub = consumer.getSubscription();
        int dprefetch = -1;
        if (d != null) {
            int n = dprefetch = sub == null || !sub.getShared() ? d.getMaxPrefetch() : d.getSharedConsumerFlowLimit();
        }
        int pref = dprefetch == -1 ? cprefetch : (cprefetch == -1 ? cprefetch : (cprefetch > dprefetch ? dprefetch : cprefetch));
        return pref;
    }

    public long getLastAckTime() {
        return this.lastAckTime;
    }

    public void setLastAckTime(long time) {
        this.lastAckTime = time;
        if (this.parent != null) {
            this.parent.setLastAckTime(time);
        }
    }

    @Override
    public int getPrefetch() {
        return this.prefetch;
    }

    public int getPrefetchForRemote() {
        long room;
        DestinationList DL = Globals.getDestinationList();
        int fetch = this.prefetch;
        if (DL.getMaxMessages() > 0L) {
            room = DL.getMaxMessages() - (long)DL.totalCount();
            if (room <= 0L) {
                room = 1L;
            }
            if ((long)fetch > room) {
                fetch = (int)room;
            }
        }
        room = -1L;
        Destination d2 = null;
        for (Destination d2 : this.getDestinations()) {
            long m = d2.checkDestinationCapacity(null);
            if (m < 0L || room >= 0L && room <= m) continue;
            room = m;
        }
        if (room == 0L) {
            room = 1L;
        }
        if (room > 0L && (long)fetch > room) {
            fetch = (int)room;
        }
        return fetch;
    }

    public void setSubscription(Subscription sub) {
        this.ackMsgsOnDestroy = false;
        this.parent = sub;
    }

    public void load() {
        for (Destination d : this.getDestinations()) {
            try {
                d.load();
            }
            catch (Exception exception) {}
        }
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String id) {
        this.creator = id;
    }

    public String getClientID() {
        ConnectionUID cuid = this.getConnectionUID();
        if (cuid == null) {
            return "<unknown>";
        }
        Connection con = Globals.getConnectionManager().getConnection(cuid);
        return (String)con.getClientData("client id");
    }

    public boolean isDurableSubscriber() {
        if (this.parent != null) {
            return this.parent.isDurable();
        }
        if (this instanceof Subscription) {
            return ((Subscription)this).isDurable();
        }
        return false;
    }

    public boolean getIsFlowPaused() {
        return this.flowPaused;
    }

    public void msgRetrieved() {
        ++this.msgsOut;
    }

    public int totalMsgsDelivered() {
        return this.msgsOut;
    }

    public int numPendingAcks() {
        Session s = Session.getSession(this.sessionuid);
        if (s == null) {
            return 0;
        }
        return s.getNumPendingAcks(this.getConsumerUID());
    }

    public Subscription getSubscription() {
        return this.parent;
    }

    protected static Selector getSelector(String selstr) throws SelectorFormatException {
        return Selector.compile((String)selstr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PartitionedStore, SubSet> getParentList() {
        LinkedHashMap<PartitionedStore, SubSet> m = new LinkedHashMap<PartitionedStore, SubSet>();
        Map<PartitionedStore, SubSet> map = this.parentListMap;
        synchronized (map) {
            m.putAll(this.parentListMap);
        }
        return m;
    }

    public void destroyConsumer(Set delivered, boolean destroyingDest) {
        this.destroyConsumer(delivered, null, false, destroyingDest, true);
    }

    public void destroyConsumer(Set delivered, boolean destroyingDest, boolean notify) {
        this.destroyConsumer(delivered, null, false, destroyingDest, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConsumer(Set delivered, Map remotePendings, boolean remoteCleanup, boolean destroyingDest, boolean notify) {
        Map.Entry<PartitionedStore, SubSet> pair2;
        if (DEBUG) {
            this.logger.log(8, "destroyConsumer(" + delivered.size() + ", " + remotePendings + ", " + remoteCleanup + ", " + destroyingDest + ", " + notify + ")");
        }
        Object object = this.destroyLock;
        synchronized (object) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        Subscription sub = this.parent;
        if (sub != null) {
            sub.pause("Consumer.java: destroy " + this);
        }
        this.pause("Consumer.java: destroy ");
        if (this.parentListMap.size() > 0 && this.plistenerMap.size() > 0) {
            Object pll = null;
            for (Map.Entry<PartitionedStore, SubSet> pair2 : this.parentListMap.entrySet()) {
                pll = this.plistenerMap.get(pair2.getKey());
                if (pll == null) continue;
                ((SubSet)pair2.getValue()).removeEventListener(pll);
                this.plistenerMap.remove(pair2.getKey());
            }
        }
        List<Destination> ds = this.getDestinations();
        LinkedHashMap<PartitionedStore, SubSet> oldParent = new LinkedHashMap<PartitionedStore, SubSet>();
        pair2 = this.parentListMap;
        synchronized (pair2) {
            oldParent.putAll(this.parentListMap);
            this.parentListMap.clear();
        }
        if (this.parent != null) {
            this.parent.releaseConsumer(this.uid);
            this.parent = null;
            if (notify) {
                try {
                    this.sendDestroyConsumerNotification(remotePendings, remoteCleanup);
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "Sending detach notification for " + this.uid + " from " + this.parent, (Throwable)ex);
                }
            }
        } else if ((ds == null || ds.isEmpty()) && !destroyingDest) {
            this.logger.log(4, "Removing consumer from non-existant destination" + this.dest);
        } else if (!destroyingDest) {
            Iterator<Destination> itr = ds.iterator();
            while (itr.hasNext()) {
                Destination d = null;
                try {
                    d = itr.next();
                    d.removeConsumer(this.uid, remotePendings, remoteCleanup, notify);
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "removing consumer " + this.uid + " from " + d, (Throwable)ex);
                }
            }
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying consumer " + this + "[" + delivered.size() + ":" + this.msgs.size() + "]");
        }
        LinkedHashSet s = new LinkedHashSet(this.msgs);
        RemoveReason cleanupReason = this.ackMsgsOnDestroy ? RemoveReason.ACKNOWLEDGED : RemoveReason.UNLOADED;
        delivered.addAll(s);
        DestinationList DL = Globals.getDestinationList();
        Iterator itr = delivered.iterator();
        while (itr.hasNext()) {
            PacketReference r = (PacketReference)itr.next();
            if (r == null || !this.ackMsgsOnDestroy && r.isLocal()) continue;
            itr.remove();
            try {
                if (!r.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), r.isLocal())) continue;
                try {
                    Destination[] dds = DestinationList.getDestination(r.getPartitionedStore(), r.getDestinationUID());
                    Destination d = null;
                    for (int i = 0; i < dds.length; ++i) {
                        d = dds[i];
                        if (d == null) continue;
                        if (r.isLocal()) {
                            d.removeMessage(r.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                            continue;
                        }
                        d.removeRemoteMessage(r.getSysMessageID(), RemoveReason.ACKNOWLEDGED, r);
                    }
                }
                finally {
                    r.postAcknowledgedRemoval();
                }
            }
            catch (Exception ex) {
                this.logger.log(4, "Broker down Unable to acknowlege" + r.getSysMessageID() + ":" + this.uid, (Throwable)ex);
            }
        }
        this.msgs.removeAll(s, (Reason)cleanupReason);
        if (!this.ackMsgsOnDestroy) {
            LinkedHashMap<PartitionedStore, LinkedHashSet<PacketReference>> map = new LinkedHashMap<PartitionedStore, LinkedHashSet<PacketReference>>();
            LinkedHashSet<PacketReference> set = null;
            PacketReference ref2 = null;
            PartitionedStore pstore = null;
            for (PacketReference ref2 : delivered) {
                pstore = ref2.getDestinationUID().isQueue() ? ref2.getPartitionedStore() : new NoPersistPartitionedStoreImpl(this.getStoredConsumerUID());
                set = (LinkedHashSet<PacketReference>)map.get(pstore);
                if (set == null) {
                    set = new LinkedHashSet<PacketReference>();
                    map.put(pstore, set);
                }
                set.add(ref2);
            }
            SubSet pl = null;
            for (Map.Entry pair3 : map.entrySet()) {
                pl = (SubSet)oldParent.get(pair3.getKey());
                if (pl == null) continue;
                ((Prioritized)pl).addAllOrdered((Collection)pair3.getValue());
            }
            delivered.clear();
        }
        this.destroy();
        if (this.msgs != null && this.mlistener != null) {
            this.msgs.removeEventListener(this.mlistener);
            this.mlistener = null;
        }
        if (sub != null) {
            sub.resume("Consumer.java: destroyConsumer " + this);
        }
        this.selstr = null;
        this.selector = null;
    }

    public void sendCreateConsumerNotification() throws BrokerException {
        Destination d = this.getFirstDestination();
        if ((this.dest.isWildcard() || !d.getIsLocal() && !d.isInternal() && !d.isAdmin()) && Globals.getClusterBroadcast() != null) {
            Globals.getClusterBroadcast().createConsumer(this);
        }
    }

    public void sendDestroyConsumerNotification(Map remotePendings, boolean remoteCleanup) throws BrokerException {
        Destination d = this.getFirstDestination();
        if (this.dest.isWildcard() || d != null && !d.getIsLocal() && !d.isInternal() && !d.isAdmin() && Globals.getClusterBroadcast() != null) {
            Globals.getClusterBroadcast().destroyConsumer(this, remotePendings, remoteCleanup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        this.valid = false;
        this.pause("Consumer.java: destroy()");
        Map map = consumers;
        synchronized (map) {
            consumers.remove(this.uid);
        }
        wildcardConsumers.remove(this.uid);
        this.selector = null;
        RemoveReason cleanupReason = RemoveReason.UNLOADED;
        if (this.ackMsgsOnDestroy) {
            cleanupReason = RemoveReason.ACKNOWLEDGED;
        }
        HashSet s = new HashSet(this.msgs);
        try {
            DestinationList DL = Globals.getDestinationList();
            HashSet hashSet = s;
            synchronized (hashSet) {
                for (PacketReference pr : s) {
                    if (!this.ackMsgsOnDestroy || !pr.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), true)) continue;
                    try {
                        Destination[] ds = DestinationList.getDestination(pr.getPartitionedStore(), pr.getDestinationUID());
                        Destination d = ds[0];
                        if (pr.isLocal()) {
                            d.removeMessage(pr.getSysMessageID(), cleanupReason);
                            continue;
                        }
                        d.removeRemoteMessage(pr.getSysMessageID(), cleanupReason, pr);
                    }
                    finally {
                        pr.postAcknowledgedRemoval();
                    }
                }
            }
            this.msgs.removeAll(s, (Reason)cleanupReason);
        }
        catch (Exception ex) {
            this.logger.logStack(16, this.br.getKString("B2280", this, ex.getMessage()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentList(PartitionedStore pstore, SubSet set) {
        Object pll;
        if (DEBUG) {
            this.logger.log(8, "Consumer.setParentList(" + pstore + ", " + set + ")");
        }
        this.ackMsgsOnDestroy = false;
        SubSet pl = this.parentListMap.get(pstore);
        if (pl != null && (pll = this.plistenerMap.get(pstore)) != null) {
            pl.removeEventListener(pll);
        }
        this.plistenerMap.remove(pstore);
        Map<PartitionedStore, SubSet> map = this.parentListMap;
        synchronized (map) {
            if (set != null) {
                this.parentListMap.put(pstore, set);
                this.plistenerMap.put(pstore, set.addEventListener(this.busylistener, EventType.EMPTY, null));
            }
        }
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMoreMessages(int num) {
        LinkedHashMap<PartitionedStore, SubSet> ss = new LinkedHashMap<PartitionedStore, SubSet>();
        Map<PartitionedStore, SubSet> map = this.parentListMap;
        synchronized (map) {
            ss.putAll(this.parentListMap);
        }
        if (this.paused || ss.size() == 0 || Consumer.isParentListEmpty(ss) || this.parent != null && this.parent.isPaused()) {
            return;
        }
        int count = 0;
        if (Consumer.isParentListEmpty(ss)) {
            return;
        }
        SubSet pl = null;
        while (!(this.isFailover || !this.isActive() || this.isPaused() || !this.isValid() || ss == null || (pl = Consumer.getNonEmptyParentList(ss, pl)) == null || count >= num || this.parent != null && this.parent.isPaused())) {
            PacketReference mm = (PacketReference)pl.removeNext();
            if (mm == null) continue;
            this.msgs.add(11 - mm.getPriority(), (Object)mm);
            ++count;
            this.busy = true;
        }
    }

    void setIsActiveConsumer(boolean active) {
        this.isFailover = !active;
        this.checkState(null);
    }

    public boolean getIsFailoverConsumer() {
        return this.isFailover;
    }

    public boolean getIsActiveConsumer() {
        return !this.isFailover;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.logger = Globals.getLogger();
        this.remotePendingResumes = new ArrayList();
        this.lastDestMetrics = new Hashtable();
        this.localConsumerCreationReady = false;
        this.parent = null;
        this.busy = false;
        this.paused = false;
        this.flowPaused = false;
        this.flowCount = 0;
        this.active = true;
        this.valid = true;
        this.destroyLock = new Object();
        this.destinationMap = Collections.synchronizedMap(new LinkedHashMap());
        this.parentListMap = Collections.synchronizedMap(new LinkedHashMap());
        this.plistenerMap = Collections.synchronizedMap(new LinkedHashMap());
        this.mlistener = null;
        this.prefetch = -1;
        this.isFailover = false;
        this.position = 0;
        this.isSpecialRemote = false;
        this.useConsumerFlowControl = false;
        this.stored_uid = null;
        this.active = true;
        this.pauseCnt = 0;
        try {
            this.selector = Consumer.getSelector(this.selstr);
        }
        catch (Exception ex) {
            this.logger.logStack(32, "Internal Error: bad stored selector[" + this.selstr + "], ignoring", (Throwable)ex);
            this.selector = null;
        }
        this.initInterest();
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public DestinationUID getDestinationUID() {
        return this.dest;
    }

    protected Consumer(ConsumerUID uid) {
        this.uid = uid;
    }

    public static Consumer newInstance(ConsumerUID uid) {
        return new Consumer(uid);
    }

    public Consumer(DestinationUID d, String selstr, boolean noLocal, ConnectionUID con_uid) throws IOException, SelectorFormatException {
        this.dest = d;
        this.noLocal = noLocal;
        this.uid = new ConsumerUID();
        this.uid.setConnectionUID(con_uid);
        this.selstr = selstr;
        this.selector = Consumer.getSelector(selstr);
        this.initInterest();
        if (DEBUG) {
            this.logger.log(8, "Consumer: created new consumer " + this.uid + " on destination " + d + " with selector " + selstr);
        }
    }

    public Consumer(DestinationUID d, String selstr, boolean noLocal, ConsumerUID uid) throws IOException, SelectorFormatException {
        this.dest = d;
        this.noLocal = noLocal;
        this.uid = uid;
        if (uid == null) {
            this.uid = new ConsumerUID();
        }
        this.selstr = selstr;
        this.selector = Consumer.getSelector(selstr);
        this.initInterest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Consumer newConsumer(DestinationUID destid, String selectorstr, boolean isnolocal, ConsumerUID consumerid) throws IOException, SelectorFormatException, ConsumerAlreadyAddedException {
        Map map = consumers;
        synchronized (map) {
            if (consumers.get(consumerid) != null) {
                throw new ConsumerAlreadyAddedException(Globals.getBrokerResources().getKString("B1331", consumerid, destid));
            }
            return new Consumer(destid, selectorstr, isnolocal, consumerid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localConsumerCreationReady() {
        Map map = consumers;
        synchronized (map) {
            this.localConsumerCreationReady = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLocalConsumerCreationReady() {
        Map map = consumers;
        synchronized (map) {
            return this.localConsumerCreationReady;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInterest() {
        this.removeListener = new RemoveListener();
        this.busylistener = new BusyListener();
        this.evb = new EventBroadcastHelper();
        this.msgs = new NFLPriorityFifoSet(12, false);
        this.mlistener = this.msgs.addEventListener(this.busylistener, EventType.EMPTY, null);
        Map map = consumers;
        synchronized (map) {
            consumers.put(this.uid, this);
        }
        if (this.dest.isWildcard()) {
            wildcardConsumers.add(this.uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void attachConsumers(DestinationList dl) throws BrokerException {
        try {
            DestinationList DL = Globals.getDestinationList();
            Consumer c2 = null;
            DestinationUID did = null;
            Map map = consumers;
            synchronized (map) {
                for (Consumer c2 : consumers.values()) {
                    if (c2 instanceof Subscription) continue;
                    did = c2.getDestinationUID();
                    if (did.isWildcard()) {
                        List<DestinationUID> dids = DestinationList.findMatchingIDsByDestinationList(dl, did);
                        for (DestinationUID match_did : dids) {
                            Destination d = DestinationList.getDestinationByDestinationList(dl, match_did);
                            d.addConsumer(c2, false, null, true);
                            Globals.getLogger().log(8, "XXXI18N attached regular consumer " + c2 + " to partition " + dl);
                        }
                        continue;
                    }
                    Destination d = DestinationList.getDestinationByDestinationList(dl, did.getName(), did.isQueue() ? 1 : 2, true, true);
                    d.addConsumer(c2, false, null, true);
                    Globals.getLogger().log(8, "XXXI18N attached regular consumer " + c2 + " to partition " + dl);
                }
            }
        }
        catch (Exception e) {
            Globals.getLogger().logStack(32, e.getMessage(), (Throwable)e);
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference peekNext() {
        PacketReference ref = (PacketReference)this.msgs.peekNext();
        if (ref == null && this.parentListMap.size() > 0) {
            Map<PartitionedStore, SubSet> map = this.parentListMap;
            synchronized (map) {
                Iterator<SubSet> itr = this.parentListMap.values().iterator();
                while (itr.hasNext() && (ref = (PacketReference)itr.next().peekNext()) == null) {
                }
            }
        }
        return ref;
    }

    public void setAckMsgsOnDestroy(boolean ack) {
        this.ackMsgsOnDestroy = ack;
    }

    @Override
    public ConsumerUID getConsumerUID() {
        return this.uid;
    }

    public void setStoredConsumerUID(ConsumerUID uid) {
        this.stored_uid = uid;
    }

    @Override
    public ConsumerUID getStoredConsumerUID() {
        if (this.stored_uid == null) {
            return this.uid;
        }
        return this.stored_uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageCommitted(SysMessageID sysid) {
        if (MSG_MAX_CONSECUTIVE_ROLLBACKS <= 0) {
            return;
        }
        HashMap hashMap = this.messageRollbacks;
        synchronized (hashMap) {
            this.messageRollbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRollbackCnt(SysMessageID sysid, int maxRollbacks) {
        if (maxRollbacks <= 0 && MSG_MAX_CONSECUTIVE_ROLLBACKS <= 0) {
            return true;
        }
        int maxrb = maxRollbacks;
        if (maxRollbacks <= 0) {
            maxrb = MSG_MAX_CONSECUTIVE_ROLLBACKS;
        }
        HashMap hashMap = this.messageRollbacks;
        synchronized (hashMap) {
            Integer count = (Integer)this.messageRollbacks.get(sysid);
            if (count == null) {
                this.messageRollbacks.put(sysid, 0);
                return true;
            }
            int cnt = count;
            if (cnt < maxrb) {
                this.messageRollbacks.put(sysid, ++cnt);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean routeMessages(Collection c, boolean toFront) {
        if (toFront) {
            if (!this.valid) {
                return false;
            }
            this.msgs.addAllToFront(c, 0);
            Object object = this.destroyLock;
            synchronized (object) {
                this.msgsToConsumer += c.size();
            }
            this.checkState(null);
        } else {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                this.routeMessage((PacketReference)itr.next(), false);
            }
        }
        return this.valid;
    }

    public boolean unrouteMessage(PacketReference p) {
        boolean b = this.msgs.remove((Object)p);
        if (b) {
            --this.msgsToConsumer;
        }
        return b;
    }

    public boolean routeMessage(PacketReference p, boolean toFront) {
        return this.routeMessage(p, toFront, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean routeMessage(PacketReference p, boolean toFront, boolean ordered) {
        int position = 0;
        if (!toFront && !ordered) {
            position = 11 - p.getPriority();
        }
        ArrayList<PacketReference> a = null;
        if (ordered) {
            a = new ArrayList<PacketReference>();
            a.add(p);
        }
        Object object = this.destroyLock;
        synchronized (object) {
            if (!this.valid) {
                return false;
            }
            if (ordered) {
                this.msgs.addAllOrdered(a);
            } else {
                this.msgs.add(position, (Object)p);
            }
            ++this.msgsToConsumer;
        }
        this.checkState(null);
        if (a != null) {
            a.clear();
            a = null;
        }
        return true;
    }

    public int size() {
        return this.msgs.size();
    }

    public int numInProcessMsgs() {
        int cnt = this.size();
        return cnt += this.numPendingAcks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadMessages() {
        this.msgs.clear();
        Object object = this.destroyLock;
        synchronized (object) {
            this.msgsToConsumer = 0;
        }
    }

    @Override
    public void attachToConnection(ConnectionUID uid) {
        this.conuid = uid;
        this.uid.setConnectionUID(uid);
    }

    @Override
    public void attachToSession(SessionUID uid) {
        this.sessionuid = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToDestination(Destination d, PartitionedStore pstore) {
        Map<PartitionedStore, LinkedHashSet<Destination>> map = this.destinationMap;
        synchronized (map) {
            LinkedHashSet<Destination> ds = this.destinationMap.get(pstore);
            if (ds == null) {
                ds = new LinkedHashSet();
                this.destinationMap.put(pstore, ds);
                ds.add(d);
            }
        }
    }

    public Set getUniqueDestinations() {
        LinkedHashSet<Destination> snapshot = new LinkedHashSet<Destination>();
        snapshot.addAll(this.getDestinations());
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Destination> getDestinations() {
        ArrayList<Destination> snapshot = new ArrayList<Destination>();
        Map<PartitionedStore, LinkedHashSet<Destination>> map = this.destinationMap;
        synchronized (map) {
            if (this.destinationMap.size() == 0) {
                Map<PartitionedStore, Serializable> mp;
                DestinationList DL = Globals.getDestinationList();
                if (!this.dest.isWildcard()) {
                    mp = DestinationList.getDestinationMap(null, this.dest);
                    LinkedHashSet<Destination> set = null;
                    for (Map.Entry<PartitionedStore, Serializable> pair : mp.entrySet()) {
                        set = this.destinationMap.get(pair.getKey());
                        if (set == null) {
                            set = new LinkedHashSet();
                            this.destinationMap.put(pair.getKey(), set);
                        }
                        set.add((Destination)pair.getValue());
                    }
                } else {
                    mp = DestinationList.findMatchingDestinationMap(null, this.dest);
                    this.destinationMap.putAll(mp);
                }
            }
            Iterator<LinkedHashSet<Destination>> itr = this.destinationMap.values().iterator();
            while (itr.hasNext()) {
                snapshot.addAll((Collection)itr.next());
            }
        }
        return snapshot;
    }

    @Override
    public Destination getFirstDestination() {
        Iterator<Destination> itr = this.getDestinations().iterator();
        Destination d = itr.hasNext() ? itr.next() : null;
        return d;
    }

    public SessionUID getSessionUID() {
        return this.sessionuid;
    }

    @Override
    public ConnectionUID getConnectionUID() {
        return this.conuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAndFillNextPacket(Packet p) {
        PacketReference ref = null;
        if (this.flowPaused || this.paused) {
            this.checkState(null);
            return null;
        }
        if (!this.valid) {
            return null;
        }
        if (!this.paused && this.msgs.isEmpty()) {
            this.getMoreMessages(this.prefetch <= 0 ? 1000 : this.prefetch);
        }
        Packet newpkt = null;
        while (this.valid && !this.paused && !this.msgs.isEmpty()) {
            block55: {
                boolean islocal;
                boolean remoteDeliveredAck;
                if (Consumer.FI.FAULT_INJECTION) {
                    HashMap<String, String> fips = new HashMap<String, String>();
                    fips.put("mqDestinationName", this.getDestinationUID().getName());
                    if (FI.checkFaultAndSleep("consumer.sleep.before.msgs.removeNext", fips)) {
                        FI.unsetFault("consumer.sleep.before.msgs.removeNext");
                    }
                }
                if ((ref = (PacketReference)this.msgs.removeNext()) == null || ref.isOverrided()) {
                    int loglevel = DEBUG_CLUSTER_MSG ? 8 : 4;
                    this.logger.log(loglevel, ref == null ? "Consumer [" + this.getConsumerUID() + "] get message null reference" : "Consumer [" + this.getConsumerUID() + "] message requened: " + ref);
                    continue;
                }
                newpkt = ref.getPacket();
                boolean expired = ref.isExpired();
                if (Consumer.FI.FAULT_INJECTION) {
                    HashMap<String, String> fips = new HashMap<String, String>();
                    fips.put("mqDestinationName", ref.getDestinationUID().getName());
                    if (FI.checkFault("msg.expire.at_delivery", fips)) {
                        expired = true;
                        FI.unsetFault("msg.expire.at_delivery");
                    }
                }
                boolean bl = remoteDeliveredAck = !(islocal = ref.isLocal()) && ref.getMessageDeliveredAck(this.uid);
                if (!expired && ref.checkRemovalAndSetInDelivery(this.getStoredConsumerUID())) break;
                if (!expired) {
                    expired = ref.isExpired();
                }
                try {
                    if (expired) {
                        String cmt = this.br.getKString("B1385", ref.getSysMessageID(), "[" + this.uid + ", " + this.uid.getAckMode() + "]" + this.dest);
                        String cmtr = this.br.getKString("B1386", ref.getSysMessageID(), "[" + this.uid + ", " + this.uid.getAckMode() + "]" + this.dest);
                        if (!ref.markDead(this.uid, this.getStoredConsumerUID(), islocal ? cmt : cmtr, null, RemoveReason.EXPIRED_ON_DELIVERY, -1, null, remoteDeliveredAck)) break block55;
                        try {
                            boolean removed = false;
                            DestinationList DL = Globals.getDestinationList();
                            Destination[] ds = DestinationList.getDestination(ref.getPartitionedStore(), ref.getDestinationUID());
                            Destination d = ds[0];
                            if (d != null && (removed = ref.isDead() ? d.removeDeadMessage(ref) : d.removeMessage(ref.getSysMessageID(), (Reason)RemoveReason.REMOVED_OTHER, !expired)) && expired) {
                                if (DL.getVerbose()) {
                                    this.logger.log(8, islocal ? cmt : cmtr);
                                }
                            }
                            break block55;
                        }
                        finally {
                            ref.postAcknowledgedRemoval();
                        }
                    }
                    if (DEBUG) {
                        this.logger.log(8, "Message " + ref + (newpkt == null ? "[null]" : "") + " in removal,  not deliver to consumer " + this);
                    }
                    if (remoteDeliveredAck) {
                        try {
                            HashMap<String, Integer> props = new HashMap<String, Integer>();
                            props.put(PREFETCH, 1);
                            Globals.getClusterBroadcast().acknowledgeMessage(ref.getBrokerAddress(), ref.getSysMessageID(), this.uid, 0, props, false);
                        }
                        catch (Exception e) {
                            if (DEBUG) {
                                this.logger.logStack(8, "Cannot send DELIVERED ack for message " + ref + " for consumer " + this.uid, (Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    if (newpkt == null || !DEBUG) break block55;
                    this.logger.logStack(8, "Unable to cleanup expired message " + ref + " for consumer " + this, (Throwable)ex);
                }
            }
            ref = null;
            newpkt = null;
        }
        if (!this.valid) {
            if (DEBUG_CLUSTER_MSG) {
                this.logger.log(8, "getAndFillNextPacket(): consumer " + this + " closed, discard ref " + ref);
            }
            return null;
        }
        if (ref == null) {
            this.checkState(null);
            return null;
        }
        newpkt = ref.getPacket();
        if (newpkt == null) {
            assert (false);
            return null;
        }
        if (p != null) {
            try {
                p.fill(newpkt);
            }
            catch (IOException ex) {
                this.logger.logStack(8, "Internal Exception processing packet ", (Throwable)ex);
                return null;
            }
            p.setConsumerID(this.uid.longValue());
            ConsumerUID suid = this.getStoredConsumerUID();
            boolean rflag = ref.getRedeliverFlag(suid);
            p.setRedelivered(rflag);
            int rcnt = ref.getRedeliverCount(suid) + 1;
            if (rflag && rcnt < 2) {
                rcnt = 2;
            }
            if (DEBUG) {
                this.logger.log(8, "Consumer.getAndFillNextPacket: Set DeliveryCount to " + rcnt + " for message " + ref + " for consumer " + this);
            }
            p.setDeliveryCount(rcnt);
            if (ref.isLast(this.uid)) {
                ref.removeIsLast(this.uid);
                p.setIsLast(true);
            }
            this.msgRetrieved();
            if (this.parent != null) {
                this.parent.msgRetrieved();
            }
        } else {
            newpkt.setRedelivered(ref.getRedeliverFlag(this.getStoredConsumerUID()));
        }
        if (this.useConsumerFlowControl) {
            if (this.prefetch != -1) {
                ++this.flowCount;
            }
            if (!this.flowPaused && ref.getMessageDeliveredAck(this.uid)) {
                BrokerAddress addr = ref.getBrokerAddress();
                if (addr != null) {
                    ArrayList rflag = this.remotePendingResumes;
                    synchronized (rflag) {
                        this.remotePendingResumes.add(ref);
                    }
                }
                if (p != null) {
                    p.setConsumerFlow(true);
                }
            }
            if (this.prefetch > 0 && this.flowCount >= this.prefetch) {
                if (p != null) {
                    p.setConsumerFlow(true);
                }
                ref.addMessageDeliveredAck(this.uid);
                BrokerAddress addr = ref.getBrokerAddress();
                if (addr != null) {
                    ArrayList rflag = this.remotePendingResumes;
                    synchronized (rflag) {
                        this.remotePendingResumes.add(ref);
                    }
                }
                ++this.pauseFlowCnt;
                this.flowPaused = true;
            }
        } else if (ref.getMessageDeliveredAck(this.uid)) {
            IMQConnection con;
            HashMap<String, Integer> props = null;
            ConnectionUID cuid = this.getConnectionUID();
            if (cuid != null && (con = (IMQConnection)Globals.getConnectionManager().getConnection(cuid)) != null) {
                props = new HashMap<String, Integer>();
                props.put(PREFETCH, con.getFlowCount());
            }
            try {
                Globals.getClusterBroadcast().acknowledgeMessage(ref.getBrokerAddress(), ref.getSysMessageID(), this.uid, 0, props, false);
            }
            catch (BrokerException ex) {
                this.logger.log(4, "Can not send DELIVERED ack  received ", (Throwable)ex);
            }
            ref.removeMessageDeliveredAck(this.uid);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeConsumer() throws BrokerException {
        RemoveReason cleanupReason = RemoveReason.ACKNOWLEDGED;
        HashSet set = new HashSet(this.msgs);
        if (set.isEmpty()) {
            return;
        }
        this.msgs.removeAll(set, (Reason)cleanupReason);
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            try {
                PacketReference pr = (PacketReference)itr.next();
                if (!pr.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), true)) continue;
                try {
                    DestinationList DL = Globals.getDestinationList();
                    Destination[] ds = DestinationList.getDestination(pr.getPartitionedStore(), pr.getDestinationUID());
                    Destination d = ds[0];
                    d.removeMessage(pr.getSysMessageID(), cleanupReason);
                }
                finally {
                    pr.postAcknowledgedRemoval();
                }
            }
            catch (IOException ex) {
                this.logger.logStack(16, "Purging consumer " + this, (Throwable)ex);
            }
        }
    }

    public boolean isWildcard() {
        return this.dest.isWildcard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeConsumer(Filter f) throws BrokerException {
        RemoveReason cleanupReason = RemoveReason.ACKNOWLEDGED;
        Set set = this.msgs.getAll(f);
        this.msgs.removeAll((Collection)set, (Reason)cleanupReason);
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            try {
                PacketReference pr = (PacketReference)itr.next();
                if (!pr.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), true)) continue;
                try {
                    DestinationList DL = Globals.getDestinationList();
                    Destination[] ds = DestinationList.getDestination(pr.getPartitionedStore(), pr.getDestinationUID());
                    Destination d = ds[0];
                    d.removeMessage(pr.getSysMessageID(), cleanupReason);
                }
                finally {
                    pr.postAcknowledgedRemoval();
                }
            }
            catch (IOException ex) {
                this.logger.logStack(16, "Problem purging consumer " + this, (Throwable)ex);
            }
        }
    }

    public void activate() {
        this.active = true;
        this.checkState(null);
    }

    public void deactive() {
        this.active = false;
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(String reason) {
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            this.paused = true;
            ++this.pauseCnt;
            if (DEBUG) {
                this.logger.log(4, "Pausing consumer " + this + "[" + this.pauseCnt + "] " + reason);
            }
        }
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(String reason) {
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            --this.pauseCnt;
            if (this.pauseCnt <= 0) {
                this.paused = false;
            }
            if (DEBUG) {
                this.logger.log(4, "Pausing consumer " + this + "[" + this.pauseCnt + "] " + reason);
            }
        }
        this.checkState(null);
    }

    public void setFalconRemote(boolean notlocal) {
        this.isSpecialRemote = notlocal;
    }

    public boolean isFalconRemote() {
        return this.isSpecialRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkIfMsgsInRateGTOutRate(Destination d) {
        Subscription sub = this.getSubscription();
        if (!(DestinationList.CHECK_MSGS_RATE_FOR_ALL || sub != null && sub.getShared() && !sub.isDurable())) {
            return 2;
        }
        if (DestinationList.CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO < 0) {
            return 2;
        }
        Globals.getDestinationList();
        float pc = Math.max(DestinationList.totalCountPercent(), d.destMessagesSizePercent());
        if (pc < (float)DestinationList.CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO) {
            return 2;
        }
        Hashtable hashtable = this.lastDestMetrics;
        synchronized (hashtable) {
            DestinationUID did = d.getDestinationUID();
            long[] holder = (long[])this.lastDestMetrics.get(did);
            if (holder == null) {
                holder = new long[6];
                d.checkIfMsgsInRateGTOutRate(holder, true);
                this.lastDestMetrics.put(did, holder);
                return 1;
            }
            return d.checkIfMsgsInRateGTOutRate(holder, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMsgOutTimeMillis(Destination d) {
        Hashtable hashtable = this.lastDestMetrics;
        synchronized (hashtable) {
            DestinationUID did = d.getDestinationUID();
            long[] holder = (long[])this.lastDestMetrics.get(did);
            if (holder == null) {
                holder = new long[6];
                d.checkIfMsgsInRateGTOutRate(holder, true);
                this.lastDestMetrics.put(did, holder);
                return -1L;
            }
            d.checkIfMsgsInRateGTOutRate(holder, false);
            return holder[5];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeFlow() {
        ArrayList arrayList = this.remotePendingResumes;
        synchronized (arrayList) {
            if (!this.remotePendingResumes.isEmpty()) {
                Iterator itr = this.remotePendingResumes.iterator();
                while (itr.hasNext()) {
                    PacketReference ref = (PacketReference)itr.next();
                    try {
                        Globals.getClusterBroadcast().acknowledgeMessage(ref.getBrokerAddress(), ref.getSysMessageID(), this.uid, 0, null, false);
                    }
                    catch (BrokerException ex) {
                        this.logger.log(4, "Can not send DELIVERED ack  received ", (Throwable)ex);
                    }
                    itr.remove();
                }
            }
        }
        if (this.flowPaused) {
            ++this.resumeFlowCnt;
            this.flowCount = 0;
            this.flowPaused = false;
            this.checkState(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeRemoteFlow(int id) {
        ArrayList arrayList = this.remotePendingResumes;
        synchronized (arrayList) {
            if (!this.remotePendingResumes.isEmpty()) {
                boolean emptyp = this.parentListMap.size() == 0 || Consumer.isParentListEmpty(this.parentListMap);
                int remoteSize = this.remotePendingResumes.size();
                int prefetchVal = id;
                if (id > 0 && prefetchVal != 1 && (prefetchVal = id / (remoteSize + (emptyp ? 0 : 1))) == 0) {
                    prefetchVal = 1;
                }
                int myprefetch = prefetchVal;
                int totalPrefetched = 0;
                BrokerAddress addr = null;
                ArrayList<BrokerAddress> addrs = new ArrayList<BrokerAddress>();
                Destination[] ds = null;
                Destination d = null;
                PacketReference ref = null;
                HashMap<String, Integer> props = null;
                DestinationList DL = Globals.getDestinationList();
                Iterator itr = this.remotePendingResumes.iterator();
                while (itr.hasNext()) {
                    long systemrm;
                    ref = (PacketReference)itr.next();
                    addr = ref.getBrokerAddress();
                    if (addrs.contains(addr)) {
                        itr.remove();
                        continue;
                    }
                    myprefetch = prefetchVal;
                    long room = -1L;
                    long destrm = -1L;
                    props = new HashMap<String, Integer>();
                    ds = DestinationList.findDestination(ref.getPartitionedStore(), ref.getDestinationUID());
                    d = ds[0];
                    try {
                        systemrm = DestinationList.checkSystemLimit(ref);
                    }
                    catch (Throwable t) {
                        systemrm = 0L;
                    }
                    if (d != null) {
                        destrm = d.checkDestinationCapacity(ref);
                    }
                    if ((room = systemrm >= 0L && destrm >= 0L ? Math.min(systemrm, destrm) : (systemrm >= 0L ? systemrm : destrm)) == 0L) {
                        room = 1L;
                    }
                    myprefetch = prefetchVal;
                    if (room > 0L) {
                        myprefetch = (int)(room - (long)totalPrefetched);
                        if (myprefetch <= 0) {
                            myprefetch = 1;
                        } else {
                            int ret = this.checkIfMsgsInRateGTOutRate(d);
                            if (ret == 0) {
                                myprefetch = 1;
                            } else if (ret == 1) {
                                myprefetch = 1;
                            }
                        }
                        if (prefetchVal > 0 && (myprefetch = Math.min(prefetchVal, myprefetch)) <= 0) {
                            myprefetch = 1;
                        }
                    }
                    try {
                        props.put(PREFETCH, myprefetch);
                        Globals.getClusterBroadcast().acknowledgeMessage(addr, ref.getSysMessageID(), this.uid, 0, props, false);
                        if (addr != null) {
                            addrs.add(addr);
                        }
                        totalPrefetched += myprefetch;
                        itr.remove();
                    }
                    catch (BrokerException ex) {
                        this.logger.log(4, "Can not send DELIVERED ack  received ", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public void resumeFlow(int id) {
        this.resumeRemoteFlow(id);
        this.setPrefetch(id);
        if (this.flowPaused) {
            ++this.resumeFlowCnt;
            this.flowCount = 0;
            this.flowPaused = false;
            this.checkState(null);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public String getSelectorStr() {
        return this.selstr;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Object userData) throws UnsupportedOperationException {
        if (type != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy State Changed notifications supported on this class");
        }
        return this.evb.addEventListener(listener, type, userData);
    }

    public Object addEventListener(EventListener listener, EventType type, Reason reason, Object userData) throws UnsupportedOperationException {
        if (type != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy State Changed notifications supported on this class");
        }
        return this.evb.addEventListener(listener, type, reason, userData);
    }

    @Override
    public Object removeEventListener(Object id) {
        return this.evb.removeEventListener(id);
    }

    private void notifyChange(EventType type, Reason r, Object target, Object oldval, Object newval) {
        this.evb.notifyChange(type, r, target, oldval, newval);
    }

    @Override
    public void dump(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.logger.log(8, prefix + "Consumer: " + this.uid + " [paused, active,flowPaused, parentBusy, hasMessages, parentSize ] = [" + this.paused + "," + this.active + "," + this.flowPaused + "," + this.getParentBusy() + "," + (this.msgs == null || !this.msgs.isEmpty()) + "," + this.parentListMap + "]");
        this.logger.log(8, prefix + "Busy state [" + this.uid + "] is " + this.busy);
        if (this.msgs == null) {
            this.logger.log(8, "msgs is null");
        } else {
            this.logger.log(8, this.msgs.toDebugString());
        }
    }

    public static Hashtable getAllDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("FlowControlAllowed", String.valueOf(C_FLOW_CONTROL_ALLOWED));
        ht.put("ConsumerCnt", String.valueOf(consumers.size()));
        Iterator itr = Consumer.getAllConsumers();
        while (itr.hasNext()) {
            Consumer c = (Consumer)itr.next();
            ht.put("Consumer[" + c.getConsumerUID().longValue() + "]", c.getDebugState());
        }
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("ConsumerUID", String.valueOf(this.uid.longValue()));
        ht.put("Broker", this.uid.getBrokerAddress() == null ? "NONE" : this.uid.getBrokerAddress().toString());
        ht.put("msgsToConsumer", String.valueOf(this.msgsToConsumer));
        ht.put("StoredConsumerUID", String.valueOf(this.getStoredConsumerUID().longValue()));
        ht.put("ConnectionUID", this.conuid == null ? "none" : String.valueOf(this.conuid.longValue()));
        ht.put("type", "CONSUMER");
        ht.put("valid", String.valueOf(this.valid));
        ht.put("paused", String.valueOf(this.paused));
        ht.put("pauseCnt", String.valueOf(this.pauseCnt));
        ht.put("noLocal", String.valueOf(this.noLocal));
        ht.put("destinationUID", this.dest.toString());
        ht.put("busy", String.valueOf(this.busy));
        if (this.parent != null) {
            ht.put("Subscription", String.valueOf(this.parent.getConsumerUID().longValue()));
        }
        ht.put("isSpecialRemote", String.valueOf(this.isSpecialRemote));
        ht.put("ackMsgsOnDestroy", String.valueOf(this.ackMsgsOnDestroy));
        ht.put("position", String.valueOf(this.position));
        ht.put("active", String.valueOf(this.active));
        ht.put("flowCount", String.valueOf(this.flowCount));
        ht.put("flowPaused", String.valueOf(this.flowPaused));
        ht.put("pauseFlowCnt", String.valueOf(this.pauseFlowCnt));
        ht.put("resumeFlowCnt", String.valueOf(this.resumeFlowCnt));
        ht.put("useConsumerFlowControl", String.valueOf(this.useConsumerFlowControl));
        ht.put("selstr", this.selstr == null ? "none" : this.selstr);
        ht.put("parentListMap", this.parentListMap.toString());
        ht.put("plistenerMap", this.plistenerMap.toString());
        ht.put("isParentListEmpty", Consumer.isParentListEmpty(this.parentListMap));
        if (DestinationList.DEBUG_LISTS) {
            Hashtable<String, String> h = new Hashtable<String, String>();
            Map<PartitionedStore, SubSet> map = this.parentListMap;
            synchronized (map) {
                for (Map.Entry<PartitionedStore, SubSet> pair : this.parentListMap.entrySet()) {
                    h.put(pair.getKey().toString(), pair.getValue().toDebugString());
                }
            }
            ht.put("ParentListMap(detail)", h);
        }
        ht.put(PREFETCH, String.valueOf(this.prefetch));
        ht.put("remotePrefetch", String.valueOf(this.remotePrefetch));
        ht.put("parentBusy", String.valueOf(this.getParentBusy()));
        ht.put("hasMessages", String.valueOf(!this.msgs.isEmpty()));
        ht.put("msgsSize", String.valueOf(this.msgs.size()));
        if (DestinationList.DEBUG_LISTS) {
            ht.put("msgs", this.msgs.toDebugString());
        }
        ht.put("isFailover", String.valueOf(this.isFailover));
        ht.put("localConsumerCreationReady", String.valueOf(this.localConsumerCreationReady));
        Vector<String> v1 = new Vector<String>();
        ArrayList vals = null;
        ArrayList arrayList = this.remotePendingResumes;
        synchronized (arrayList) {
            vals = new ArrayList(this.remotePendingResumes);
        }
        for (PacketReference ref : vals) {
            String val = ref.getBrokerAddress() + ": " + ref;
            v1.add(val);
        }
        ht.put("remotePendingResumes", v1);
        Vector<String> v2 = new Vector<String>();
        Hashtable hashtable = this.lastDestMetrics;
        synchronized (hashtable) {
            for (DestinationUID did : this.lastDestMetrics.keySet()) {
                long[] holder = (long[])this.lastDestMetrics.get(did);
                String val = did + ": ins=" + holder[0] + "|outs=" + holder[1] + "|time=" + holder[2] + "|inr=" + holder[3] + "|outr=" + holder[4] + "|outt=" + holder[5];
                v2.add(val);
            }
        }
        ht.put("lastDestMetrics", v2);
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDebugMessages(boolean full) {
        Vector<String> ht = new Vector<String>();
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            for (PacketReference pr : this.msgs) {
                ht.add(full ? pr.getPacket().dumpPacketString() : pr.getPacket().toString());
            }
        }
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(Reason r) {
        boolean isbusy = false;
        boolean notify = false;
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            isbusy = !this.paused && this.active && !this.flowPaused && (this.getParentBusy() && !this.isFailover || !this.msgs.isEmpty());
            notify = isbusy != this.busy;
            this.busy = isbusy;
        }
        if (notify) {
            this.notifyChange(EventType.BUSY_STATE_CHANGED, r, this, !isbusy, isbusy);
        }
    }

    public String toString() {
        String str = "Consumer - " + this.dest + ":[" + this.getConsumerUID() + ", " + this.getStoredConsumerUID() + "]";
        return str;
    }

    @Override
    public void debug(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.logger.log(8, prefix + this.toString());
        String follow = prefix + "\t";
        this.logger.log(8, follow + "Selector = " + this.selector);
        this.logger.log(8, follow + "msgs = " + this.msgs.size());
        this.logger.log(8, follow + "parentListMap = " + this.parentListMap);
        this.logger.log(8, follow + "parent = " + this.parent);
        this.logger.log(8, follow + "valid = " + this.valid);
        this.logger.log(8, follow + "active = " + this.active);
        this.logger.log(8, follow + "paused = " + this.paused);
        this.logger.log(8, follow + "pauseCnt = " + this.pauseCnt);
        this.logger.log(8, follow + "noLocal = " + this.noLocal);
        this.logger.log(8, follow + "busy = " + this.busy);
        this.logger.log(8, follow + "flowPaused = " + this.flowPaused);
        this.logger.log(8, follow + "prefetch = " + this.prefetch);
        this.logger.log(8, follow + this.msgs.toDebugString());
    }

    public void setCapacity(int size) {
        this.msgs.setCapacity(size);
    }

    public void setByteCapacity(long size) {
        this.msgs.setByteCapacity(size);
    }

    public int capacity() {
        return this.msgs.capacity();
    }

    public long byteCapacity() {
        return this.msgs.byteCapacity();
    }

    public static void clearAllConsumers() {
        consumers.clear();
        wildcardConsumers.clear();
    }

    public static Iterator getAllConsumers() {
        return Consumer.getAllConsumers(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getAllConsumers(boolean all) {
        Map map = consumers;
        synchronized (map) {
            HashSet cs = new HashSet(consumers.values());
            if (all) {
                return cs.iterator();
            }
            Consumer co = null;
            Iterator itr = cs.iterator();
            while (itr.hasNext()) {
                co = (Consumer)itr.next();
                if (co instanceof Subscription || co.isLocalConsumerCreationReady()) continue;
                itr.remove();
            }
            return cs.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getWildcardConsumers() {
        Map map = consumers;
        synchronized (map) {
            return new HashSet(wildcardConsumers).iterator();
        }
    }

    public static int getNumConsumers() {
        return consumers.size();
    }

    public static int getNumWildcardConsumers() {
        return wildcardConsumers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Consumer getConsumer(ConsumerUID uid) {
        Map map = consumers;
        synchronized (map) {
            Consumer c = (Consumer)consumers.get(uid);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Consumer getConsumer(String creator) {
        if (creator == null) {
            return null;
        }
        Map map = consumers;
        synchronized (map) {
            for (Consumer c : consumers.values()) {
                if (!creator.equals(c.getCreator())) continue;
                return c;
            }
        }
        return null;
    }

    public void setLockPosition(int position) {
        this.lockPosition = position;
    }

    public int getLockPosition() {
        return this.lockPosition;
    }

    public void recreationRequested() {
        this.requestedRecreation = true;
    }

    protected boolean tobeRecreated() {
        return this.requestedRecreation;
    }

    class RemoveListener
    implements EventListener {
        RemoveListener() {
        }

        public void eventOccured(EventType type, Reason r, Object target, Object oldval, Object newval, Object userdata) {
            block13: {
                assert (type == EventType.SET_CHANGED_REQUEST);
                if (!(r instanceof RemoveReason)) {
                    return;
                }
                assert (r != RemoveReason.UNLOADED);
                assert (r != RemoveReason.ROLLBACK);
                assert (r != RemoveReason.DELIVERED);
                assert (r != RemoveReason.ACKNOWLEDGED);
                assert (r != RemoveReason.ROLLBACK);
                assert (r != RemoveReason.OVERFLOW);
                assert (r != RemoveReason.ERROR);
                PacketReference ref = (PacketReference)oldval;
                Consumer.this.msgs.remove((Object)ref);
                if (DEBUG || DEBUG_CLUSTER_MSG) {
                    Logger cfr_ignored_0 = Consumer.this.logger;
                    Consumer.this.logger.log(8, "Consumer.removeListener: removed msg " + ref + " from msgs in consumer " + Consumer.this);
                }
                if (!ref.isLocal() && ref.getMessageDeliveredAck(Consumer.this.uid)) {
                    try {
                        HashMap<String, Integer> props = new HashMap<String, Integer>();
                        props.put(Consumer.PREFETCH, 1);
                        Globals.getClusterBroadcast().acknowledgeMessage(ref.getBrokerAddress(), ref.getSysMessageID(), Consumer.this.uid, 0, props, false);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block13;
                        Consumer.this.logger.logStack(8, "Cannot send DELIVERED ack for message " + ref + " for consumer " + Consumer.this.uid, (Throwable)e);
                    }
                }
            }
        }
    }

    class BusyListener
    implements EventListener {
        BusyListener() {
        }

        public void eventOccured(EventType type, Reason r, Object target, Object oldval, Object newval, Object userdata) {
            assert (type == EventType.EMPTY);
            assert (newval instanceof Boolean);
            Consumer.this.checkState(null);
        }
    }
}

