/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.SFSHAClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.MigratableStoreUtil;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;

public class SFSHAClusteredBrokerImpl
extends HAClusteredBrokerImpl {
    public SFSHAClusteredBrokerImpl(String brokerid, HABrokerInfo m, SFSHAClusterManagerImpl parent) throws BrokerException {
        this.parent = parent;
        this.brokerid = brokerid;
        this.status = 0;
        String urlstr = m.getUrl();
        if (urlstr != null) {
            try {
                this.address = BrokerMQAddress.createAddress(urlstr);
            }
            catch (Exception ex) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "invalid URL stored on disk " + urlstr, ex));
            }
        }
        this.version = parent.VERSION;
        this.state = BrokerState.INITIALIZING;
        this.session = null;
        this.takeoverBroker = null;
        this.heartbeat = 0L;
    }

    public SFSHAClusteredBrokerImpl(String brokerid, MQAddress url, int version, BrokerState state, UID session, HAClusterManagerImpl parent) throws BrokerException {
        super(brokerid, url, version, state, session, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(HABrokerInfo m) {
        MQAddress oldaddr = this.address;
        SFSHAClusteredBrokerImpl sFSHAClusteredBrokerImpl = this;
        synchronized (sFSHAClusteredBrokerImpl) {
            this.brokerid = m.getId();
            String urlstr = m.getUrl();
            try {
                this.address = BrokerMQAddress.createAddress(urlstr);
            }
            catch (Exception ex) {
                this.logger.logStack(16, ex.getMessage(), (Throwable)ex);
                this.address = oldaddr;
            }
        }
        if (!oldaddr.equals((Object)this.address)) {
            this.parent.brokerChanged(ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), oldaddr, this.address, null, null);
        }
    }

    @Override
    public void resetTakeoverBrokerReadyOperating() throws Exception {
        this.setState(BrokerState.OPERATING);
    }

    @Override
    public synchronized String getTakeoverBroker() throws BrokerException {
        return null;
    }

    @Override
    public long getHeartbeat() throws BrokerException {
        return 0L;
    }

    @Override
    public synchronized long updateHeartbeat() throws BrokerException {
        return this.updateHeartbeat(false);
    }

    @Override
    public long updateHeartbeat(boolean reset) throws BrokerException {
        Globals.getStore().updateBrokerHeartbeat(this.brokerid);
        return 0L;
    }

    @Override
    protected synchronized UID updateEntry(int updateType, Object oldValue, Object newValue) throws Exception {
        if (!this.local) {
            throw new IllegalAccessException("Can not update entry  for broker " + this.brokerid);
        }
        Store store = Globals.getStore();
        store.updateBrokerInfo(this.brokerid, updateType, oldValue, newValue);
        return this.session;
    }

    public synchronized void setStoreSessionUID(UID uid) {
        this.session = uid;
    }

    @Override
    public BrokerState getState() throws BrokerException {
        return this.state;
    }

    @Override
    public void setStateFailoverProcessed(UID storeSession) throws Exception {
    }

    @Override
    public void setStateFailoverFailed(UID brokerSession) throws Exception {
    }

    public void setRemoteBrokerStateOnActivation() {
        if (this.local) {
            throw new RuntimeException("setRemoteBrokerStateOnActivation: unexpected call to local broker: " + this);
        }
        this.state = BrokerState.OPERATING;
    }

    public void setRemoteBrokerStateOnDeactivation() {
        if (this.local) {
            throw new RuntimeException("setRemoteBrokerStateOnDeactivation: unexpected call to local broker: " + this);
        }
        this.state = BrokerState.INITIALIZING;
    }

    @Override
    public void setState(BrokerState newstate) throws IllegalAccessException, IllegalStateException, IndexOutOfBoundsException {
        if (!this.local) {
            // empty if block
        }
        try {
            BrokerState oldState = this.getState();
            if (newstate != BrokerState.FAILOVER_PENDING && newstate != BrokerState.FAILOVER_PROCESSED && newstate != BrokerState.FAILOVER_FAILED && !Globals.getStore().updateBrokerState(this.brokerid, newstate, this.state, this.local)) {
                throw new IllegalStateException("Could not update broker state from " + oldState + " to state " + newstate + " for " + this.brokerid);
            }
            this.state = newstate;
            this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), oldState, this.state, null, null);
        }
        catch (BrokerException ex) {
            IllegalStateException e = new IllegalStateException("Failed to update state for " + this.brokerid);
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public TakeoverStoreInfo takeover(boolean force, Object extraInfo, TakingoverTracker tracker) throws BrokerException {
        Store store = Globals.getStore();
        BrokerState curstate = this.getState();
        store.getTakeOverLock(this.parent.getLocalBrokerName(), this.brokerid, 0L, curstate, 0L, null, force, tracker);
        TakeoverStoreInfo o = store.takeoverBrokerStore(this.brokerid, tracker.getStoreSessionUID(), null, tracker);
        this.parent.addSupportedStoreSessionUID(tracker.getStoreSessionUID());
        return o;
    }

    @Override
    public synchronized String getNodeName() throws BrokerException {
        String instn = this.getInstanceName();
        UID storeSession = this.getStoreSessionUID();
        return MigratableStoreUtil.makeEffectiveBrokerID(instn, storeSession);
    }
}

