/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.webresources.WarURLStreamHandler;

public class TomcatURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String WAR_PROTOCOL = "war";
    private static volatile TomcatURLStreamHandlerFactory instance = null;
    private final boolean registered;
    private final List<URLStreamHandlerFactory> userFactories = new CopyOnWriteArrayList<URLStreamHandlerFactory>();

    public static TomcatURLStreamHandlerFactory getInstance() {
        TomcatURLStreamHandlerFactory.getInstanceInternal(true);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TomcatURLStreamHandlerFactory getInstanceInternal(boolean register) {
        if (instance != null) return instance;
        Class<TomcatURLStreamHandlerFactory> clazz = TomcatURLStreamHandlerFactory.class;
        synchronized (TomcatURLStreamHandlerFactory.class) {
            if (instance != null) return instance;
            instance = new TomcatURLStreamHandlerFactory(register);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean register() {
        return TomcatURLStreamHandlerFactory.getInstanceInternal(true).isRegistered();
    }

    public static boolean disable() {
        return !TomcatURLStreamHandlerFactory.getInstanceInternal(false).isRegistered();
    }

    public static void release(ClassLoader classLoader) {
        Iterator<URLStreamHandlerFactory> iter = TomcatURLStreamHandlerFactory.instance.userFactories.iterator();
        block0: while (iter.hasNext()) {
            for (ClassLoader factoryLoader = iter.next().getClass().getClassLoader(); factoryLoader != null; factoryLoader = factoryLoader.getParent()) {
                if (!classLoader.equals(factoryLoader)) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private TomcatURLStreamHandlerFactory(boolean register) {
        this.registered = register;
        if (register) {
            URL.setURLStreamHandlerFactory(this);
        }
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void addUserFactory(URLStreamHandlerFactory factory) {
        this.userFactories.add(factory);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (WAR_PROTOCOL.equals(protocol)) {
            return new WarURLStreamHandler();
        }
        for (URLStreamHandlerFactory factory : this.userFactories) {
            URLStreamHandler handler = factory.createURLStreamHandler(protocol);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }
}

