/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.bundleresources;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.catalina.webresources.WarURLStreamHandler;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class BundleURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final String WAR_BUNDLE_ENTRY_SCHEMA = "war:bundle";
    private static final String WAR_TO_ENTRY_SEPARATOR = "\\^/";
    private final ExtendedWarURLStreamHandler handler = new ExtendedWarURLStreamHandler();

    public URLConnection openConnection(URL u) throws IOException {
        return new URL(null, u.toExternalForm(), (URLStreamHandler)((Object)this.handler)).openConnection();
    }

    private static class ExtendedWarURLStreamHandler
    extends WarURLStreamHandler {
        private ExtendedWarURLStreamHandler() {
        }

        protected void parseURL(URL u, String spec, int start, int limit) {
            if (spec.startsWith(BundleURLStreamHandlerService.WAR_BUNDLE_ENTRY_SCHEMA)) {
                String path = spec.substring(4);
                path = path.replaceFirst(BundleURLStreamHandlerService.WAR_TO_ENTRY_SEPARATOR, "");
                this.setURL(u, u.getProtocol(), "", -1, null, null, path, null, null);
            } else {
                super.parseURL(u, spec, start, limit);
            }
        }
    }
}

