/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;

public class SuperClassListener
implements IPartListener,
ResourceSetListener,
IXtextModelListener {
    private DiagramEditorBase diagramEditor;
    private Object editorClass;
    private List<TransactionalEditingDomain> domains;
    private List<IXtextDocument> xtextDocuments;
    private boolean changeInSuperClass;

    public SuperClassListener(DiagramEditorBase diagramEditor, Object editorClass) {
        this.diagramEditor = diagramEditor;
        this.editorClass = editorClass;
        this.domains = new ArrayList<TransactionalEditingDomain>();
        this.xtextDocuments = new ArrayList<IXtextDocument>();
        this.changeInSuperClass = false;
        assert (editorClass instanceof Class) : "Class expected";
    }

    public boolean isChangeInSuperClass() {
        return this.changeInSuperClass;
    }

    public void dispose() {
        for (TransactionalEditingDomain domain : this.domains) {
            if (domain == null) continue;
            domain.removeResourceSetListener((ResourceSetListener)this);
        }
        for (IXtextDocument document : this.xtextDocuments) {
            if (document == null) continue;
            document.removeModelListener((IXtextModelListener)this);
        }
        this.domains.clear();
        this.xtextDocuments.clear();
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        IXtextDocument toRemove;
        DiagramEditorBase editor;
        TransactionalEditingDomain toRemove2;
        if (part == this.diagramEditor) {
            this.dispose();
            return;
        }
        if (part instanceof DiagramEditorBase && (toRemove2 = (editor = (DiagramEditorBase)part).getEditingDomain()) != null) {
            toRemove2.removeResourceSetListener((ResourceSetListener)this);
            this.domains.remove(toRemove2);
        }
        if (((Class)this.editorClass).isInstance(part) && (toRemove = ((XtextEditor)part).getDocument()) != null) {
            toRemove.removeModelListener((IXtextModelListener)this);
            this.xtextDocuments.remove(toRemove);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part == this.diagramEditor) {
            this.changeInSuperClass = false;
        }
    }

    public void partOpened(IWorkbenchPart part) {
        IXtextDocument document;
        DiagramEditorBase editor;
        TransactionalEditingDomain domain;
        if (part == this.diagramEditor) {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editor2 = editorRef.getEditor(false);
                if (editor2 != null && editor2 != this.diagramEditor) {
                    this.partOpened((IWorkbenchPart)editor2);
                }
                ++n2;
            }
            return;
        }
        if (part instanceof DiagramEditorBase && !this.domains.contains(domain = (editor = (DiagramEditorBase)part).getEditingDomain()) && this.diagramEditor.registerSuperClassListener(editor)) {
            domain.addResourceSetListener((ResourceSetListener)this);
            this.domains.add(domain);
        }
        if (((Class)this.editorClass).isInstance(part) && !this.xtextDocuments.contains(document = (editor = (XtextEditor)part).getDocument()) && this.diagramEditor.registerSuperClassListener((XtextEditor)editor)) {
            editor.getDocument().addModelListener((IXtextModelListener)this);
            this.xtextDocuments.add(document);
        }
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        this.changeInSuperClass = true;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void modelChanged(XtextResource resource) {
        this.changeInSuperClass = true;
    }
}

