/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.PListParser;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.osgi.util.NLS;

public class MacInstalledJREs {
    private static final String JAVA_HOME_PLIST = "/usr/libexec/java_home";
    private static final String PLIST_JVM_HOME_PATH = "JVMHomePath";
    private static final String PLIST_JVM_NAME = "JVMName";
    private static final String PLIST_JVM_VERSION = "JVMVersion";
    private static final String PLIST_JVM_BUNDLE_ID = "JVMBundleID";
    public static final VMStandin[] NO_VMS = new VMStandin[0];

    public static VMStandin[] getInstalledJREs(IProgressMonitor monitor) throws CoreException {
        SubMonitor smonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            File javaHome = new File(JAVA_HOME_PLIST);
            if (!javaHome.exists()) {
                throw new CoreException(Status.warning((String)"The java_home executable does not exist"));
            }
            String[] cmdLine = new String[]{JAVA_HOME_PLIST, "-X"};
            Process p = null;
            try {
                p = DebugPlugin.exec((String[])cmdLine, null);
                IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"JRE Install Detection");
                int i = 0;
                while (i < 600) {
                    if (process.isTerminated()) break;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++i;
                }
                VMStandin[] vMStandinArray = MacInstalledJREs.parseJREInfo(process, monitor);
                if (p != null) {
                    p.destroy();
                }
                return vMStandinArray;
            }
            catch (Throwable throwable) {
                if (p != null) {
                    p.destroy();
                }
                throw throwable;
            }
        }
        finally {
            if (!smonitor.isCanceled()) {
                smonitor.done();
            }
        }
    }

    private static VMStandin[] parseJREInfo(IProcess process, IProgressMonitor monitor) {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        String text = null;
        if (streamsProxy != null) {
            text = streamsProxy.getOutputStreamMonitor().getContents();
        }
        if (text != null && text.length() > 0) {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes());
            return MacInstalledJREs.parseJREInfo(stream, monitor);
        }
        return NO_VMS;
    }

    public static VMStandin[] parseJREInfo(InputStream stream, IProgressMonitor monitor) {
        SubMonitor smonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)LaunchingMessages.MacInstalledJREs_0, (int)10);
        try {
            Object result = new PListParser().parse(stream);
            if (result instanceof Object[]) {
                Object[] maps = (Object[])result;
                smonitor.setWorkRemaining(maps.length);
                LinkedHashSet<MacVMStandin> jres = new LinkedHashSet<MacVMStandin>();
                AbstractVMInstallType mactype = (AbstractVMInstallType)JavaRuntime.getVMInstallType("org.eclipse.jdt.internal.launching.macosx.MacOSXType");
                if (mactype != null) {
                    Object[] objectArray = maps;
                    int n = maps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Map map;
                        Object v;
                        Object entry = objectArray[n2];
                        if (smonitor.isCanceled()) {
                            VMStandin[] vMStandinArray = jres.toArray(new VMStandin[jres.size()]);
                            return vMStandinArray;
                        }
                        if (entry instanceof Map && (v = (map = (Map)entry).get(PLIST_JVM_HOME_PATH)) instanceof String) {
                            String home = (String)v;
                            Object v2 = map.get(PLIST_JVM_NAME);
                            if (v2 instanceof String) {
                                String name = (String)v2;
                                Object v3 = map.get(PLIST_JVM_VERSION);
                                if (v3 instanceof String) {
                                    String version = (String)v3;
                                    smonitor.setTaskName(NLS.bind((String)LaunchingMessages.MacInstalledJREs_1, (Object)name, (Object)version));
                                    File loc = new File(home);
                                    String vmName = name + " [" + version + "]";
                                    MacVMStandin vm = new MacVMStandin(mactype, loc, vmName, version, MacInstalledJREs.computeId(map, version));
                                    vm.setJavadocLocation(mactype.getDefaultJavadocLocation(loc));
                                    vm.setLibraryLocations(mactype.getDefaultLibraryLocations(loc));
                                    vm.setVMArgs(mactype.getDefaultVMArguments(loc));
                                    jres.add(vm);
                                }
                            }
                        }
                        smonitor.worked(1);
                        ++n2;
                    }
                }
                VMStandin[] vMStandinArray = jres.toArray(new VMStandin[jres.size()]);
                return vMStandinArray;
            }
        }
        catch (CoreException ce) {
            LaunchingPlugin.log(ce);
        }
        finally {
            smonitor.done();
        }
        return NO_VMS;
    }

    static String computeId(Map<?, ?> map, String version) {
        String id;
        Object o = map.get(PLIST_JVM_BUNDLE_ID);
        return o instanceof String ? (id = (String)o) : version;
    }

    public static class MacVMStandin
    extends VMStandin {
        String version = null;

        public MacVMStandin(IVMInstallType type, File location, String name, String version, String id) {
            super(type, id);
            this.setInstallLocation(location);
            this.setName(name);
            this.version = version;
        }

        @Override
        public String getJavaVersion() {
            return this.version;
        }
    }
}

