/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.annotations.builtin;

import org.eclipse.escet.cif.common.CifDocAnnotationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProvider;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class DocAnnotationProvider
extends AnnotationProvider {
    @Override
    public final void checkAnnotation(AnnotatedObject annotatedObject, Annotation annotation, AnnotationProblemReporter reporter) {
        if (annotation.getArguments().isEmpty()) {
            reporter.reportProblem(annotation, "missing an argument.", annotation.getPosition(), SemanticProblemSeverity.ERROR);
        }
        for (AnnotationArgument arg : annotation.getArguments()) {
            if (arg.getName() != null) {
                reporter.reportProblem(annotation, "unsupported named argument.", arg.getPosition(), SemanticProblemSeverity.ERROR);
            }
            boolean doEvaluationCheck = true;
            CifType valueType = CifTypeUtils.normalizeType((CifType)arg.getValue().getType());
            if (!(valueType instanceof StringType)) {
                reporter.reportProblem(annotation, Strings.fmt((String)"argument must have a value of type \"string\", but has a value of type \"%s\".", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)valueType)}), arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
                doEvaluationCheck = false;
            }
            if (!CifValueUtils.hasSingleValue((Expression)arg.getValue(), (boolean)false, (boolean)true)) {
                reporter.reportProblem(annotation, "argument cannot be evaluated statically.", arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
                doEvaluationCheck = false;
            }
            if (!doEvaluationCheck) continue;
            try {
                CifDocAnnotationUtils.getDoc((Annotation)annotation);
            }
            catch (InvalidModelException e) {
                CifEvalException evalErr = (CifEvalException)e.getCause();
                Object evalErrMsg = evalErr.toString();
                if (!((String)evalErrMsg).endsWith(".")) {
                    evalErrMsg = (String)evalErrMsg + ".";
                }
                reporter.reportProblem(annotation, Strings.fmt((String)"argument cannot be evaluated statically, as evaluating it results in an evaluation error: %s", (Object[])new Object[]{evalErrMsg}), arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
            }
        }
    }

    @Override
    public final void checkGlobal(Specification spec, AnnotationProblemReporter reporter) {
    }
}

