/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased;

import java.util.List;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.EventAtLocation;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.builders.AutomatonBuilder;
import org.eclipse.escet.cif.eventbased.builders.State;
import org.eclipse.escet.cif.eventbased.builders.StateEdges;
import org.eclipse.escet.common.java.Lists;

public class ControllabilityCheck {
    private ControllabilityCheck() {
    }

    public static List<EventAtLocation> controllabilityCheck(List<Automaton> auts) {
        Automaton sup = null;
        List plants = Lists.list();
        for (Automaton aut : auts) {
            switch (aut.kind) {
                case PLANT: {
                    plants.add(aut);
                    break;
                }
                case SUPERVISOR: {
                    sup = aut;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected automaton kind.");
                }
            }
        }
        return ControllabilityCheck.controllabilityCheck(sup, plants);
    }

    public static List<EventAtLocation> controllabilityCheck(Automaton sup, List<Automaton> plants) {
        List<EventAtLocation> disableds = ControllabilityCheck.getDisabledEvents(sup, plants);
        List uncontrolleds = Lists.list();
        List controlleds = Lists.list();
        for (EventAtLocation de : disableds) {
            if (de.evt.isControllable()) {
                controlleds.add(de);
                continue;
            }
            uncontrolleds.add(de);
        }
        if (uncontrolleds.isEmpty()) {
            if (controlleds.isEmpty()) {
                return null;
            }
            return controlleds;
        }
        return uncontrolleds;
    }

    public static List<EventAtLocation> getDisabledEvents(Automaton sup, List<Automaton> plants) {
        List automs = Lists.listc((int)(plants.size() + 1));
        automs.addAll(plants);
        automs.add(sup);
        List disableds = Lists.list();
        AutomatonBuilder builder = new AutomatonBuilder(automs);
        for (State srcState : builder) {
            Location srcLoc = builder.getLocation(srcState);
            builder.edgeBuilder.setupStateEdges(srcState);
            for (StateEdges se : builder.edgeBuilder.getStateEdges()) {
                int idx = se.disabledIndex();
                if (idx >= 0) {
                    if (idx < plants.size()) continue;
                    disableds.add(new EventAtLocation(srcLoc, se.event));
                    continue;
                }
                for (State destState : se) {
                    builder.getLocation(destState);
                }
            }
        }
        return disableds;
    }
}

