/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.builders;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.builders.EdgeBuilder;
import org.eclipse.escet.cif.eventbased.builders.State;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.exceptions.ApplicationException;

public class StateExplorer<V>
implements Iterable<State> {
    public final List<Automaton> automs;
    public final Set<Event> destAlphabet;
    protected Map<State, V> destLocs = Maps.map();
    public EdgeBuilder edgeBuilder;
    protected Queue<State> unfinished = new ArrayDeque<State>();

    public StateExplorer(List<Automaton> automs) {
        Assert.check((!automs.isEmpty() ? 1 : 0) != 0);
        this.automs = automs;
        this.destAlphabet = this.getCombinedAlphabet();
        this.edgeBuilder = new EdgeBuilder(automs, this.destAlphabet);
    }

    public void addValue(State state, V value, boolean checkNew) {
        V old = this.destLocs.put(state, value);
        this.unfinished.add(state);
        if (!checkNew || old != null) {
            return;
        }
        throw new ApplicationException("Double assignment to a state.");
    }

    public boolean hasValue(State state) {
        return this.destLocs.containsKey(state);
    }

    public V getValue(State state) {
        return this.destLocs.get(state);
    }

    public State makeInitialState() {
        Location[] locs = new Location[this.automs.size()];
        int i = 0;
        while (i < this.automs.size()) {
            locs[i] = this.automs.get((int)i).initial;
            if (locs[i] == null) {
                return null;
            }
            ++i;
        }
        return new State(locs);
    }

    private Set<Event> getCombinedAlphabet() {
        Set destAlphabet = Sets.set();
        for (Automaton aut : this.automs) {
            destAlphabet.addAll(aut.alphabet);
        }
        return destAlphabet;
    }

    @Override
    public Iterator<State> iterator() {
        return new UnfinishedIterator();
    }

    private final class UnfinishedIterator
    implements Iterator<State> {
        @Override
        public boolean hasNext() {
            return !StateExplorer.this.unfinished.isEmpty();
        }

        @Override
        public State next() {
            return StateExplorer.this.unfinished.remove();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

