/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps.conversion;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutOnlyDeterministicCheck
extends CifCheckNoCompDefInst {
    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        for (Location loc : aut.getLocations()) {
            Map seenEvents = Maps.map();
            for (Edge edge : loc.getEdges()) {
                if (!edge.getGuards().isEmpty() && !CifValueUtils.isTriviallyTrue((List)edge.getGuards(), (boolean)false, (boolean)true)) {
                    if (!CifValueUtils.isTriviallyFalse((List)edge.getGuards(), (boolean)false, (boolean)true)) continue;
                    continue;
                }
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    Expression eventRef = edgeEvent.getEvent();
                    if (eventRef instanceof TauExpression) continue;
                    Event event = ((EventExpression)eventRef).getEvent();
                    EdgeEvent previousEdgeEvent = (EdgeEvent)seenEvents.get(event);
                    if (previousEdgeEvent == null) {
                        seenEvents.put(event, edgeEvent);
                        continue;
                    }
                    violations.add((PositionObject)previousEdgeEvent, "An automaton is non-deterministic", new Object[0]);
                    violations.add((PositionObject)edgeEvent, "An automaton is non-deterministic", new Object[0]);
                }
            }
        }
    }
}

