/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.RealDistribution;
import org.eclipse.escet.common.java.Strings;

public class WeibullDistribution
extends RealDistribution {
    private final CifRandomGenerator randGen;
    private final double shape;
    private final double scale;

    public WeibullDistribution(CifRandomGenerator randGen, double shape, double scale) {
        this.randGen = randGen;
        this.shape = shape;
        this.scale = scale;
        if (shape <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The shape parameter (the first parameter) is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
        if (scale <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The scale parameter (the second parameter) is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private WeibullDistribution(WeibullDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.shape = distribution.shape;
        this.scale = distribution.scale;
    }

    @Override
    public RealDistribution copy() {
        return new WeibullDistribution(this);
    }

    @Override
    public double sample() {
        return this.scale * Math.pow(-Math.log(1.0 - this.randGen.draw()), 1.0 / this.shape);
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"weibull(%s, %s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.shape), CifSimulatorMath.realToStr(this.scale)});
    }
}

