/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.internal.ServiceDetails;
import org.eclipse.soda.sat.plugin.activator.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.util.TypeSearchUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportedServiceDetails
extends ServiceDetails
implements IExportedServiceDetails {
    private static final String IMPLEMENTATION_CLASS_NAME_IS_INVALID_KEY = "ExportedServiceDetails.ImplementationClassNameIsInvalid";
    private boolean storedInField;
    private boolean hasProperties;
    private boolean proxy;
    private IType implementationClass;
    private List<IType> implementationClasses;

    public ExportedServiceDetails(IType type, IJavaProject javaProject, boolean storedInField, boolean hasProperties, boolean proxy) {
        super(type, javaProject);
        this.setStoredInField(storedInField);
        this.setHasProperties(hasProperties);
        this.setProxy(proxy);
    }

    private void collectImplementorsOf(IType type, Set<IType> results) {
        IJavaProject javaProject = this.getJavaProject();
        try {
            List<SearchMatch> types = TypeSearchUtility.findImplementorsOf(type, javaProject);
            for (SearchMatch match : types) {
                boolean added;
                IType matchingType;
                boolean concreteClass;
                Object element = match.getElement();
                if (!(element instanceof IType) || !(concreteClass = TypeSearchUtility.isConcreteClass(matchingType = (IType)match.getElement())) || !(added = results.add(matchingType))) continue;
                this.collectImplementorsOf(matchingType, results);
            }
        }
        catch (CoreException exception) {
            this.logError(exception);
        }
    }

    private IType findCandidateImplementationClass(String name) {
        if (name == null) {
            return null;
        }
        List<IType> list = this.getCandidateImplementationClasses();
        Iterator<IType> iterator = list.iterator();
        boolean found = false;
        IType type = null;
        while (!found && iterator.hasNext()) {
            type = iterator.next();
            String typeName = type.getFullyQualifiedName();
            found = typeName.equals(name);
        }
        if (found) {
            return type;
        }
        String pattern = Messages.getString(IMPLEMENTATION_CLASS_NAME_IS_INVALID_KEY);
        Object[] values = new Object[]{name};
        String message = MessageFormat.format(pattern, values);
        throw new IllegalArgumentException(message);
    }

    private List<IType> findImplementationClasses() {
        List<IType> results;
        IType type = this.getType();
        boolean classType = this.isClass();
        if (classType) {
            results = new ArrayList<IType>(1);
            results.add(type);
        } else {
            results = this.findImplementorsOf(type);
        }
        return results;
    }

    private List<IType> findImplementorsOf(IType type) {
        HashSet<IType> set = new HashSet<IType>(75);
        this.collectImplementorsOf(type, set);
        int size = set.size();
        ArrayList<IType> results = new ArrayList<IType>(size);
        results.addAll(set);
        return results;
    }

    @Override
    public IType getCandidateImplementationClass(String name) {
        IType type = this.findCandidateImplementationClass(name);
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IType> getCandidateImplementationClasses() {
        ExportedServiceDetails exportedServiceDetails = this;
        synchronized (exportedServiceDetails) {
            if (this.implementationClasses == null) {
                List<IType> list = this.findImplementationClasses();
                this.setImplementationClasses(list);
            }
        }
        return this.implementationClasses;
    }

    @Override
    public IType getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public boolean hasProperties() {
        return this.hasProperties;
    }

    @Override
    public boolean isProxy() {
        return this.proxy;
    }

    @Override
    public boolean isStoredInField() {
        return this.storedInField;
    }

    @Override
    public void setHasProperties(boolean hasProperties) {
        this.hasProperties = hasProperties;
    }

    @Override
    public void setImplementationClass(IType implementationClass) {
        this.implementationClass = implementationClass;
    }

    private void setImplementationClasses(List<IType> implementationClasses) {
        this.implementationClasses = implementationClasses;
    }

    @Override
    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    @Override
    public void setStoredInField(boolean storedInField) {
        this.storedInField = storedInField;
    }

    @Override
    public void setType(IType type) {
        super.setType(type);
        boolean classType = this.isClass();
        IType implementationClass = classType ? type : null;
        this.setImplementationClass(implementationClass);
        this.setImplementationClasses(null);
    }
}

