/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.parser;

import java.io.InputStream;
import java.io.Reader;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.TestScript;
import org.eclipse.soda.dk.testmanager.action.ConfigurationAction;
import org.eclipse.soda.dk.testmanager.action.ConfigurationActionFactory;
import org.eclipse.soda.dk.testmanager.action.TestAction;
import org.eclipse.soda.dk.testmanager.action.TestActionFactory;
import org.eclipse.soda.dk.testmanager.parser.PropertyConverterUtility;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentHandler
extends DefaultHandler {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String SCHEMA_SOURCE = "/dktest.xsd";
    TestScript script = new TestScript();
    State state = new EndDocumentState();
    int lineNumber = 1;
    private int actionNumber = 1;
    static /* synthetic */ Class class$0;

    public static TestScript parse(SAXParser saxParser, Reader in) throws Exception {
        if (saxParser.isValidating()) {
            try {
                saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.soda.dk.testmanager.parser.ContentHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream schema = clazz.getResourceAsStream(SCHEMA_SOURCE);
                saxParser.setProperty(JAXP_SCHEMA_SOURCE, schema);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        }
        InputSource inputSource = new InputSource(in);
        ContentHandler contentHandler = new ContentHandler();
        saxParser.parse(inputSource, (DefaultHandler)contentHandler);
        return contentHandler.getTestScript();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.state.characters(ch, start, length);
        this.countLines(ch, start, length);
    }

    public void endDocument() {
        this.state.endDocument();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.state.endElement(localName);
    }

    public String getActionId(String id) {
        if (id == null || id.length() == 0) {
            return Integer.toString(this.actionNumber++);
        }
        return id;
    }

    private TestScript getTestScript() {
        return this.script;
    }

    public void startDocument() {
        this.state.startDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.state.startElement(localName, atts);
    }

    private void countLines(char[] ch, int start, int length) {
        int i = start;
        int end = start + length;
        while (i < end) {
            if (ch[i++] != '\n') continue;
            ++this.lineNumber;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.countLines(ch, start, length);
    }

    class ActionsState
    extends State {
        public ActionsState(State parentState) {
            super(parentState);
        }

        void endElement(String localName) throws SAXParseException {
            if ("actions".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("configurationAction".equals(localName)) {
                String id = ContentHandler.this.getActionId(super.trim(atts.getValue("id")));
                String type = super.trim(atts.getValue("type"));
                ConfigurationAction configurationAction = ConfigurationActionFactory.create(id, type);
                ContentHandler.this.script.add(configurationAction);
                ContentHandler.this.state = new ConfigurationActionState(this, configurationAction);
            } else if ("testAction".equals(localName)) {
                String id = ContentHandler.this.getActionId(super.trim(atts.getValue("id")));
                String type = super.trim(atts.getValue("type"));
                TestAction testAction = TestActionFactory.create(id, type);
                ContentHandler.this.script.add(testAction);
                ContentHandler.this.state = new TestActionState(this, testAction);
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }

    class AttributeState
    extends State {
        private String attrName;
        private Map attributes;

        public AttributeState(State parentState, String attrName, Map attributes) {
            super(parentState);
            this.attrName = attrName;
            this.attributes = attributes;
        }

        public void characters(char[] ch, int start, int length) {
            this.attributes.put(this.attrName, new String(ch, start, length));
        }

        void endElement(String localName) throws SAXParseException {
            if (this.attrName.equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            this.unexpectedStartElement(localName);
        }
    }

    class ConfigurationActionState
    extends State {
        private ConfigurationAction configurationAction;

        public ConfigurationActionState(State parentState, ConfigurationAction configurationAction) {
            super(parentState);
            this.configurationAction = configurationAction;
        }

        void endElement(String localName) throws SAXParseException {
            if ("configurationAction".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("configurations".equals(localName)) {
                ContentHandler.this.state = new ConfigurationsState(this, this.configurationAction);
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }

    class ConfigurationState
    extends State {
        private Dictionary properties;

        public ConfigurationState(State parentState, Dictionary properties) {
            super(parentState);
            this.properties = properties;
        }

        void endElement(String localName) throws SAXParseException {
            if ("configuration".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("properties".equals(localName)) {
                ContentHandler.this.state = new PropertiesState(this, this.properties);
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }

    class ConfigurationsState
    extends State {
        private ConfigurationAction configurationAction;

        public ConfigurationsState(State parentState, ConfigurationAction configurationAction) {
            super(parentState);
            this.configurationAction = configurationAction;
        }

        void endElement(String localName) throws SAXParseException {
            if ("configurations".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("configuration".equals(localName)) {
                String id = ContentHandler.this.getActionId(super.trim(atts.getValue("id")));
                String controllerId = super.trim(atts.getValue("controller"));
                String pid = super.trim(atts.getValue("pid"));
                String factoryPid = super.trim(atts.getValue("factoryPid"));
                String bundleLocation = super.trim(atts.getValue("bundleLocation"));
                String filter = super.trim(atts.getValue("filter"));
                Hashtable properties = new Hashtable();
                this.configurationAction.addConfiguration(id, controllerId, pid, factoryPid, bundleLocation, filter, properties);
                ContentHandler.this.state = new ConfigurationState(this, properties);
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }

    class EndDocumentState
    extends State {
        public EndDocumentState() {
            super(null);
        }
    }

    class PropertiesState
    extends State {
        private Dictionary properties;

        public PropertiesState(State parentState, Dictionary properties) {
            super(parentState);
            this.properties = properties;
        }

        void endElement(String localName) throws SAXParseException {
            if ("properties".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("property".equals(localName)) {
                block7: {
                    String key = super.trim(atts.getValue("key"));
                    String value = super.trim(atts.getValue("value"));
                    String type = super.trim(atts.getValue("type"));
                    String cardinality = super.trim(atts.getValue("cardinality"));
                    try {
                        if (cardinality == null) {
                            this.properties.put(key, PropertyConverterUtility.convert(value, type));
                            break block7;
                        }
                        int c = 1;
                        try {
                            c = Integer.parseInt(cardinality);
                        }
                        catch (NumberFormatException e) {
                            this.unexpectedAttributeValue("cardinality", cardinality, e.getMessage());
                        }
                        this.properties.put(key, PropertyConverterUtility.convert(value, type, c));
                    }
                    catch (NumberFormatException e) {
                        this.unexpectedAttributeValue("value", value, e.getLocalizedMessage());
                    }
                }
                ContentHandler.this.state = new PropertyState(this);
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }

    class PropertyState
    extends State {
        public PropertyState(State parentState) {
            super(parentState);
        }

        void endElement(String localName) throws SAXParseException {
            if ("property".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            this.unexpectedStartElement(localName);
        }
    }

    class StartDocumentState
    extends State {
        public StartDocumentState() {
            super(null);
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("validationTest".equals(localName)) {
                ContentHandler.this.state = new ValidationTestState(this);
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }

    abstract class State {
        protected State parentState;

        protected State(State parentState) {
            this.parentState = parentState;
        }

        public void characters(char[] ch, int start, int length) {
        }

        void endDocument() {
            ContentHandler.this.state = new EndDocumentState();
        }

        void endElement(String localName) throws SAXParseException {
        }

        protected void returnToParent() {
            ContentHandler.this.state = this.parentState;
        }

        void startDocument() {
            ContentHandler.this.state = new StartDocumentState();
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
        }

        String trim(String toTrim) {
            if (toTrim != null) {
                return toTrim.trim();
            }
            return null;
        }

        void unexpectedAttributeValue(String attr, String value, String message) throws SAXParseException {
            Object[] parms = new Object[]{attr, value, message, new Integer(ContentHandler.this.lineNumber)};
            throw new SAXParseException(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7195)), (Object[])parms), null, null, ContentHandler.this.lineNumber, 0);
        }

        void unexpectedEndElement(String localName) throws SAXParseException {
            Object[] parms = new Object[]{localName, new Integer(ContentHandler.this.lineNumber)};
            throw new SAXParseException(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7151)), (Object[])parms), null, null, ContentHandler.this.lineNumber, 0);
        }

        void unexpectedStartElement(String localName) throws SAXParseException {
            Object[] parms = new Object[]{localName, new Integer(ContentHandler.this.lineNumber)};
            throw new SAXParseException(Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7150)), (Object[])parms), null, null, ContentHandler.this.lineNumber, 0);
        }
    }

    class TestActionState
    extends State {
        private TestAction testAction;

        public TestActionState(State parentState, TestAction testAction) {
            super(parentState);
            this.testAction = testAction;
        }

        void endElement(String localName) throws SAXParseException {
            if ("testAction".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("tests".equals(localName)) {
                ContentHandler.this.state = new TestsState(this, this.testAction);
            } else if ("testAction".equals(localName)) {
                String id = ContentHandler.this.getActionId(super.trim(atts.getValue("id")));
                String type = super.trim(atts.getValue("type"));
                TestAction testAction = TestActionFactory.create(id, type);
                this.testAction.add(testAction);
                ContentHandler.this.state = new TestActionState(this, testAction);
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }

    class TestState
    extends State {
        private Dictionary properties;

        public TestState(State parentState, Dictionary properties) {
            super(parentState);
            this.properties = properties;
        }

        void endElement(String localName) throws SAXParseException {
            if ("test".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("properties".equals(localName)) {
                ContentHandler.this.state = new PropertiesState(this, this.properties);
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }

    class TestsState
    extends State {
        private TestAction testAction;

        public TestsState(State parentState, TestAction testAction) {
            super(parentState);
            this.testAction = testAction;
        }

        void endElement(String localName) throws SAXParseException {
            if ("tests".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("test".equals(localName)) {
                String id = ContentHandler.this.getActionId(super.trim(atts.getValue("id")));
                String controllerId = super.trim(atts.getValue("controller"));
                String filter = super.trim(atts.getValue("filter"));
                String className = super.trim(atts.getValue("class"));
                String match = super.trim(atts.getValue("match"));
                Hashtable properties = new Hashtable();
                this.testAction.addTest(id, controllerId, filter, className, match, properties);
                ContentHandler.this.state = new TestState(this, properties);
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }

    class ValidationTestState
    extends State {
        public ValidationTestState(State parentState) {
            super(parentState);
        }

        void endElement(String localName) throws SAXParseException {
            if ("validationTest".equals(localName)) {
                this.returnToParent();
            } else {
                this.unexpectedEndElement(localName);
            }
        }

        void startElement(String localName, Attributes atts) throws SAXParseException {
            if ("actions".equals(localName)) {
                ContentHandler.this.state = new ActionsState(this);
            } else if ("title".equals(localName) || "provider".equals(localName) || "version".equals(localName) || "vendor".equals(localName) || "description".equals(localName)) {
                ContentHandler.this.state = new AttributeState(this, localName, ContentHandler.this.script.getAttributes());
            } else {
                this.unexpectedStartElement(localName);
            }
        }
    }
}

