/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testcontroller.config.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.testagent.service.TestAgentService;
import org.eclipse.soda.dk.testcontroller.TestController;
import org.eclipse.soda.dk.testcontroller.service.TestConfigurationService;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class OSGiTestConfiguration
implements TestConfigurationService {
    private static final TestAgentService[] NO_TESTS = new TestAgentService[0];
    private IServiceDetecter serviceDetecter;
    private ConfigurationAdmin configurationAdmin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFactoryConfiguration(String factoryPid, String bundleLocation, Dictionary properties) throws IOException {
        Configuration configuration;
        OSGiTestConfiguration oSGiTestConfiguration = this;
        synchronized (oSGiTestConfiguration) {
            if (this.configurationAdmin == null) {
                this.throwUnsupportedOperation();
                configuration = null;
            } else {
                Object[] parms = new Object[]{factoryPid};
                LogUtility.logDebug((Object)this, (String)Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7051)), (Object[])parms));
                configuration = this.configurationAdmin.createFactoryConfiguration(factoryPid, bundleLocation);
            }
        }
        if (configuration != null) {
            configuration.update(properties);
            this.waitForUpdate(configuration.getPid(), bundleLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdateConfiguration(String pid, String bundleLocation, Dictionary properties) throws IOException {
        Configuration configuration;
        OSGiTestConfiguration oSGiTestConfiguration = this;
        synchronized (oSGiTestConfiguration) {
            if (this.configurationAdmin == null) {
                this.throwUnsupportedOperation();
                configuration = null;
            } else {
                Object[] parms = new Object[]{pid};
                LogUtility.logDebug((Object)this, (String)Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7052)), (Object[])parms));
                configuration = this.configurationAdmin.getConfiguration(pid, bundleLocation);
            }
        }
        if (configuration != null) {
            configuration.update(properties);
            this.waitForUpdate(configuration.getPid(), bundleLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfigurations(String filter) throws IOException, InvalidSyntaxException {
        OSGiTestConfiguration oSGiTestConfiguration = this;
        synchronized (oSGiTestConfiguration) {
            if (this.configurationAdmin == null) {
                this.throwUnsupportedOperation();
            } else {
                Configuration[] configurations = this.configurationAdmin.listConfigurations(filter);
                if (configurations == null) {
                    Object[] parms = new Object[]{filter};
                    LogUtility.logDebug((Object)this, (String)Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7053)), (Object[])parms));
                } else {
                    int i = 0;
                    while (i < configurations.length) {
                        try {
                            Object[] parms = new Object[]{configurations[i].getPid()};
                            LogUtility.logDebug((Object)this, (String)Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7054)), (Object[])parms));
                            configurations[i].delete();
                        }
                        catch (IOException exception) {
                            Object[] parms = new Object[]{configurations[i].getPid()};
                            LogUtility.logError((Object)this, (String)Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7055)), (Object[])parms), (Throwable)exception);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestAgentService[] findTests(String filter, String className) throws InvalidSyntaxException {
        Object[] parms;
        List aquiredTests = null;
        int count = 10;
        try {
            do {
                this.serviceDetecter.setFilter(filter);
                aquiredTests = this.serviceDetecter.getServices();
                if (aquiredTests.size() != 0) continue;
                OSGiTestConfiguration oSGiTestConfiguration = this;
                synchronized (oSGiTestConfiguration) {
                    this.wait(500L);
                }
            } while (aquiredTests.size() == 0 && count-- > 0);
        }
        catch (InterruptedException interruptedException) {}
        if (aquiredTests == null || aquiredTests.size() == 0) {
            parms = new Object[]{filter};
            LogUtility.logWarning((Object)this, (String)Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7056)), (Object[])parms));
            return NO_TESTS;
        }
        if (className != null) {
            Iterator iter = aquiredTests.iterator();
            while (iter.hasNext()) {
                Object test = iter.next();
                if (test.getClass().getName().equals(className)) continue;
                iter.remove();
            }
            if (aquiredTests.size() == 0) {
                parms = new Object[]{filter, className};
                LogUtility.logWarning((Object)this, (String)Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7057)), (Object[])parms));
                return NO_TESTS;
            }
        }
        TestAgentService[] result = new TestAgentService[aquiredTests.size()];
        aquiredTests.toArray(result);
        return result;
    }

    public synchronized void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setNotificationService(NotificationService notificationService) {
    }

    public void setServiceDetecter(IServiceDetecter serviceDetecter) {
        if (this.serviceDetecter != null) {
            this.serviceDetecter.release();
        }
        this.serviceDetecter = serviceDetecter;
        if (serviceDetecter != null) {
            serviceDetecter.acquire();
        }
    }

    private void throwUnsupportedOperation() throws IOException {
        throw new IOException(TestController.DefaultResourceBundle.getString(Integer.toString(7059)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigurations(String filter, Dictionary properties) throws IOException, InvalidSyntaxException {
        Configuration[] configurations;
        OSGiTestConfiguration oSGiTestConfiguration = this;
        synchronized (oSGiTestConfiguration) {
            if (this.configurationAdmin == null) {
                this.throwUnsupportedOperation();
                configurations = null;
            } else {
                configurations = this.configurationAdmin.listConfigurations(filter);
            }
        }
        if (configurations != null) {
            int i = 0;
            while (i < configurations.length) {
                Object[] parms = new Object[]{configurations[i].getPid()};
                LogUtility.logDebug((Object)this, (String)Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7058)), (Object[])parms));
                configurations[i].update(properties);
                this.waitForUpdate(configurations[i].getPid(), configurations[i].getBundleLocation());
                ++i;
            }
        }
    }

    private void waitForUpdate(String pid, String bundleLocation) throws IOException {
        Thread.yield();
        Thread.yield();
        Thread.yield();
    }
}

