/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.epcglobal.llrp.helper.ParameterFactory;

public class LLRPDefaultParameters {
    public static Map getDefaultAISpecParameter(int[] antennaIds) {
        ArrayList<Map> inventoryParameterSpecParameters = new ArrayList<Map>();
        inventoryParameterSpecParameters.add(ParameterFactory.getInventoryParameterSpecParameter(12345, 1));
        return ParameterFactory.getAISpecParameter(antennaIds, ParameterFactory.getAISpecStopTriggerParameter(0, 0, null, null), inventoryParameterSpecParameters);
    }

    public static Map getDefaultAccessCommandParameter(int userDataReadOpId, int tidReadOpId) {
        ArrayList<Map> tagSpecs = new ArrayList<Map>();
        tagSpecs.add(LLRPDefaultParameters.getDefaultC1G2TagSpecParameter());
        ArrayList<Map> accessCmdOps = new ArrayList<Map>();
        accessCmdOps.add(ParameterFactory.getC1G2ReadParameter(userDataReadOpId, 0, 3, 0, 2));
        accessCmdOps.add(ParameterFactory.getC1G2ReadParameter(tidReadOpId, 0, 2, 0, 2));
        return ParameterFactory.getAccessCommandParameter(tagSpecs, accessCmdOps);
    }

    public static Map getDefaultAccessReportSpecParameter() {
        return ParameterFactory.getAccessReportSpecParameter(1);
    }

    public static Map getDefaultAccessSpecParameter(int accessSpecId, int roSpecId, int userDataReadOpId, int tidReadOpId) {
        return ParameterFactory.getAccessSpecParameter(accessSpecId, 0, 1, 0, roSpecId, LLRPDefaultParameters.getDefaultAccessSpecStopTriggerParameter(), LLRPDefaultParameters.getDefaultAccessCommandParameter(userDataReadOpId, tidReadOpId), LLRPDefaultParameters.getDefaultAccessReportSpecParameter());
    }

    public static Map getDefaultAccessSpecStopTriggerParameter() {
        return ParameterFactory.getAccessSpecStopTriggerParameter(0, 0);
    }

    public static Map getDefaultC1G2TagSpecParameter() {
        return ParameterFactory.getC1G2TagSpecParameter(ParameterFactory.getC1G2TargetTagParameter(1, true, 32, "", ""));
    }

    public static Map getDefaultROBoundarySpecParameter() {
        return ParameterFactory.getROBoundarySpecParameter(ParameterFactory.getROSpecStartTriggerParameter(0), ParameterFactory.getROSpecStopTriggerParameter(0, 0));
    }

    public static Map getDefaultROReportSpecParameter() {
        return ParameterFactory.getROReportSpecParameter(1, 1, ParameterFactory.getTagReportContentSelectorParameter());
    }

    public static Map getDefaultROReportSpecParameter(int trigger, int tagNum) {
        return ParameterFactory.getROReportSpecParameter(trigger, tagNum, ParameterFactory.getTagReportContentSelectorParameter());
    }

    public static List getDefaultROSpecChoice() {
        ArrayList<Map> specParameterChoice = new ArrayList<Map>();
        specParameterChoice.add(LLRPDefaultParameters.getDefaultAISpecParameter(new int[1]));
        return specParameterChoice;
    }

    public static Map getDefaultROSpecParameter(int roSpecId) {
        return ParameterFactory.getROSpecParameter(roSpecId, 0, 0, LLRPDefaultParameters.getDefaultROBoundarySpecParameter(), LLRPDefaultParameters.getDefaultROSpecChoice(), LLRPDefaultParameters.getDefaultROReportSpecParameter());
    }
}

