/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.device.test;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.device.test.DeviceTest;
import org.eclipse.soda.dk.epcglobal.llrp.device.EpcglobalLlrpDevice;
import org.eclipse.soda.dk.epcglobal.llrp.device.test.service.EpcglobalLlrpDeviceTestService;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.signal.service.SignalListener;

public class EpcglobalLlrpDeviceTest
extends DeviceTest
implements EpcglobalLlrpDeviceTestService,
Runnable,
CommandListener,
SignalListener,
MeasurementListener,
DeviceListener {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.epcglobal.llrp.device.test.EpcglobalLlrpDeviceTest";

    public static void main(String[] arguments) {
        EpcglobalLlrpDeviceTest testCase = new EpcglobalLlrpDeviceTest();
        testCase.run(arguments);
        System.exit(0);
    }

    protected static byte[] str2byteArray(String str) {
        char[] strChars = str.toCharArray();
        ArrayList<String> byteStrs = new ArrayList<String>();
        int i = 0;
        while (i < strChars.length) {
            StringBuffer byteStr = new StringBuffer();
            byteStr.append(strChars[i++]);
            if (i < strChars.length) {
                byteStr.append(strChars[i]);
            }
            if (i + 1 < strChars.length && strChars[i + 1] == ',') {
                ++i;
            }
            byteStrs.add(byteStr.toString());
            ++i;
        }
        byte[] bytes = new byte[byteStrs.size()];
        int i2 = 0;
        while (i2 < byteStrs.size()) {
            String byteStr = (String)byteStrs.get(i2);
            bytes[i2] = Integer.valueOf(byteStr, 16).byteValue();
            ++i2;
        }
        return bytes;
    }

    protected static String zeros(int num) {
        switch (num) {
            case 0: {
                return "";
            }
            case 1: {
                return "0";
            }
            case 2: {
                return "00";
            }
            case 3: {
                return "000";
            }
            case 4: {
                return "0000";
            }
        }
        return "";
    }

    protected Map getAISpecParameter(int[] antennaIds) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        Vector<Integer> antennaIdList = new Vector<Integer>();
        int i = 0;
        while (i < antennaIds.length) {
            antennaIdList.add(new Integer(antennaIds[i]));
            ++i;
        }
        parameters.put("AntennaIDs", antennaIdList);
        parameters.put("AISpecStopTriggerParameter", this.getAISpecStopTriggerParameter(0, 0));
        ArrayList<Map> inventoryParameterSpecParameters = new ArrayList<Map>();
        inventoryParameterSpecParameters.add(this.getInventoryParameterSpecParameter(12345, 1));
        parameters.put("InventoryParameterSpecParameter", inventoryParameterSpecParameters);
        Hashtable<String, Hashtable<String, Object>> result = new Hashtable<String, Hashtable<String, Object>>();
        result.put("AISpecParameter", parameters);
        return result;
    }

    protected Map getAISpecStopTriggerParameter(int type, int duration) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("AISpecStopTriggerType", new Integer(type));
        parameters.put("DurationTrigger", new Integer(duration));
        switch (type) {
            case 2: {
                break;
            }
        }
        return parameters;
    }

    protected Map getAccessCommandParameter() {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("AirProtocolTagSpecChoice", this.getC1G2TagSpecParameter());
        ArrayList<Map> accessCmdOps = new ArrayList<Map>();
        accessCmdOps.add(this.getC1G2ReadParameter(1, 0, 3, 0, 2));
        accessCmdOps.add(this.getC1G2ReadParameter(2, 0, 2, 0, 2));
        parameters.put("AccessCommandOpSpecChoice", accessCmdOps);
        return parameters;
    }

    protected Map getAccessReportSpecParameter(int accessReportTrigger) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("AccessReportTrigger", new Integer(accessReportTrigger));
        return parameters;
    }

    protected Map getAccessSpecIDParameter(int id) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("AccessSpecID", new Integer(id));
        return parameters;
    }

    protected Map getAccessSpecParameter() {
        Hashtable parameters = new Hashtable();
        return parameters;
    }

    protected Map getAccessSpecParameter(int accessSpecId, int antennaId, int protocolId, boolean currentState, int ROSpecId) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("AccessSpecID", new Integer(accessSpecId));
        parameters.put("AntennaID", new Integer(antennaId));
        parameters.put("ProtocolID", new Integer(protocolId));
        parameters.put("AccessSpec_CurrentState", currentState ? Boolean.TRUE : Boolean.FALSE);
        parameters.put("ROSpecID", new Integer(ROSpecId));
        parameters.put("AccessSpecStopTriggerParameter", this.getAccessSpecStopTriggerParameter(0, 0));
        parameters.put("AccessCommandParameter", this.getAccessCommandParameter());
        parameters.put("AccessReportSpecParameter", this.getAccessReportSpecParameter(0));
        return parameters;
    }

    protected Map getAccessSpecStopTriggerParameter(int accessSpecStopTrigger, int operationCountValue) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("AccessSpecStopTrigger", new Integer(accessSpecStopTrigger));
        parameters.put("OperationCountValue", new Integer(operationCountValue));
        return parameters;
    }

    protected Map getAddAccessSpecCommandParameters() {
        Hashtable<String, Map> parameters = new Hashtable<String, Map>();
        parameters.put("AccessSpecParameter", this.getAccessSpecParameter(1, 0, 1, false, 0));
        return parameters;
    }

    protected Map getAddROSpecCommandParameters(int id) {
        Hashtable<String, Map> parameters = new Hashtable<String, Map>();
        parameters.put("ROSpecParameter", this.getROSpecParameter(id));
        return parameters;
    }

    protected Map getC1G2ReadParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, int wordCount) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("OpSpecID", new Integer(OpSpecId));
        parameters.put("AccessPassword", new Integer(accessPassword));
        parameters.put("MB", new Integer(memoryBank));
        parameters.put("WordPointer", new Integer(wordPointer));
        parameters.put("WordCount", new Integer(wordCount));
        Hashtable<String, Hashtable<String, Integer>> result = new Hashtable<String, Hashtable<String, Integer>>();
        result.put("C1G2ReadParameter", parameters);
        return result;
    }

    protected Map getC1G2TagSpecParameter() {
        Hashtable<String, Map> parameters = new Hashtable<String, Map>();
        parameters.put("C1G2TargetTagParameter", this.getC1G2TargetTagParameter(1, true, 32, "00,00,00,00,00,00,00,00,00,00,00,00", "00,00,00,00,00,00,00,00,00,00,00,00"));
        Hashtable<String, Hashtable<String, Map>> result = new Hashtable<String, Hashtable<String, Map>>();
        result.put("C1G2TagSpecParameter", parameters);
        return result;
    }

    protected Map getC1G2TargetTagParameter(int memoryBank, boolean match, int pointer, String tagMask, String tagData) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("MB", new Integer(memoryBank));
        parameters.put("Match", match ? Boolean.TRUE : Boolean.FALSE);
        parameters.put("Pointer", new Integer(pointer));
        parameters.put("TagMask", EpcglobalLlrpDeviceTest.str2byteArray(tagMask));
        parameters.put("TagData", EpcglobalLlrpDeviceTest.str2byteArray(tagData));
        return parameters;
    }

    protected Map getC1G2WriteParameter(int OpSpecId, int accessPassword, int memoryBank, int wordPointer, int wordCount, String writeData) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("OpSpecID", new Integer(OpSpecId));
        parameters.put("AccessPassword", new Integer(accessPassword));
        parameters.put("MB", new Integer(memoryBank));
        parameters.put("WordPointer", new Integer(wordPointer));
        return parameters;
    }

    public DeviceService getDefaultDevice() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return new EpcglobalLlrpDevice();
    }

    protected Map getDelete_Enable_DisableAccessSpecCommandParameters(int accessSpecId) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("AccessSpecID", new Integer(accessSpecId));
        return parameters;
    }

    protected Map getEnableGPIStateParameter() {
        Hashtable<String, Serializable> parameters = new Hashtable<String, Serializable>();
        parameters.put("ResetToFactoryDefault", Boolean.FALSE);
        ArrayList<Map> gpis = new ArrayList<Map>();
        gpis.add(this.getGPIPortCurrentStateParameter(1, true));
        parameters.put("GPIPortCurrentStateParameter", gpis);
        return parameters;
    }

    protected Map getEnable_Stop_DeleteROSpecParameters(int id) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("ROSpecID", new Integer(id));
        return parameters;
    }

    protected Map getGPIPortCurrentStateParameter(int gpiPortNum, boolean enable) {
        Hashtable<String, Constable> parameters = new Hashtable<String, Constable>();
        parameters.put("GPIPortNum", new Integer(gpiPortNum));
        parameters.put("Config", enable ? Boolean.TRUE : Boolean.FALSE);
        parameters.put("State", new Integer(0));
        return parameters;
    }

    protected Map getGPITriggerValueParameter(int gpiPortNum, int gpiEvent, int timeout) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("GPIPortNum", new Integer(gpiPortNum));
        parameters.put("GPIEvent", new Integer(gpiEvent));
        parameters.put("Timeout", new Integer(timeout));
        return parameters;
    }

    protected Map getGetGPIStateParameter(int gpiPortNum) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("GPIPortNum", new Integer(gpiPortNum));
        return parameters;
    }

    protected Map getInventoryParameterSpecParameter(int specId, int protocolId) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("InventoryParameterSpecID", new Integer(specId));
        parameters.put("ProtocolID", new Integer(protocolId));
        return parameters;
    }

    protected Map getParameterSetReaderConfigGPOWriteData(int portNum, int data) {
        Hashtable parameters = new Hashtable();
        ArrayList GPOWriteData0_N = new ArrayList();
        Hashtable<String, Integer> GPOWriteData = new Hashtable<String, Integer>();
        GPOWriteData.put("GPOPortNumber", new Integer(portNum));
        GPOWriteData.put("GPOData", new Integer(data));
        GPOWriteData0_N.add(GPOWriteData);
        parameters.put("GPOWriteDataParameter", GPOWriteData0_N);
        return parameters;
    }

    protected Map getROBoundarySpecParameter() {
        Hashtable<String, Map> parameters = new Hashtable<String, Map>();
        parameters.put("ROSpecStartTriggerParameter", this.getROSpecStartTriggerParameter(3));
        parameters.put("ROSpecStopTriggerParameter", this.getROSpecStopTriggerParameter(2, 0));
        return parameters;
    }

    protected Map getROReportSpecParameter(int trigger, int tagNum) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("ROReportTrigger", new Integer(trigger));
        parameters.put("ROReportSpec_N", new Integer(tagNum));
        parameters.put("TagReportContentSelectorParameter", this.getTagReportContentSelectorParameter());
        return parameters;
    }

    protected Map getROSpecIDParameter(int id) {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("ROSpecID", new Integer(id));
        return parameters;
    }

    protected Map getROSpecParameter(int id) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("ROSpecID", new Integer(id));
        parameters.put("Priority", new Integer(0));
        parameters.put("ROSpec_CurrentState", new Integer(0));
        parameters.put("ROBoundarySpecParameter", this.getROBoundarySpecParameter());
        parameters.put("SpecParameterChoice", this.getAISpecParameter(new int[]{1}));
        parameters.put("ROReportSpecParameter", this.getROReportSpecParameter(1, 1));
        return parameters;
    }

    protected Map getROSpecStartTriggerParameter(int type) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("ROSpecStartTriggerType", new Integer(type));
        switch (type) {
            case 0: {
                break;
            }
            case 3: {
                parameters.put("GPITriggerValueParameter", this.getGPITriggerValueParameter(1, 1, 0));
            }
        }
        return parameters;
    }

    protected Map getROSpecStopTriggerParameter(int type, int duration) {
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("ROSpecStopTriggerType", new Integer(type));
        parameters.put("DurationTriggerValue", new Integer(duration));
        if (type == 2) {
            parameters.put("GPITriggerValueParameter", this.getGPITriggerValueParameter(1, 0, 0));
        }
        return parameters;
    }

    protected Map getTagReportContentSelectorParameter() {
        Hashtable<String, Integer> parameters = new Hashtable<String, Integer>();
        parameters.put("EnableROSpecID", new Integer(1));
        parameters.put("EnableSpecIndex", new Integer(1));
        parameters.put("EnableInventoryParameterSpecID", new Integer(1));
        parameters.put("EnableAntennaID", new Integer(1));
        parameters.put("EnableChannelIndex", new Integer(1));
        parameters.put("EnablePeakRSSI", new Integer(1));
        parameters.put("EnableFirstSeenTimestamp", new Integer(1));
        parameters.put("EnableLastSeenTimestamp", new Integer(1));
        parameters.put("EnableTagSeenCount", new Integer(1));
        parameters.put("EnableAccessSpecID", new Integer(1));
        return parameters;
    }

    public void runTests() {
        CommandService addROSpec;
        CommandService deleteROSpec;
        CommandService getGPI1State;
        CommandService enableGPI1 = this.getDevice().getCommand("SetReaderConfig_GPIPortCurrentState");
        if (enableGPI1 != null) {
            Map parameter = this.getEnableGPIStateParameter();
            enableGPI1.execute((Object)parameter);
        }
        if ((getGPI1State = this.getDevice().getCommand("GetReaderConfig_GPIPortCurrentState")) != null) {
            Map parameter = this.getGetGPIStateParameter(1);
            getGPI1State.execute((Object)parameter);
        }
        if ((deleteROSpec = this.getDevice().getCommand("DeleteRospec")) != null) {
            deleteROSpec.execute((Object)this.getROSpecIDParameter(1));
        }
        if ((addROSpec = this.getDevice().getCommand("AddRospec")) != null) {
            addROSpec.execute((Object)this.getAddROSpecCommandParameters(1));
        }
        this.getDevice().getCommand("GetRospecs").execute();
    }

    public void setup() {
        super.setup();
        this.setPriority(this.getInt("epcgloballlrpdevicetest.priority", 3));
        this.setTestCount(this.getInt("epcgloballlrpdevicetest.testcount", 2));
        this.setTestDelay(this.getLong("epcgloballlrpdevicetest.testdelay", 0L));
        this.setTestExecute(this.getBoolean("epcgloballlrpdevicetest.testexecute", false));
        this.setTestExecuteRead(this.getBoolean("epcgloballlrpdevicetest.testexecuteread", true));
        this.setTestExecuteWrite(this.getBoolean("epcgloballlrpdevicetest.testexecutewrite", false));
        this.setTestRead(this.getBoolean("epcgloballlrpdevicetest.testread", false));
        this.setTestTrigger(this.getBoolean("epcgloballlrpdevicetest.testtrigger", false));
        this.setTotalTestTime(this.getLong("epcgloballlrpdevicetest.totaltesttime", 60000L));
    }
}

