/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.command.service.MultiplexCommandListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;

public class Commands
extends Command
implements MultiplexCommandListener {
    private CommandService[] commands;

    public Commands(String key, CommandService[] commands) {
        super(key);
        this.setCommands(commands);
    }

    public void commandExecuted(CommandService source, Object timestamp, ChannelService channel, Object data) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            try {
                if (channel == null || commandListener instanceof MultiplexCommandListener) {
                    ((MultiplexCommandListener)commandListener).commandExecuted((CommandService)this, timestamp, channel, data);
                } else {
                    commandListener.commandExecuted((CommandService)this, timestamp, data);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        this.commandExecuted(source, timestamp, null, data);
    }

    public void execute(ChannelService channel) {
        int length = this.commands.length;
        int i = 0;
        while (i < length) {
            this.commands[i].execute(channel);
            ++i;
        }
    }

    public void execute(ChannelService channel, Object data) {
        int length = this.commands.length;
        int i = 0;
        while (i < length) {
            this.commands[i].execute(channel, data);
            ++i;
        }
    }

    public CommandService[] getCommands() {
        return this.commands;
    }

    protected void setCommands(CommandService[] commands) {
        this.commands = commands;
    }
}

