/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.barcode.reader.transport;

import org.eclipse.soda.dk.barcode.reader.transport.service.BarcodeReaderTransportService;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.serial.connection.SerialConnection;
import org.eclipse.soda.dk.serial.connection.service.SerialConnectionService;
import org.eclipse.soda.dk.tcpip.connection.TcpipConnection;
import org.eclipse.soda.dk.tcpip.connection.service.TcpipConnectionService;
import org.eclipse.soda.dk.transport.ConnectionTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class BarcodeReaderTransport
extends ConnectionTransport
implements TransportService,
BarcodeReaderTransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.barcode.reader.transport.BarcodeReaderTransport";
    private byte[] bufferedMessage = new byte[0];
    private byte beginChar = (byte)-1;
    private byte delimiterChar = (byte)-1;
    private byte endChar = (byte)-1;
    private byte[] messageBegin = BarcodeReaderTransportService.MESSAGE_BEGIN_DEFAULT;
    private byte[] messageEnd = BarcodeReaderTransportService.MESSAGE_END_DEFAULT;
    private int messageMinimumSize = 1;

    protected void addToBufferedMessage(byte oneChar) {
        byte[] newMessage = new byte[this.bufferedMessage.length + 1];
        System.arraycopy(this.bufferedMessage, 0, newMessage, 0, this.bufferedMessage.length);
        newMessage[this.bufferedMessage.length] = oneChar;
        this.bufferedMessage = newMessage;
    }

    protected void addToBufferedMessage(byte[] message, int index, int length) {
        byte[] newMessage = new byte[this.bufferedMessage.length + length];
        System.arraycopy(this.bufferedMessage, 0, newMessage, 0, this.bufferedMessage.length);
        System.arraycopy(message, index, newMessage, this.bufferedMessage.length, length);
        this.bufferedMessage = newMessage;
    }

    public int beginIndex(byte[] bytes, int length, byte[] begin, int index) {
        int indexCurrent = index;
        while (indexCurrent < length - begin.length) {
            if (this.same(bytes, length, begin, indexCurrent)) {
                return indexCurrent;
            }
            ++indexCurrent;
        }
        return indexCurrent;
    }

    protected void clearBufferedMessage() {
        this.bufferedMessage = new byte[0];
    }

    public byte getBeginChar() {
        return this.beginChar;
    }

    protected byte[] getBufferedMessage() {
        return this.bufferedMessage;
    }

    public ConnectionService getDefaultConnection() {
        String type = this.getString("barcodereadertransport.connection", "serial");
        if (type.equals("tcpip")) {
            return this.getDefaultTcpipConnection();
        }
        return this.getDefaultSerialConnection();
    }

    public SerialConnectionService getDefaultSerialConnection() {
        return new SerialConnection(this.getInt("barcodereadertransport.comport", 1), this.getInt("barcodereadertransport.baudrate", 9600), this.getInt("barcodereadertransport.databits", 8), this.getInt("barcodereadertransport.parity", 0), this.getInt("barcodereadertransport.stopbits", 1), this.getInt("barcodereadertransport.hardwareflowcontrol", 0), this.getInt("barcodereadertransport.softwareflowcontrol", 0), this.getLong("barcodereadertransport.readtotaltimeout", 1000L), this.getLong("barcodereadertransport.readintervaltimeout", 50L), this.getLong("barcodereadertransport.writetotaltimeout", 100L));
    }

    public TcpipConnectionService getDefaultTcpipConnection() {
        return new TcpipConnection(this.getString("barcodereadertransport.localhost", "0.0.0.0"), this.getInt("barcodereadertransport.localport", -1), this.getString("barcodereadertransport.remotehost", "localhost"), this.getInt("barcodereadertransport.remoteport", 8901), this.getInt("barcodereadertransport.readtimeout", 1000), this.getInt("barcodereadertransport.readsize", -1), this.getInt("barcodereadertransport.writesize", -1), this.getInt("barcodereadertransport.linger", -1));
    }

    public byte getDelimiterChar() {
        return this.delimiterChar;
    }

    public byte getEndChar() {
        return this.endChar;
    }

    public byte[] getMessageBegin() {
        return this.messageBegin;
    }

    public byte[] getMessageEnd() {
        return this.messageEnd;
    }

    public int getMessageMinimumSize() {
        return this.messageMinimumSize;
    }

    protected void processBarcode(byte[] bytes, int beginIndex, int length) throws Exception {
        byte beginChar = this.getBeginChar();
        byte endChar = this.getEndChar();
        int index = beginIndex;
        byte[] messageBytes = null;
        if (endChar == -1) {
            if (beginChar == -1) {
                messageBytes = new byte[length];
                System.arraycopy(bytes, index, messageBytes, 0, length);
            } else if (bytes.length > 0 && beginChar == bytes[beginIndex]) {
                messageBytes = new byte[length - 1];
                System.arraycopy(bytes, ++index, messageBytes, 0, length - 1);
            }
        } else {
            int messageLength = length;
            if (beginChar != -1 && bytes.length > 0 && beginChar == bytes[beginIndex]) {
                this.clearBufferedMessage();
                ++index;
                --messageLength;
            }
            if (bytes.length >= length) {
                if (endChar == bytes[beginIndex + length - 1]) {
                    this.addToBufferedMessage(bytes, index, messageLength - 1);
                    messageBytes = this.getBufferedMessage();
                    this.clearBufferedMessage();
                } else {
                    this.addToBufferedMessage(bytes, index, messageLength);
                }
            }
        }
        if (messageBytes != null && messageBytes.length > 0) {
            this.sendBarcode(messageBytes, 0, messageBytes.length);
        }
    }

    protected int processInput(byte[] bytes, int length) throws Exception {
        if (this.isLogging(4)) {
            String messageStr = Nls.formatAsciiBytes((byte[])bytes, (int)0, (int)length);
            this.log(4, "Processing barcode input: " + messageStr);
        }
        byte beginChar = this.getBeginChar();
        byte endChar = this.getEndChar();
        byte delimitChar = this.getDelimiterChar();
        if (beginChar == -1 && endChar == -1 && delimitChar == -1) {
            this.sendBarcode(bytes, 0, length);
            return length;
        }
        byte separateChar = delimitChar != -1 ? delimitChar : (endChar != -1 ? endChar : beginChar);
        int cursor = 0;
        int messageLength = length < bytes.length ? length : bytes.length;
        int index = 0;
        while (index < messageLength) {
            if (bytes[index] == separateChar || bytes[index] == endChar || index == messageLength - 1) {
                int segmentLength;
                int n = segmentLength = bytes[index] == separateChar && (separateChar == delimitChar || separateChar == beginChar) ? index - cursor : index - cursor + 1;
                if (segmentLength > 0) {
                    this.processBarcode(bytes, cursor, segmentLength);
                }
                cursor = separateChar != beginChar ? index + 1 : index;
            }
            ++index;
        }
        return length;
    }

    public boolean same(byte[] bytes, int length, byte[] begin, int index) {
        int i = 0;
        while (i < begin.length) {
            if (bytes[index + i] != begin[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void sendBarcode(byte[] bytes, int index, int length) throws Exception {
        byte[] messageBytes = null;
        if (index == 0 && length == bytes.length) {
            messageBytes = bytes;
        } else {
            messageBytes = new byte[length];
            System.arraycopy(bytes, index, messageBytes, 0, length);
        }
        if (messageBytes != null && messageBytes.length > 0) {
            if (this.isLogging(4)) {
                String messageStr = Nls.formatAsciiBytes((byte[])messageBytes, (int)0, (int)messageBytes.length);
                this.log(4, "Sending barcode: " + messageStr);
            }
            Message message = new Message(messageBytes);
            this.fireMessageReceived(BarcodeReaderTransport.getCurrentTimestamp(), (MessageService)message);
        }
    }

    public void setBeginChar(byte beginChar) {
        this.beginChar = beginChar;
    }

    public void setDelimiterChar(byte delimiterChar) {
        this.delimiterChar = delimiterChar;
    }

    public void setEndChar(byte endChar) {
        this.endChar = endChar;
    }

    public void setMessageBegin(byte[] messageBegin) {
        this.messageBegin = messageBegin;
    }

    public void setMessageEnd(byte[] messageEnd) {
        this.messageEnd = messageEnd;
    }

    public void setMessageMinimumSize(int messageMinimumSize) {
        this.messageMinimumSize = messageMinimumSize;
    }

    public void setup() {
        super.setup();
        this.setMessageMinimumSize(this.getInt("barcodereadertransport.messageminimumsize", this.getMessageMinimumSize()));
        this.setMessageBegin(this.getByteArray("barcodereadertransport.messagebegin", this.getMessageBegin()));
        this.setMessageEnd(this.getByteArray("barcodereadertransport.messageend", this.getMessageEnd()));
        this.setBeginChar(this.getByte("barcodereadertransport.beginchar", this.getBeginChar()));
        this.setEndChar(this.getByte("barcodereadertransport.endchar", this.getEndChar()));
        this.setDelimiterChar(this.getByte("barcodereadertransport.delimiterchar", this.getDelimiterChar()));
        this.setRetryTime(this.getLong("barcodereadertransport.retrytime", this.getRetryTime()));
        this.setPriority(this.getInt("barcodereadertransport.priority", this.getPriority()));
        this.setNotificationPriority(this.getInt("barcodereadertransport.notificationpriority", this.getNotificationPriority()));
        this.setTransmitRetries(this.getInt("barcodereadertransport.transmitretries", this.getTransmitRetries()));
        this.setNoActivityTimeout(this.getLong("barcodereadertransport.noactivitytimeout", this.getNoActivityTimeout()));
    }
}

