/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.arcom.io.gpio.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.arcom.io.gpio.profile.service.ArcomIoGpioProfileService;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.gpio.profile.GpioProfile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class ArcomIoGpioProfile
extends GpioProfile
implements ProfileService,
ArcomIoGpioProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.arcom.io.gpio.profile.ArcomIoGpioProfile";
    protected CommandService arcomIoDeviceServiceGetInputRequest;
    protected CommandService arcomIoDeviceServiceSetAllOutputs;
    protected SignalService arcomIoDeviceServiceInputReport;
    private AdapterService adapter;
    protected static final byte ALL_OFF_OUTPUT = 0;
    protected static final byte ALL_ON_OUTPUT = 15;
    public static final int OUTPUT_COUNT = 8;
    public static final int INPUT_COUNT = 8;

    public ArcomIoGpioProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null) {
            if (this.arcomIoDeviceServiceGetInputRequest != null) {
                this.arcomIoDeviceServiceGetInputRequest.removeCommandListener((CommandListener)this);
            }
            if (this.arcomIoDeviceServiceSetAllOutputs != null) {
                this.arcomIoDeviceServiceSetAllOutputs.removeCommandListener((CommandListener)this);
            }
            if (this.arcomIoDeviceServiceInputReport != null) {
                this.arcomIoDeviceServiceInputReport.removeSignalListener((SignalListener)this);
            }
        }
        if (device != null) {
            this.arcomIoDeviceServiceGetInputRequest = device.getCommand("GetInputRequest");
            this.initializeCommand(this.arcomIoDeviceServiceGetInputRequest);
            this.arcomIoDeviceServiceSetAllOutputs = device.getCommand("SetAllOutputs");
            this.initializeCommand(this.arcomIoDeviceServiceSetAllOutputs);
            this.arcomIoDeviceServiceInputReport = device.getSignal("InputReport");
            this.initializeSignal(this.arcomIoDeviceServiceInputReport);
        }
        super.setDevice(device);
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (this.arcomIoDeviceServiceInputReport == source) {
            this.handleArcomIoDeviceServiceInputReport(source, timestamp, data);
            return;
        }
        super.signalOccurred(source, timestamp, data);
    }

    public String getDefaultKey() {
        return "ArcomIoGpioProfile";
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)ArcomIoGpioProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.arcom.io.device.ArcomIoDevice");
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    private void initialize() {
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("arcomiogpioprofile.notificationpriority", this.getNotificationPriority()));
    }

    public AdapterService getAdapter() {
        return this.adapter;
    }

    public void setAdapter(AdapterService adapter) {
        this.adapter = adapter;
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    public void activate() {
        if (this.arcomIoDeviceServiceGetInputRequest != null) {
            this.arcomIoDeviceServiceGetInputRequest.execute();
        }
        super.activate();
    }

    protected Map createMapFromByte(byte data, String[] keys, int count) {
        byte value = data;
        Hashtable<String, Boolean> pins = new Hashtable<String, Boolean>(keys.length + 7);
        int i = 0;
        while (i < count) {
            int isOn = value & 1;
            pins.put(keys[i + 1], isOn == 1 ? Boolean.TRUE : Boolean.FALSE);
            value = (byte)(value >> 1);
            ++i;
        }
        return pins;
    }

    protected byte createOutputByteFromMap(Map states, String[] keys, int count) {
        byte allPinsState = 0;
        int i = 1;
        while (i <= count) {
            boolean out;
            Object pinState = states.get(keys[i]);
            boolean bl = out = pinState == null ? false : this.getBooleanValue(pinState);
            if (out) {
                allPinsState = (byte)(allPinsState | 1 << i - 1);
            }
            ++i;
        }
        return allPinsState;
    }

    protected long getInputCountValue() {
        return 8L;
    }

    protected long getOutputCountValue() {
        return 8L;
    }

    private void handleArcomIoDeviceServiceInputReport(SignalService source, Object timestamp, Object data) {
        if (!this.isStarted()) {
            return;
        }
        if (!(data instanceof Number)) {
            return;
        }
        Map newInputState = this.createMapFromByte(((Number)data).byteValue(), INPUT_NAMES, 8);
        this.input.setValue((Object)newInputState, timestamp != null ? timestamp : ArcomIoGpioProfile.getCurrentTimestamp());
    }

    protected void setOutputPins(byte value) {
        if (this.isStarted() && this.getDevice() != null && this.getDevice().isStarted()) {
            this.arcomIoDeviceServiceSetAllOutputs.execute((Object)new Byte(value));
        }
    }

    protected void turnOffAllOutputs() {
        this.setOutputPins((byte)0);
    }

    protected void turnOnAllOutputs() {
        this.setOutputPins((byte)15);
    }

    protected void updateOutputs(Map fullState, Map individualRequest) {
        byte output = this.createOutputByteFromMap(fullState, OUTPUT_NAMES, 8);
        this.setOutputPins(output);
    }
}

