/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.transport.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.model.ConfigurationModel;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.model.xml.XmlModel;
import org.eclipse.soda.devicekit.ui.operation.DeviceKitGenerateOperation;
import org.eclipse.soda.devicekit.ui.transport.wizard.TransportMessages;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;

public class TransportOperation
extends DeviceKitGenerateOperation
implements IWorkspaceRunnable {
    private String custom;
    private IWizardMessages messages = TransportMessages.getInstance();

    public TransportOperation(Map variables) {
        super(variables);
        this.custom = this.messages.getString("custom");
    }

    protected void addConnectionDkml(IXmlElement element, String connection) {
        if (this.custom.equals(connection)) {
            this.handleCustomConnection(element);
        } else {
            String type = connection;
            ConfigurationModel connectionModel = ConfigurationModel.getConnection((String)type);
            if (connectionModel != null) {
                this.handleConnectionModel(element, connectionModel);
            }
        }
    }

    protected void addDkmlBody(IXmlElement element, int type) {
        switch (type) {
            case 0: {
                this.addTransportDkmlBody(element);
                break;
            }
            case 1: {
                this.addTransportTestDkmlBody(element);
            }
        }
    }

    protected void addTransportDkmlBody(IXmlElement dkmlElement) {
        String connection;
        String transmitRetries;
        String retryTime;
        IXmlElement element = dkmlElement.add("transport");
        boolean abstractState = this.createCommonTop(element, true);
        String responseTimeout = (String)this.getVariables().get("response.timeout");
        if (responseTimeout != null && responseTimeout.trim().length() > 0) {
            IXmlElement rt = element.add("responsetimeout");
            rt.setData(responseTimeout.trim());
        }
        if ((retryTime = (String)this.getVariables().get("retry.time")) != null && retryTime.trim().length() > 0) {
            IXmlElement rt = element.add("retrytime");
            rt.setData(retryTime.trim());
        }
        if ((transmitRetries = (String)this.getVariables().get("transmit.retries")) != null && transmitRetries.trim().length() > 0) {
            IXmlElement rt = element.add("transmitretries");
            rt.setData(transmitRetries.trim());
        }
        if ((connection = (String)this.getVariables().get("connection")) != null && connection.trim().length() > 0) {
            this.addConnectionDkml(element, connection);
        }
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected void addTransportTestDkmlBody(IXmlElement dkmlElement) {
        IXmlElement test = dkmlElement.add("transporttest");
        String name = this.getName();
        this.addCommonTestTop(test);
        IXmlElement transport = test.add("transport");
        StringBuffer refBuffer = new StringBuffer(128);
        refBuffer.append(this.getProjectName());
        refBuffer.append("/dk/transport.xml#");
        refBuffer.append(name);
        transport.addAttribute("idref", refBuffer.toString());
        if (this.doGenerateTestcase()) {
            test.add("testcase");
        }
        this.addCommonBundle(test);
    }

    protected IFile createDkmlFile(int type, IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFile iFile;
        InputStream stream = null;
        try {
            String name = "transport.xml";
            if (type == 1) {
                name = "transport_test.xml";
            }
            XmlModel model = new XmlModel(name);
            this.populateTemplateModel(model, type);
            String contents = model.getContents();
            stream = new BufferedInputStream(new ByteArrayInputStream(contents.getBytes()));
            IFile file = folder.getFile(name);
            file.create(stream, true, monitor);
            iFile = file;
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                stream.close();
                stream = null;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
            stream = null;
        }
        catch (IOException iOException) {}
        return iFile;
    }

    protected String getName() {
        String name = (String)this.getVariables().get("name");
        name = String.valueOf(name) + "Transport";
        return name;
    }

    protected String[] getRequiredClasses() {
        return new String[0];
    }

    protected void handleConnectionModel(IXmlElement element, ConfigurationModel connectionModel) {
        String type = connectionModel.getType();
        String description = connectionModel.getDescription();
        IXmlElement connectionElement = element.add(type);
        if (description != null && description.length() > 0) {
            IXmlElement descriptionElement = connectionElement.add("description");
            descriptionElement.setData(description);
        }
        ConfigurationField[] fields = connectionModel.getConfigurationFields();
        int i = 0;
        while (i < fields.length) {
            boolean needed;
            ConfigurationField field = fields[i];
            String name = field.getConfigurationNameQualified().toLowerCase();
            String key = "connection." + name;
            String value = (String)this.getVariables().get(key);
            String buttonKey = String.valueOf(key) + ".checkbox";
            String buttonValue = (String)this.getVariables().get(buttonKey);
            boolean bl = needed = buttonValue != null ? "true".equals(buttonValue) : false;
            if (needed && value != null && value.length() > 0) {
                String tagName = field.getConfigurationName().toLowerCase();
                IXmlElement childElement = connectionElement.add(tagName);
                childElement.setData(value);
            }
            ++i;
        }
    }

    private void handleCustomConnection(IXmlElement element) {
        IXmlElement connectionElement = element.add("connection");
        this.createMultiplex(connectionElement);
        String implementation = (String)this.getVariables().get("custom.connection.implementation");
        connectionElement.addAttribute("implementation", implementation);
    }
}

