/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.preference.DeviceKitAdvancedPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DevicePreferencePage
extends DeviceKitAdvancedPreferencePage
implements IWorkbenchPreferencePage {
    private int serviceListSelection;
    private int implListSelection;
    private List serviceList;
    private List implList;
    private Button addService;
    private Button removeService;
    private Button addImpl;
    private Button removeImpl;
    private SelectionListener addServiceListener;
    private SelectionListener removeServiceListener;
    private SelectionListener addImplListener;
    private SelectionListener removeImplListener;
    private SelectionListener serviceListListener;
    private SelectionListener implListListener;

    public DevicePreferencePage() {
    }

    public DevicePreferencePage(String title) {
        super(title);
    }

    public DevicePreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected void addImpl() {
        try {
            List list;
            String newEntry = this.openTypeDialog("Select Transport Implementation", "Select the transport implementation", 5, "*Transport");
            if (newEntry != null && (list = this.getImplList()).indexOf(newEntry) == -1) {
                list.add(newEntry);
            }
        }
        catch (Exception exception) {}
    }

    protected void addImplListeners() {
        List implList = this.getImplList();
        Object listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DevicePreferencePage.this.implListSelected();
            }
        };
        implList.addSelectionListener(listener);
        this.setImplListListener((SelectionListener)listener);
        Button addImpl = this.getAddImplButton();
        listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DevicePreferencePage.this.addImpl();
            }
        };
        addImpl.addSelectionListener(listener);
        this.setAddImplListener((SelectionListener)listener);
        Button removeImpl = this.getRemoveImplButton();
        listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DevicePreferencePage.this.removeImpl();
            }
        };
        removeImpl.addSelectionListener(listener);
        this.setRemoveImplListener((SelectionListener)listener);
    }

    protected void addListeners() {
        super.addListeners();
        this.addServiceListeners();
        this.addImplListeners();
    }

    protected void addService() {
        try {
            List list;
            String newEntry = this.openTypeDialog("Select Transport Service", "Select the transport service", 6, "*TransportService");
            if (newEntry != null && (list = this.getServiceList()).indexOf(newEntry) == -1) {
                list.add(newEntry);
            }
        }
        catch (Exception exception) {}
    }

    private void addServiceListeners() {
        List serviceList = this.getServiceList();
        Object listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DevicePreferencePage.this.serviceListSelected();
            }
        };
        serviceList.addSelectionListener(listener);
        this.setServiceListListener((SelectionListener)listener);
        Button addService = this.getAddServiceButton();
        listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DevicePreferencePage.this.addService();
            }
        };
        addService.addSelectionListener(listener);
        this.setAddServiceListener((SelectionListener)listener);
        Button removeService = this.getRemoveServiceButton();
        listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DevicePreferencePage.this.removeService();
            }
        };
        removeService.addSelectionListener(listener);
        this.setRemoveServiceListener((SelectionListener)listener);
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.makeServiceGroup(composite);
        this.makeImplGroup(composite);
        this.addListeners();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    protected Button getAddImplButton() {
        return this.addImpl;
    }

    protected SelectionListener getAddImplListener() {
        return this.addImplListener;
    }

    protected Button getAddServiceButton() {
        return this.addService;
    }

    protected SelectionListener getAddServiceListener() {
        return this.addServiceListener;
    }

    protected List getImplList() {
        return this.implList;
    }

    protected SelectionListener getImplListListener() {
        return this.implListListener;
    }

    public int getImplListSelection() {
        return this.implListSelection;
    }

    public String getImplsKey() {
        return "transport.implementation";
    }

    protected int getListHeightHint(List list) {
        return list.getItemHeight() << 2;
    }

    protected Button getRemoveImplButton() {
        return this.removeImpl;
    }

    protected SelectionListener getRemoveImplListener() {
        return this.removeImplListener;
    }

    protected Button getRemoveServiceButton() {
        return this.removeService;
    }

    protected SelectionListener getRemoveServiceListener() {
        return this.removeServiceListener;
    }

    protected List getServiceList() {
        return this.serviceList;
    }

    protected SelectionListener getServiceListListener() {
        return this.serviceListListener;
    }

    public int getServiceListSelection() {
        return this.serviceListSelection;
    }

    public String getServicesKey() {
        return "transport.service";
    }

    protected String[] getStoredImplListItems() {
        String[] items;
        String impls = this.getString(this.getImplsKey());
        if (impls != null && !impls.equals("null") && (items = DeviceKitPreferenceInitializer.parsePrefArray((String)impls)) != null) {
            return items;
        }
        return new String[0];
    }

    protected String[] getStoredServiceListItems() {
        String[] items;
        String services = this.getString(this.getServicesKey());
        if (services != null && !services.equals("null") && (items = DeviceKitPreferenceInitializer.parsePrefArray((String)services)) != null) {
            return items;
        }
        return new String[0];
    }

    public String getSuperClassFilter() {
        return "*Device";
    }

    public String getSuperClassKey() {
        return "device.superclass";
    }

    public String getSuperClassText() {
        return "Device Super Classes";
    }

    protected String getTransportImplText() {
        return "Transport Implementations";
    }

    protected String getTransportServiceText() {
        return "Transport Services";
    }

    protected void implListSelected() {
        List list = this.getImplList();
        this.setImplListSelection(list.getSelectionIndex());
    }

    public void init(IWorkbench workbench) {
    }

    private void makeImplGroup(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(this.getTransportImplText());
        GridData data = new GridData(4);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite scComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        scComposite.setLayout((Layout)layout);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        scComposite.setLayoutData((Object)data);
        List list = new List(scComposite, 2816);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        data.heightHint = this.getListHeightHint(list);
        data.widthHint = this.getListWidthHint();
        list.setLayoutData((Object)data);
        String[] items = this.getStoredImplListItems();
        list.setItems(items);
        this.setImplList(list);
        Composite buttonComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        Button add = new Button(buttonComposite, 0x1000008);
        add.setText("Add");
        data = new GridData(2);
        data.horizontalSpan = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, add.computeSize((int)-1, (int)-1, (boolean)true).x);
        add.setLayoutData((Object)data);
        this.setAddImplButton(add);
        Button remove = new Button(buttonComposite, 0x1000008);
        remove.setText("Remove");
        data = new GridData(2);
        data.horizontalSpan = 1;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, remove.computeSize((int)-1, (int)-1, (boolean)true).x);
        remove.setLayoutData((Object)data);
        this.setRemoveImplButton(remove);
    }

    private void makeServiceGroup(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(this.getTransportServiceText());
        GridData data = new GridData(4);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite scComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        scComposite.setLayout((Layout)layout);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        scComposite.setLayoutData((Object)data);
        List list = new List(scComposite, 2816);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        data.heightHint = this.getListHeightHint(list);
        data.widthHint = this.getListWidthHint();
        list.setLayoutData((Object)data);
        String[] items = this.getStoredServiceListItems();
        list.setItems(items);
        this.setServiceList(list);
        Composite buttonComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        Button add = new Button(buttonComposite, 0x1000008);
        add.setText("Add");
        data = new GridData(2);
        data.horizontalSpan = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, add.computeSize((int)-1, (int)-1, (boolean)true).x);
        add.setLayoutData((Object)data);
        this.setAddServiceButton(add);
        Button remove = new Button(buttonComposite, 0x1000008);
        remove.setText("Remove");
        data = new GridData(2);
        data.horizontalSpan = 1;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, remove.computeSize((int)-1, (int)-1, (boolean)true).x);
        remove.setLayoutData((Object)data);
        this.setRemoveServiceButton(remove);
    }

    protected void performDefaults() {
        super.performDefaults();
        String[] serviceDefaults = DeviceKitPreferenceInitializer.getDefault((String)this.getServicesKey());
        List services = this.getServiceList();
        services.setItems(serviceDefaults);
        this.setServiceListSelection(-1);
        String[] implDefaults = DeviceKitPreferenceInitializer.getDefault((String)this.getImplsKey());
        List impls = this.getImplList();
        impls.setItems(implDefaults);
        this.setImplListSelection(-1);
    }

    protected void removeImpl() {
        List list;
        int selection = this.getImplListSelection();
        if (selection != -1 && (list = this.getImplList()).getItemCount() > 0) {
            list.remove(selection);
        }
    }

    protected void removeImplListeners() {
        List implList = this.getImplList();
        SelectionListener implListener = this.getImplListListener();
        implList.removeSelectionListener(implListener);
        Button addImpl = this.getAddImplButton();
        SelectionListener addImplListener = this.getAddImplListener();
        addImpl.removeSelectionListener(addImplListener);
        Button removeImpl = this.getRemoveImplButton();
        SelectionListener removeImplListener = this.getRemoveImplListener();
        removeImpl.removeSelectionListener(removeImplListener);
    }

    protected void removeListeners() {
        this.removeServiceListeners();
        this.removeImplListeners();
        super.removeListeners();
    }

    protected void removeService() {
        List list;
        int selection = this.getServiceListSelection();
        if (selection != -1 && (list = this.getServiceList()).getItemCount() > 0) {
            list.remove(selection);
        }
    }

    protected void removeServiceListeners() {
        List serviceList = this.getServiceList();
        SelectionListener serviceListener = this.getServiceListListener();
        serviceList.removeSelectionListener(serviceListener);
        Button addService = this.getAddServiceButton();
        SelectionListener addServiceListener = this.getAddServiceListener();
        addService.removeSelectionListener(addServiceListener);
        Button removeService = this.getRemoveServiceButton();
        SelectionListener removeServiceListener = this.getRemoveServiceListener();
        removeService.removeSelectionListener(removeServiceListener);
    }

    protected void serviceListSelected() {
        List list = this.getServiceList();
        this.setServiceListSelection(list.getSelectionIndex());
    }

    private void setAddImplButton(Button add) {
        this.addImpl = add;
    }

    private void setAddImplListener(SelectionListener addImplListener) {
        this.addImplListener = addImplListener;
    }

    private void setAddServiceButton(Button add) {
        this.addService = add;
    }

    private void setAddServiceListener(SelectionListener addServiceListener) {
        this.addServiceListener = addServiceListener;
    }

    private void setImplList(List list) {
        this.implList = list;
    }

    private void setImplListListener(SelectionListener implListListener) {
        this.implListListener = implListListener;
    }

    public void setImplListSelection(int implListSelection) {
        this.implListSelection = implListSelection;
    }

    private void setRemoveImplButton(Button remove) {
        this.removeImpl = remove;
    }

    private void setRemoveImplListener(SelectionListener removeImplListener) {
        this.removeImplListener = removeImplListener;
    }

    private void setRemoveServiceButton(Button remove) {
        this.removeService = remove;
    }

    private void setRemoveServiceListener(SelectionListener removeServiceListener) {
        this.removeServiceListener = removeServiceListener;
    }

    private void setServiceList(List list) {
        this.serviceList = list;
    }

    private void setServiceListListener(SelectionListener serviceListListener) {
        this.serviceListListener = serviceListListener;
    }

    public void setServiceListSelection(int serviceListSelection) {
        this.serviceListSelection = serviceListSelection;
    }

    protected void storeValues() {
        super.storeValues();
        List services = this.getServiceList();
        String[] sItems = services.getItems();
        DeviceKitPreferenceInitializer.setPreference((String)this.getServicesKey(), (String[])sItems);
        List impls = this.getImplList();
        String[] iItems = impls.getItems();
        DeviceKitPreferenceInitializer.setPreference((String)this.getImplsKey(), (String[])iItems);
    }
}

