/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.soda.devicekit.editor.dkml.DkmlColorProvider;
import org.eclipse.soda.devicekit.editor.dkml.DkmlCommentScanner;
import org.eclipse.soda.devicekit.editor.dkml.DkmlIncludeScanner;
import org.eclipse.soda.devicekit.editor.dkml.DkmlScanner;
import org.eclipse.soda.devicekit.editor.dkml.DkmlTagScanner;
import org.eclipse.soda.devicekit.editor.dkml.DkmlWhitespaceDetector;

public class DeviceKitEditorEnvironment {
    public static final String XML_DEFAULT = "__xml_default";
    public static final String XML_COMMENT = "__xml_comment";
    public static final String XML_TAG = "__xml_tag";
    public static final String XML_INCLUDE = "_xml_incude";
    public static final String XML_EMPTY_TAG = "_xml_empty_tag";
    public static final String XML_PROC = "_xml_proc_instruction";
    private static int fCount = 0;
    private static DkmlColorProvider fDKmlColorProvider;
    private static DkmlTagScanner fDKmlTagScanner;
    private static DkmlIncludeScanner fDKmlIncludeScanner;
    private static DkmlCommentScanner fDKmlCommentScanner;
    private static DkmlWhitespaceDetector fDKmlWhitespaceDetector;
    private static DkmlScanner fDKmlScanner;

    public static void connect(Object client) {
        if (++fCount == 1) {
            fDKmlColorProvider = new DkmlColorProvider();
            fDKmlWhitespaceDetector = new DkmlWhitespaceDetector();
            fDKmlIncludeScanner = new DkmlIncludeScanner(DeviceKitEditorEnvironment.getDkmlColorProvider());
            fDKmlTagScanner = new DkmlTagScanner(DeviceKitEditorEnvironment.getDkmlColorProvider());
            DeviceKitEditorEnvironment.getDkmlTagScanner().setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(DeviceKitEditorEnvironment.getDkmlColorProvider().getColor(DkmlColorProvider.TAG))));
            fDKmlCommentScanner = new DkmlCommentScanner(DeviceKitEditorEnvironment.getDkmlColorProvider());
            fDKmlScanner = new DkmlScanner(DeviceKitEditorEnvironment.getDkmlColorProvider());
        }
    }

    public static void disconnect(Object client) {
        if (--fCount == 0) {
            fDKmlColorProvider.dispose();
            fDKmlIncludeScanner = null;
            fDKmlTagScanner = null;
            fDKmlCommentScanner = null;
            fDKmlWhitespaceDetector = null;
            fDKmlScanner = null;
        }
    }

    public static DkmlScanner getCmlScanner() {
        return fDKmlScanner;
    }

    public static DkmlColorProvider getDkmlColorProvider() {
        return fDKmlColorProvider;
    }

    public static RuleBasedScanner getDkmlCommentScanner() {
        return fDKmlCommentScanner;
    }

    public static RuleBasedScanner getDkmlIncludeScanner() {
        return fDKmlIncludeScanner;
    }

    public static RuleBasedScanner getDkmlTagScanner() {
        return fDKmlTagScanner;
    }

    public static DkmlWhitespaceDetector getDkmlWhitespaceDetector() {
        return fDKmlWhitespaceDetector;
    }

    public static void setDkmlColorProvider(DkmlColorProvider fDKmlColorProvider) {
        DeviceKitEditorEnvironment.fDKmlColorProvider = fDKmlColorProvider;
    }
}

