/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.transaction;

import java.nio.ByteBuffer;
import org.apache.jena.tdb1.base.block.Block;
import org.apache.jena.tdb1.sys.FileRef;
import org.apache.jena.tdb1.transaction.JournalEntryType;

public class JournalEntry {
    public static final JournalEntry Commit = new JournalEntry(JournalEntryType.Commit);
    public static final JournalEntry Abort = new JournalEntry(JournalEntryType.Abort);
    public static final JournalEntry CheckPoint = new JournalEntry(JournalEntryType.Checkpoint);
    private long position = -1L;
    private long endPosition = -1L;
    private final JournalEntryType type;
    private final Block block;
    private final FileRef fileRef;

    private JournalEntry(JournalEntryType type) {
        this(type, null, (Block)null);
    }

    JournalEntry(JournalEntryType type, FileRef fileRef, ByteBuffer bytes) {
        this(type, fileRef, new Block(0L, bytes));
    }

    JournalEntry(JournalEntryType type, FileRef fileRef, Block block) {
        this.type = type;
        this.block = block;
        this.fileRef = fileRef;
    }

    void setPosition(long posn) {
        this.position = posn;
    }

    void setEndPosition(long endPosn) {
        this.endPosition = endPosn;
    }

    public long getPosition() {
        return this.position;
    }

    long getEndPosition() {
        return this.endPosition;
    }

    public JournalEntryType getType() {
        return this.type;
    }

    public ByteBuffer getByteBuffer() {
        return this.block.getByteBuffer();
    }

    public Block getBlock() {
        return this.block;
    }

    public FileRef getFileRef() {
        return this.fileRef;
    }

    public String toString() {
        return "JournalEntry: " + this.type + " " + this.fileRef;
    }

    public static String format(JournalEntry entry) {
        return JournalEntry.format(entry.getType(), entry.getByteBuffer(), entry.getBlock(), entry.getFileRef());
    }

    public static String format(JournalEntryType type, ByteBuffer byteBuffer, Block block, FileRef fileRef) {
        return String.format("Entry: %-6s  blk=%d  %s", new Object[]{type, block.getId(), fileRef.getFilename()});
    }
}

