/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.eclipse.emf.emfstore.server.auth.ESHashAndSalt;
import org.eclipse.emf.emfstore.server.auth.ESPasswordHashGenerator;

public class DefaultESPasswordHashGenerator
implements ESPasswordHashGenerator {
    public ESPasswordHashGenerator.ESHashAndSalt hashPassword(String password) {
        String salt = RandomStringUtils.randomAlphanumeric((int)128);
        String hash = this.createHash(password, salt);
        return ESHashAndSalt.create(hash, salt);
    }

    private String createHash(String password, String salt) {
        String hash = DigestUtils.sha512Hex((String)(String.valueOf(password) + salt));
        int i = 0;
        while (i < 128) {
            hash = i % 2 == 0 ? DigestUtils.sha512Hex((String)(String.valueOf(hash) + salt)) : DigestUtils.sha512Hex((String)(String.valueOf(salt) + hash));
            ++i;
        }
        return hash;
    }

    public boolean verifyPassword(String password, String hash, String salt) {
        if (password == null || hash == null || salt == null) {
            return false;
        }
        String hashToMatch = this.createHash(password, salt);
        return hash.equals(hashToMatch);
    }
}

