/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.mocks;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AbstractConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AdminConnectionManager;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AuthorizationControl;
import org.eclipse.emf.emfstore.internal.server.core.AdminEmfStoreImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.dao.ACDAOFacade;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminConnectionManagerMock
extends AbstractConnectionManager<Object>
implements AdminConnectionManager {
    private final AdminEmfStoreImpl adminEmfStore;

    public AdminConnectionManagerMock(ACDAOFacade daoFacade, AuthorizationControl authorizationControl, ServerSpace serverSpace) throws FatalESException {
        this.adminEmfStore = new AdminEmfStoreImpl(daoFacade, serverSpace, authorizationControl);
    }

    public void initConnection(ServerInfo serverInfo, SessionId id) throws ConnectionException {
        this.addConnectionProxy(id, new Object());
    }

    public List<ProjectInfo> getProjectInfos(SessionId sessionId) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.getProjectInfos(sessionId);
    }

    public List<ACGroup> getGroups(SessionId sessionId) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.getGroups(sessionId);
    }

    public List<ACUser> getUsers(SessionId sessionId) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.getUsers(sessionId);
    }

    public List<ACOrgUnit> getOrgUnits(SessionId sessionId) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.getOrgUnits(sessionId);
    }

    public ACOrgUnit getOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.getOrgUnit(sessionId, orgUnitId);
    }

    public ACOrgUnitId createGroup(SessionId sessionId, String name) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.createGroup(sessionId, name);
    }

    public void deleteGroup(SessionId sessionId, ACOrgUnitId groupId) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.deleteGroup(sessionId, groupId);
    }

    public List<ACGroup> getGroups(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.getGroups(sessionId, orgUnitId);
    }

    public void removeGroup(SessionId sessionId, ACOrgUnitId user, ACOrgUnitId group) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.removeGroup(sessionId, user, group);
    }

    public List<ACOrgUnit> getMembers(SessionId sessionId, ACOrgUnitId groupId) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.getMembers(sessionId, groupId);
    }

    public void addMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.addMember(sessionId, group, member);
    }

    public void removeMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.removeMember(sessionId, group, member);
    }

    public ACOrgUnitId createUser(SessionId sessionId, String name) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.createUser(sessionId, name);
    }

    public void deleteUser(SessionId sessionId, ACOrgUnitId userId) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.deleteUser(sessionId, userId);
    }

    public void changeOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId, String name, String description) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.changeOrgUnit(sessionId, orgUnitId, name, description);
    }

    public void changeUser(SessionId sessionId, ACOrgUnitId userId, String name, String password) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.changeUser(sessionId, userId, name, password);
    }

    public List<ACOrgUnit> getParticipants(SessionId sessionId, ProjectId projectId) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.getParticipants(sessionId, projectId);
    }

    public void addParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId, EClass roleClass) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.addParticipant(sessionId, projectId, participantId, roleClass);
    }

    public void removeParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.removeParticipant(sessionId, projectId, participantId);
    }

    public Role getRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnitId) throws ESException {
        this.getConnectionProxy(sessionId);
        return this.adminEmfStore.getRole(sessionId, projectId, orgUnitId);
    }

    public void changeRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnitId, EClass role) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.changeRole(sessionId, projectId, orgUnitId, role);
    }

    public void assignRole(SessionId sessionId, ACOrgUnitId orgUnitId, EClass roleClass) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.assignRole(sessionId, orgUnitId, roleClass);
    }

    public void addInitialParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId, EClass roleClass) throws ESException {
        this.getConnectionProxy(sessionId);
        this.adminEmfStore.addInitialParticipant(sessionId, projectId, participantId, roleClass);
    }
}

