/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.cases;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.exceptions.ESServerStartFailedException;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTest;
import org.eclipse.emf.emfstore.client.test.common.util.ServerUtil;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.EMFStoreController;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ESTestWithServer
extends ESTest {
    protected static void startEMFStore() {
        ESTestWithServer.startEMFStore(Collections.<String, String>emptyMap());
    }

    public static void startEMFStore(Map<String, String> properties) {
        ServerConfiguration.setProperties((Properties)ServerUtil.initProperties(properties));
        ServerConfiguration.setTesting((boolean)true);
        try {
            ServerUtil.startServer();
        }
        catch (ESServerStartFailedException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    public EMFStore getEMFStore() {
        return ESWorkspaceProviderImpl.getInstance().getConnectionManager();
    }

    public ProjectHistory getHistory(ESLocalProject localProject) {
        ESLocalProjectImpl projectImpl = (ESLocalProjectImpl)ESLocalProjectImpl.class.cast(localProject);
        ProjectId id = ((ProjectSpace)projectImpl.toInternalAPI()).getProjectId();
        for (ProjectHistory history : EMFStoreController.getInstance().getServerSpace().getProjects()) {
            if (!history.getProjectId().equals(id)) continue;
            return history;
        }
        throw new RuntimeException("Project History not found");
    }

    public static void stopEMFStore() {
        ServerUtil.stopServer();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    protected static void deleteRemoteProjects() throws IOException, FatalESException, ESException {
        for (ESRemoteProject project : ((ESServer)ESWorkspaceProvider.INSTANCE.getWorkspace().getServers().get(0)).getRemoteProjects()) {
            project.delete((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

