/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.controller;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.callbacks.ESUpdateCallback;
import org.eclipse.emf.emfstore.client.exceptions.ESProjectNotSharedException;
import org.eclipse.emf.emfstore.client.observer.ESUpdateObserver;
import org.eclipse.emf.emfstore.common.model.ESModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.client.common.UnknownEMFStoreWorkloadCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictDetector;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.server.impl.api.ESConflictSetImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.server.ESConflictSet;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateController
extends ServerCall<PrimaryVersionSpec> {
    private VersionSpec version;
    private ESUpdateCallback callback;

    public UpdateController(ProjectSpaceBase projectSpace, VersionSpec version, ESUpdateCallback callback, IProgressMonitor progress) {
        super(projectSpace);
        if (!projectSpace.isShared()) {
            throw new ESProjectNotSharedException();
        }
        if (version == null) {
            version = Versions.createHEAD((VersionSpec)projectSpace.getBaseVersion());
        }
        if (callback == null) {
            callback = ESUpdateCallback.NOCALLBACK;
        }
        this.version = version;
        this.callback = callback;
        this.setProgressMonitor(progress);
    }

    @Override
    protected PrimaryVersionSpec run() throws ESException {
        return this.doUpdate(this.version);
    }

    private PrimaryVersionSpec doUpdate(VersionSpec version) throws ChangeConflictException, ESException {
        ChangeConflictSet changeConflictSet;
        ESConflictSetImpl conflictSet;
        Set conflicts;
        this.getProgressMonitor().beginTask("Updating Project...", 100);
        this.getProgressMonitor().worked(1);
        this.getProgressMonitor().subTask("Resolving new version");
        final PrimaryVersionSpec resolvedVersion = this.getProjectSpace().resolveVersionSpec(version, this.getProgressMonitor());
        if (resolvedVersion.compareTo((Object)this.getProjectSpace().getBaseVersion()) == 0) {
            return resolvedVersion;
        }
        this.getProgressMonitor().worked(5);
        if (this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask("Fetching changes from server");
        List changes = (List)new UnknownEMFStoreWorkloadCommand<List<ChangePackage>>(this.getProgressMonitor()){

            @Override
            public List<ChangePackage> run(IProgressMonitor monitor) throws ESException {
                return UpdateController.this.getConnectionManager().getChanges(UpdateController.this.getSessionId(), UpdateController.this.getProjectSpace().getProjectId(), (VersionSpec)UpdateController.this.getProjectSpace().getBaseVersion(), (VersionSpec)resolvedVersion);
            }
        }.execute();
        ChangePackage localChanges = this.getProjectSpace().getLocalChangePackage(false);
        ModelElementIdToEObjectMappingImpl idToEObjectMapping = new ModelElementIdToEObjectMappingImpl((ModelElementIdToEObjectMapping)this.getProjectSpace().getProject(), changes);
        idToEObjectMapping.put(localChanges);
        this.getProgressMonitor().worked(65);
        if (this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask("Checking for conflicts");
        ConflictDetector conflictDetector = new ConflictDetector();
        List copy = APIUtil.mapToAPI(ESChangePackage.class, (List)changes);
        if (this.getProgressMonitor().isCanceled() || !this.callback.inspectChanges(this.getProjectSpace().toAPI(), copy, (ESModelElementIdToEObjectMapping)idToEObjectMapping.toAPI())) {
            return this.getProjectSpace().getBaseVersion();
        }
        ((ESUpdateObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESUpdateObserver.class)).inspectChanges(this.getProjectSpace().toAPI(), copy, this.getProgressMonitor());
        if (this.getProjectSpace().getOperations().size() > 0 && (conflicts = (conflictSet = new ESConflictSetImpl(changeConflictSet = conflictDetector.calculateConflicts(Collections.singletonList(localChanges), changes, (ModelElementIdToEObjectMapping)idToEObjectMapping))).getConflicts()).size() > 0) {
            this.getProgressMonitor().subTask("Conflicts detected, calculating conflicts");
            if (this.callback.conflictOccurred((ESConflictSet)conflictSet, this.getProgressMonitor())) {
                localChanges = this.getProjectSpace().mergeResolvedConflicts(changeConflictSet, Collections.singletonList(localChanges), changes);
            } else {
                throw new ChangeConflictException(changeConflictSet);
            }
        }
        this.getProgressMonitor().worked(15);
        this.getProgressMonitor().subTask("Applying changes");
        this.getProjectSpace().applyChanges(resolvedVersion, changes, localChanges, this.getProgressMonitor(), true);
        ((ESUpdateObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESUpdateObserver.class)).updateCompleted(this.getProjectSpace().toAPI(), this.getProgressMonitor());
        return this.getProjectSpace().getBaseVersion();
    }
}

