/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.login;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.common.ESDisposable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInfoSelectionDialog
extends TitleAreaDialog {
    private final List<ServerInfo> servers;
    private ESServer result;
    private ListViewer listViewer;
    private ServerInfoLabelProvider labelProvider;

    public ServerInfoSelectionDialog(Shell parentShell, List<ServerInfo> servers) {
        super(parentShell);
        this.servers = servers;
        this.result = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Please select a server");
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("In order to execute your requested operation, you have to select a server.");
        this.setTitle("Please select a Server");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.listViewer = new ListViewer(container, 2560);
        org.eclipse.swt.widgets.List list = this.listViewer.getList();
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.labelProvider = new ServerInfoLabelProvider();
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setInput(this.servers);
        if (this.servers.size() == 1) {
            this.listViewer.setSelection((ISelection)new StructuredSelection((Object)this.servers.get(0)));
        }
        return area;
    }

    protected void okPressed() {
        ISelection selection = this.listViewer.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof ServerInfo) {
            ServerInfo serverInfo = (ServerInfo)((IStructuredSelection)selection).getFirstElement();
            this.result = (ESServer)serverInfo.toAPI();
        }
        super.okPressed();
    }

    public ESServer getResult() {
        return this.result;
    }

    public boolean close() {
        this.labelProvider.dispose();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, JFaceResources.getString((String)"ok"), true);
        this.createButton(parent, 1, JFaceResources.getString((String)"cancel"), false);
    }

    protected Point getInitialSize() {
        return new Point(355, 403);
    }

    private class ServerInfoLabelProvider
    extends AdapterFactoryLabelProvider
    implements ESDisposable {
        public ServerInfoLabelProvider() {
            super((AdapterFactory)Activator.getAdapterFactory());
        }

        public String getText(Object object) {
            if (object instanceof ServerInfo) {
                ServerInfo server = (ServerInfo)object;
                return String.valueOf(server.getName()) + " [" + server.getUrl() + " : " + server.getPort() + "]";
            }
            return super.getText(object);
        }
    }
}

