/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDeleteProjectController
extends AbstractEMFStoreUIController<Void> {
    private final ESLocalProject localProject;

    public UIDeleteProjectController(Shell shell, ESLocalProject localProject) {
        super(shell);
        this.localProject = localProject;
    }

    private void deleteProject(ESLocalProject localProject) {
        try {
            localProject.delete((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ESException e) {
            e.printStackTrace();
        }
    }

    private boolean confirmation(ESLocalProject localProject) {
        String message = "Do you really want to delete your local copy of project \"" + localProject.getProjectName() + "\n";
        if (localProject.getBaseVersion() != null) {
            message = String.valueOf(message) + " in version " + localProject.getBaseVersion().getIdentifier();
        }
        message = String.valueOf(message) + " ?";
        return this.confirm("Confirmation", message);
    }

    @Override
    public Void doRun(IProgressMonitor monitor) throws ESException {
        if (!this.confirmation(this.localProject)) {
            return null;
        }
        this.deleteProject(this.localProject);
        return null;
    }
}

