/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.IPlotCommit;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.PlotLane;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotCommit
implements IPlotCommit {
    private PlotLane lane;
    private PlotLane[] passingLanes;
    private List<IPlotCommit> parents;
    private List<IPlotCommit> children;
    private Widget widget;
    private boolean isRealCommit;
    private String branchName;
    private int id;
    private boolean localHistoryOnly;
    private Color color;
    private Color lightColor;

    public PlotCommit(HistoryInfo historyInfo) {
        this.initFields();
        if (historyInfo.getPrimarySpec().getIdentifier() < 0) {
            this.branchName = "local";
            this.id = -1;
        } else if (historyInfo.getPrimarySpec() != null) {
            this.branchName = historyInfo.getPrimarySpec().getBranch();
            this.id = historyInfo.getPrimarySpec().getIdentifier();
        } else {
            this.branchName = "Strange";
            this.id = -666;
            this.localHistoryOnly = true;
        }
    }

    private void initFields() {
        this.lane = null;
        this.passingLanes = new PlotLane[0];
        this.parents = new ArrayList<IPlotCommit>();
        this.children = new ArrayList<IPlotCommit>();
        this.widget = null;
        this.isRealCommit = true;
    }

    public PlotCommit(int dummyId, String branch) {
        this.initFields();
        this.id = dummyId;
        this.branchName = branch;
    }

    @Override
    public void setLane(PlotLane lane) {
        this.lane = lane;
    }

    @Override
    public PlotLane getLane() {
        return this.lane;
    }

    @Override
    public void addPassingLane(PlotLane c) {
        int cnt = this.passingLanes.length;
        if (cnt == 0) {
            this.passingLanes = new PlotLane[]{c};
        } else if (cnt == 1) {
            this.passingLanes = new PlotLane[]{this.passingLanes[0], c};
        } else {
            PlotLane[] n = new PlotLane[cnt + 1];
            System.arraycopy(this.passingLanes, 0, n, 0, cnt);
            n[cnt] = c;
            this.passingLanes = n;
        }
    }

    @Override
    public PlotLane[] getPassingLanes() {
        return this.passingLanes;
    }

    @Override
    public void setParents(List<IPlotCommit> parents) {
        this.parents = parents;
    }

    @Override
    public int getParentCount() {
        return this.parents.size();
    }

    @Override
    public IPlotCommit getParent(int i) {
        return this.parents.get(i);
    }

    @Override
    public void addChild(IPlotCommit child) {
        this.children.add(child);
    }

    @Override
    public IPlotCommit getChild(int child) {
        return this.children.get(child);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isChild(IPlotCommit commit) {
        for (IPlotCommit mc : this.children) {
            if (mc != commit) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setIsRealCommit(boolean isReal) {
        this.isRealCommit = isReal;
    }

    @Override
    public boolean isRealCommit() {
        return this.isRealCommit;
    }

    @Override
    public String getBranch() {
        return this.branchName;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
        }
    }

    @Override
    public boolean isLocalHistoryOnly() {
        return this.localHistoryOnly;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setLightColor(Color color) {
        this.lightColor = color;
    }

    @Override
    public Color getLightColor() {
        return this.lightColor;
    }
}

