/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.custom.swt;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.spi.ECPAbstractControl;
import org.eclipse.emf.ecp.edit.spi.ECPControlFactory;
import org.eclipse.emf.ecp.view.internal.custom.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.custom.model.ECPCustomControlChangeListener;
import org.eclipse.emf.ecp.view.spi.custom.model.ECPHardcodedReferences;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomControl;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomDomainModelReference;
import org.eclipse.emf.ecp.view.spi.custom.model.impl.VCustomDomainModelReferenceImpl;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.osgi.framework.Bundle;

public abstract class ECPAbstractCustomControlSWT {
    protected static final String CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant";
    public static final int VALIDATION_ERROR_IMAGE = 0;
    public static final int ADD_IMAGE = 1;
    public static final int DELETE_IMAGE = 2;
    public static final int HELP_IMAGE = 3;
    private final SWTCustomControlHelper swtHelper = new SWTCustomControlHelper();
    private ECPControlFactory controlFactory;
    private final Map<EStructuralFeature, ECPAbstractControl> controlMap = new LinkedHashMap<EStructuralFeature, ECPAbstractControl>();
    private final Map<VDomainModelReference, Adapter> adapterMap = new LinkedHashMap<VDomainModelReference, Adapter>();
    private ViewModelContext viewModelContext;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private VCustomControl customControl;
    private DataBindingContext dataBindingContext;
    private final EMFDataBindingContext viewModelDBC = new EMFDataBindingContext();

    public final void init(VCustomControl customControl, ViewModelContext viewModelContext) {
        this.customControl = customControl;
        this.viewModelContext = viewModelContext;
        this.controlFactory = Activator.getDefault().getECPControlFactory();
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        this.postInit();
    }

    protected void postInit() {
        if (!VCustomDomainModelReference.class.isInstance(this.customControl.getDomainModelReference())) {
            return;
        }
        VCustomDomainModelReference customDomainModelReference = (VCustomDomainModelReference)VCustomDomainModelReference.class.cast(this.customControl.getDomainModelReference());
        ECPHardcodedReferences hardcodedReferences = ECPAbstractCustomControlSWT.loadObject(customDomainModelReference.getBundleName(), customDomainModelReference.getClassName());
        if (!customDomainModelReference.isControlChecked()) {
            LinkedHashSet controlReferences = new LinkedHashSet();
            controlReferences.addAll(hardcodedReferences.getNeededDomainModelReferences());
            controlReferences.addAll(customDomainModelReference.getDomainModelReferences());
            customDomainModelReference.getDomainModelReferences().clear();
            customDomainModelReference.getDomainModelReferences().addAll(controlReferences);
            customDomainModelReference.setControlChecked(true);
        }
    }

    private static ECPHardcodedReferences loadObject(String bundleName, String clazz) {
        Class loadClass;
        block6: {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                new ClassNotFoundException(String.format(LocalizationServiceHelper.getString(VCustomDomainModelReferenceImpl.class, (String)"BundleNotFound_ExceptionMessage"), clazz, bundleName));
                return null;
            }
            loadClass = bundle.loadClass(clazz);
            if (ECPHardcodedReferences.class.isAssignableFrom(loadClass)) break block6;
            return null;
        }
        try {
            return (ECPHardcodedReferences)ECPHardcodedReferences.class.cast(loadClass.newInstance());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public final void dispose() {
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
        }
        this.viewModelDBC.dispose();
        this.customControl = null;
        if (this.adapterMap != null) {
            for (VDomainModelReference domainModelReference : this.adapterMap.keySet()) {
                EStructuralFeature.Setting setting = this.getFirstSetting(domainModelReference);
                setting.getEObject().eAdapters().remove((Object)this.adapterMap.get(domainModelReference));
            }
            this.adapterMap.clear();
        }
        if (this.controlMap != null) {
            for (ECPAbstractControl control : this.controlMap.values()) {
                control.dispose();
            }
            this.controlMap.clear();
        }
        this.viewModelContext = null;
        Activator.getDefault().ungetECPControlFactory();
        this.controlFactory = null;
        this.disposeCustomControl();
    }

    protected abstract void disposeCustomControl();

    protected final ViewModelContext getViewModelContext() {
        return this.viewModelContext;
    }

    protected final VCustomControl getCustomControl() {
        return this.customControl;
    }

    protected final DataBindingContext getDataBindingContext() {
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new EMFDataBindingContext();
        }
        return this.dataBindingContext;
    }

    private void handleCreatedControls(Diagnostic diagnostic) {
        if (diagnostic.getData() == null) {
            return;
        }
        if (diagnostic.getData().size() < 2) {
            return;
        }
        if (!(diagnostic.getData().get(1) instanceof EStructuralFeature)) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)diagnostic.getData().get(1);
        ECPAbstractControl ecpControl = this.controlMap.get(feature);
        if (ecpControl == null) {
            return;
        }
        ecpControl.handleValidation(diagnostic);
    }

    protected abstract void handleContentValidation();

    protected final SWTCustomControlHelper getHelper() {
        return this.swtHelper;
    }

    private Image getImage(int imageType) {
        switch (imageType) {
            case 0: {
                return Activator.getImage("icons/validation_error.png");
            }
            case 3: {
                return Activator.getImage("icons/help.png");
            }
            case 1: {
                return Activator.getImage("icons/add.png");
            }
            case 2: {
                return Activator.getImage("icons/unset_reference.png");
            }
        }
        return null;
    }

    protected final Control createLabel(Composite parent) throws NoPropertyDescriptorFoundExeption {
        Label label;
        block5: {
            label = null;
            if (this.getCustomControl().getLabelAlignment() == LabelAlignment.LEFT) {
                IValueProperty valueProperty;
                try {
                    valueProperty = Activator.getDefault().getEMFFormsDatabinding().getValueProperty(this.getCustomControl().getDomainModelReference(), this.getViewModelContext().getDomainModel());
                }
                catch (DatabindingFailedException ex) {
                    Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    break block5;
                }
                final EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
                label = new Label(parent, 0);
                label.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_control_label");
                label.setBackground(parent.getBackground());
                try {
                    this.viewModelDBC.bindValue((IObservableValue)SWTObservables.observeText((Control)label), Activator.getDefault().getEMFFormsLabelProvider().getDisplayName(this.getCustomControl().getDomainModelReference(), this.getViewModelContext().getDomainModel()), null, new UpdateValueStrategy(){

                        public Object convert(Object value) {
                            String labelText = (String)super.convert(value);
                            String extra = "";
                            if (structuralFeature.getLowerBound() > 0) {
                                extra = "*";
                            }
                            return String.valueOf(labelText) + extra;
                        }
                    });
                    this.viewModelDBC.bindValue((IObservableValue)SWTObservables.observeTooltipText((Control)label), Activator.getDefault().getEMFFormsLabelProvider().getDescription(this.getCustomControl().getDomainModelReference(), this.getViewModelContext().getDomainModel()));
                }
                catch (NoLabelFoundException e) {
                    Activator.getDefault().getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
                    label.setText(e.getMessage());
                    label.setToolTipText(e.toString());
                }
            }
        }
        return label;
    }

    protected final Label createValidationIcon(Composite composite) {
        Label validationLabel = new Label(composite, 0);
        validationLabel.setBackground(composite.getBackground());
        return validationLabel;
    }

    protected final void createViewerBinding(VDomainModelReference customControlFeature, StructuredViewer viewer, IValueProperty[] labelProperties) {
        try {
            IObservableList list = Activator.getDefault().getEMFFormsDatabinding().getObservableList(customControlFeature, this.getViewModelContext().getDomainModel());
            ViewerSupport.bind((StructuredViewer)viewer, (IObservableList)list, (IValueProperty[])labelProperties);
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
        }
    }

    @Deprecated
    protected final IObservableList getObservableList(VDomainModelReference domainModelReference) {
        throw new UnsupportedOperationException("This method is deprecated and must not be used anymore. Use the databinding service instead.");
    }

    protected final EditingDomain getEditingDomain(EStructuralFeature.Setting setting) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)setting.getEObject());
    }

    private EStructuralFeature.Setting getFirstSetting(VDomainModelReference modelFeature) {
        IObservableValue observableValue;
        try {
            observableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(modelFeature, this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            throw new IllegalStateException("The databinding failed due to an incorrect VDomainModelReference: " + ex.getMessage());
        }
        InternalEObject internalEObject = (InternalEObject)((IObserving)observableValue).getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        return internalEObject.eSetting(structuralFeature);
    }

    protected final <T extends ECPAbstractControl> T getControl(Class<T> clazz, VDomainModelReference domainModelReference) {
        IValueProperty valueProperty;
        ECPAbstractControl createControl = (ECPAbstractControl)this.controlFactory.createControl(clazz, this.getViewModelContext().getDomainModel(), domainModelReference);
        VControl vControl = VViewFactory.eINSTANCE.createControl();
        VDomainModelReference modelReference = (VDomainModelReference)EcoreUtil.copy((EObject)domainModelReference);
        modelReference.init(this.getViewModelContext().getDomainModel());
        vControl.setDomainModelReference(modelReference);
        vControl.setDiagnostic(VViewFactory.eINSTANCE.createDiagnostic());
        createControl.init(this.getViewModelContext(), vControl);
        try {
            valueProperty = Activator.getDefault().getEMFFormsDatabinding().getValueProperty(domainModelReference, this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return null;
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        this.controlMap.put(structuralFeature, createControl);
        return (T)createControl;
    }

    protected final IItemPropertyDescriptor getItemPropertyDescriptor(EStructuralFeature.Setting setting) {
        return this.adapterFactoryItemDelegator.getPropertyDescriptor((Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
    }

    private String getHelp(VDomainModelReference domainModelReference) {
        if (!this.getResolvedDomainModelReferences().contains(domainModelReference)) {
            throw new IllegalArgumentException("The feature must have been registered before!");
        }
        return this.getItemPropertyDescriptor(this.getFirstSetting(domainModelReference)).getDescription(null);
    }

    private String getLabel(VDomainModelReference domainModelReference) {
        if (!this.getResolvedDomainModelReferences().contains(domainModelReference)) {
            throw new IllegalArgumentException("The feature must have been registered before!");
        }
        return this.getItemPropertyDescriptor(this.getFirstSetting(domainModelReference)).getDisplayName(null);
    }

    protected final List<VDomainModelReference> getResolvedDomainModelReferences() {
        VDomainModelReference domainModelReference = this.getCustomControl().getDomainModelReference();
        if (VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            return ((VCustomDomainModelReference)VCustomDomainModelReference.class.cast(domainModelReference)).getDomainModelReferences();
        }
        return Collections.singletonList(domainModelReference);
    }

    protected final VDomainModelReference getResolvedDomainModelReference(EStructuralFeature feature) {
        for (VDomainModelReference domainModelReference : this.getResolvedDomainModelReferences()) {
            VFeaturePathDomainModelReference ref;
            if (!VFeaturePathDomainModelReference.class.isInstance(domainModelReference) || (ref = (VFeaturePathDomainModelReference)VFeaturePathDomainModelReference.class.cast(domainModelReference)).getDomainModelEFeature() != feature) continue;
            return ref;
        }
        return null;
    }

    protected final Binding bindTargetToModel(VDomainModelReference modelFeature, IObservableValue targetValue, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        EStructuralFeature.Setting setting = this.getFirstSetting(modelFeature);
        IObservableValue modelValue = EMFEditObservables.observeValue((EditingDomain)this.getEditingDomain(setting), (EObject)setting.getEObject(), (EStructuralFeature)setting.getEStructuralFeature());
        return this.getDataBindingContext().bindValue(targetValue, modelValue, targetToModel, modelToTarget);
    }

    protected final EditingDomain getEditingDomain() {
        return this.getEditingDomain(this.getFirstSetting(this.getCustomControl().getDomainModelReference()));
    }

    protected final Object getValue(VDomainModelReference modelReference) {
        EStructuralFeature.Setting setting = this.getFirstSetting(modelReference);
        return setting.get(false);
    }

    protected final void setValue(VDomainModelReference modelReference, Object newValue) {
        EStructuralFeature.Setting setting = this.getFirstSetting(modelReference);
        setting.set(newValue);
    }

    protected final void registerChangeListener(VDomainModelReference modelReference, final ECPCustomControlChangeListener changeListener) {
        if (this.adapterMap.containsKey(modelReference)) {
            return;
        }
        final EStructuralFeature.Setting setting = this.getFirstSetting(modelReference);
        AdapterImpl newAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.isTouch()) {
                    return;
                }
                if (msg.getFeature().equals(setting.getEStructuralFeature())) {
                    super.notifyChanged(msg);
                    changeListener.notifyChanged();
                }
            }
        };
        setting.getEObject().eAdapters().add((Object)newAdapter);
        this.adapterMap.put(modelReference, (Adapter)newAdapter);
    }

    public abstract SWTGridDescription getGridDescription();

    public abstract Control renderControl(SWTGridCell var1, Composite var2) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption;

    public final void applyValidation() {
        if (this.getCustomControl() == null || this.getCustomControl().getDiagnostic() == null) {
            return;
        }
        for (Object diagnostic : this.getCustomControl().getDiagnostic().getDiagnostics()) {
            this.handleCreatedControls((Diagnostic)diagnostic);
        }
        this.handleContentValidation();
    }

    public final void applyReadOnly(Map<SWTGridCell, Control> controls) {
        if (this.setEditable(!this.getCustomControl().isReadonly())) {
            for (SWTGridCell gridCell : controls.keySet()) {
                this.setControlEnabled(gridCell, controls.get(gridCell), !this.getCustomControl().isReadonly());
            }
        }
    }

    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        if (Label.class.isInstance(control)) {
            return;
        }
        control.setEnabled(enabled);
    }

    public final void applyEnable(Map<SWTGridCell, Control> controls) {
        if (this.setEditable(this.getCustomControl().isEnabled())) {
            for (SWTGridCell gridCell : controls.keySet()) {
                this.setControlEnabled(gridCell, controls.get(gridCell), this.getCustomControl().isEnabled());
            }
        }
    }

    protected boolean setEditable(boolean editable) {
        return true;
    }

    protected final SWTGridDescription createSimpleGrid(int rows, int columns) {
        return GridDescriptionFactory.INSTANCE.createSimpleGrid(rows, columns, null);
    }

    public final class SWTCustomControlHelper {
        public Image getImage(int imageType) {
            return ECPAbstractCustomControlSWT.this.getImage(imageType);
        }

        public String getHelp(VDomainModelReference domainModelReference) {
            return ECPAbstractCustomControlSWT.this.getHelp(domainModelReference);
        }

        public String getLabel(VDomainModelReference domainModelReference) {
            return ECPAbstractCustomControlSWT.this.getLabel(domainModelReference);
        }
    }
}

