/**
 */
package org.eclipse.emf.refactor.examples.simpleWebModel;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.refactor.examples.simpleWebModel.SimpleWebModelFactory
 * @model kind="package"
 * @generated
 */
public interface SimpleWebModelPackage extends EPackage
{
  /**
   * The package name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNAME = "simpleWebModel";

  /**
   * The package namespace URI.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_URI = "http://www.eclipse.org/SimpleWebModel/1.0";

  /**
   * The package namespace name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_PREFIX = "simpleWebModel";

  /**
   * The singleton instance of the package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  SimpleWebModelPackage eINSTANCE = org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl.init();

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.WebModelImpl <em>Web Model</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.WebModelImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getWebModel()
   * @generated
   */
  int WEB_MODEL = 0;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int WEB_MODEL__NAME = 0;

  /**
   * The feature id for the '<em><b>Data Layer</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int WEB_MODEL__DATA_LAYER = 1;

  /**
   * The feature id for the '<em><b>Hypertext Layer</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int WEB_MODEL__HYPERTEXT_LAYER = 2;

  /**
   * The number of structural features of the '<em>Web Model</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int WEB_MODEL_FEATURE_COUNT = 3;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.DataLayerImpl <em>Data Layer</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.DataLayerImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getDataLayer()
   * @generated
   */
  int DATA_LAYER = 1;

  /**
   * The feature id for the '<em><b>Entities</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_LAYER__ENTITIES = 0;

  /**
   * The number of structural features of the '<em>Data Layer</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_LAYER_FEATURE_COUNT = 1;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.EntityImpl <em>Entity</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.EntityImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getEntity()
   * @generated
   */
  int ENTITY = 2;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ENTITY__NAME = 0;

  /**
   * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ENTITY__ATTRIBUTES = 1;

  /**
   * The feature id for the '<em><b>References</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ENTITY__REFERENCES = 2;

  /**
   * The number of structural features of the '<em>Entity</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ENTITY_FEATURE_COUNT = 3;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.AttributeImpl <em>Attribute</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.AttributeImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getAttribute()
   * @generated
   */
  int ATTRIBUTE = 3;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ATTRIBUTE__NAME = 0;

  /**
   * The feature id for the '<em><b>Type</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ATTRIBUTE__TYPE = 1;

  /**
   * The number of structural features of the '<em>Attribute</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int ATTRIBUTE_FEATURE_COUNT = 2;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.ReferenceImpl <em>Reference</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.ReferenceImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getReference()
   * @generated
   */
  int REFERENCE = 4;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REFERENCE__NAME = 0;

  /**
   * The feature id for the '<em><b>Type</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REFERENCE__TYPE = 1;

  /**
   * The number of structural features of the '<em>Reference</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REFERENCE_FEATURE_COUNT = 2;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.HypertextLayerImpl <em>Hypertext Layer</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.HypertextLayerImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getHypertextLayer()
   * @generated
   */
  int HYPERTEXT_LAYER = 5;

  /**
   * The feature id for the '<em><b>Pages</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int HYPERTEXT_LAYER__PAGES = 0;

  /**
   * The feature id for the '<em><b>Start Page</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int HYPERTEXT_LAYER__START_PAGE = 1;

  /**
   * The number of structural features of the '<em>Hypertext Layer</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int HYPERTEXT_LAYER_FEATURE_COUNT = 2;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.PageImpl <em>Page</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.PageImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getPage()
   * @generated
   */
  int PAGE = 6;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PAGE__NAME = 0;

  /**
   * The feature id for the '<em><b>Links</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PAGE__LINKS = 1;

  /**
   * The number of structural features of the '<em>Page</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PAGE_FEATURE_COUNT = 2;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.StaticPageImpl <em>Static Page</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.StaticPageImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getStaticPage()
   * @generated
   */
  int STATIC_PAGE = 7;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STATIC_PAGE__NAME = PAGE__NAME;

  /**
   * The feature id for the '<em><b>Links</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STATIC_PAGE__LINKS = PAGE__LINKS;

  /**
   * The number of structural features of the '<em>Static Page</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STATIC_PAGE_FEATURE_COUNT = PAGE_FEATURE_COUNT + 0;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.LinkImpl <em>Link</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.LinkImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getLink()
   * @generated
   */
  int LINK = 8;

  /**
   * The feature id for the '<em><b>Target</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK__TARGET = 0;

  /**
   * The number of structural features of the '<em>Link</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_FEATURE_COUNT = 1;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.DynamicPageImpl <em>Dynamic Page</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.DynamicPageImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getDynamicPage()
   * @generated
   */
  int DYNAMIC_PAGE = 9;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DYNAMIC_PAGE__NAME = PAGE__NAME;

  /**
   * The feature id for the '<em><b>Links</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DYNAMIC_PAGE__LINKS = PAGE__LINKS;

  /**
   * The feature id for the '<em><b>Entity</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DYNAMIC_PAGE__ENTITY = PAGE_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>Dynamic Page</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DYNAMIC_PAGE_FEATURE_COUNT = PAGE_FEATURE_COUNT + 1;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.IndexPageImpl <em>Index Page</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.IndexPageImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getIndexPage()
   * @generated
   */
  int INDEX_PAGE = 10;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INDEX_PAGE__NAME = DYNAMIC_PAGE__NAME;

  /**
   * The feature id for the '<em><b>Links</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INDEX_PAGE__LINKS = DYNAMIC_PAGE__LINKS;

  /**
   * The feature id for the '<em><b>Entity</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INDEX_PAGE__ENTITY = DYNAMIC_PAGE__ENTITY;

  /**
   * The number of structural features of the '<em>Index Page</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INDEX_PAGE_FEATURE_COUNT = DYNAMIC_PAGE_FEATURE_COUNT + 0;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.DataPageImpl <em>Data Page</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.DataPageImpl
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getDataPage()
   * @generated
   */
  int DATA_PAGE = 11;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_PAGE__NAME = DYNAMIC_PAGE__NAME;

  /**
   * The feature id for the '<em><b>Links</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_PAGE__LINKS = DYNAMIC_PAGE__LINKS;

  /**
   * The feature id for the '<em><b>Entity</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_PAGE__ENTITY = DYNAMIC_PAGE__ENTITY;

  /**
   * The number of structural features of the '<em>Data Page</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_PAGE_FEATURE_COUNT = DYNAMIC_PAGE_FEATURE_COUNT + 0;

  /**
   * The meta object id for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.SimpleType <em>Simple Type</em>}' enum.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.SimpleType
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getSimpleType()
   * @generated
   */
  int SIMPLE_TYPE = 12;


  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.WebModel <em>Web Model</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Web Model</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.WebModel
   * @generated
   */
  EClass getWebModel();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.emf.refactor.examples.simpleWebModel.WebModel#getName <em>Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Name</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.WebModel#getName()
   * @see #getWebModel()
   * @generated
   */
  EAttribute getWebModel_Name();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.emf.refactor.examples.simpleWebModel.WebModel#getDataLayer <em>Data Layer</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Data Layer</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.WebModel#getDataLayer()
   * @see #getWebModel()
   * @generated
   */
  EReference getWebModel_DataLayer();

  /**
   * Returns the meta object for the containment reference '{@link org.eclipse.emf.refactor.examples.simpleWebModel.WebModel#getHypertextLayer <em>Hypertext Layer</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Hypertext Layer</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.WebModel#getHypertextLayer()
   * @see #getWebModel()
   * @generated
   */
  EReference getWebModel_HypertextLayer();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.DataLayer <em>Data Layer</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Data Layer</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.DataLayer
   * @generated
   */
  EClass getDataLayer();

  /**
   * Returns the meta object for the containment reference list '{@link org.eclipse.emf.refactor.examples.simpleWebModel.DataLayer#getEntities <em>Entities</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Entities</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.DataLayer#getEntities()
   * @see #getDataLayer()
   * @generated
   */
  EReference getDataLayer_Entities();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Entity <em>Entity</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Entity</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Entity
   * @generated
   */
  EClass getEntity();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Entity#getName <em>Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Name</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Entity#getName()
   * @see #getEntity()
   * @generated
   */
  EAttribute getEntity_Name();

  /**
   * Returns the meta object for the containment reference list '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Entity#getAttributes <em>Attributes</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Attributes</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Entity#getAttributes()
   * @see #getEntity()
   * @generated
   */
  EReference getEntity_Attributes();

  /**
   * Returns the meta object for the containment reference list '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Entity#getReferences <em>References</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>References</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Entity#getReferences()
   * @see #getEntity()
   * @generated
   */
  EReference getEntity_References();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Attribute <em>Attribute</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Attribute</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Attribute
   * @generated
   */
  EClass getAttribute();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Attribute#getName <em>Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Name</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Attribute#getName()
   * @see #getAttribute()
   * @generated
   */
  EAttribute getAttribute_Name();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Attribute#getType <em>Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Type</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Attribute#getType()
   * @see #getAttribute()
   * @generated
   */
  EAttribute getAttribute_Type();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Reference <em>Reference</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Reference</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Reference
   * @generated
   */
  EClass getReference();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Reference#getName <em>Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Name</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Reference#getName()
   * @see #getReference()
   * @generated
   */
  EAttribute getReference_Name();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Reference#getType <em>Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Type</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Reference#getType()
   * @see #getReference()
   * @generated
   */
  EReference getReference_Type();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.HypertextLayer <em>Hypertext Layer</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Hypertext Layer</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.HypertextLayer
   * @generated
   */
  EClass getHypertextLayer();

  /**
   * Returns the meta object for the containment reference list '{@link org.eclipse.emf.refactor.examples.simpleWebModel.HypertextLayer#getPages <em>Pages</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Pages</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.HypertextLayer#getPages()
   * @see #getHypertextLayer()
   * @generated
   */
  EReference getHypertextLayer_Pages();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.emf.refactor.examples.simpleWebModel.HypertextLayer#getStartPage <em>Start Page</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Start Page</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.HypertextLayer#getStartPage()
   * @see #getHypertextLayer()
   * @generated
   */
  EReference getHypertextLayer_StartPage();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Page <em>Page</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Page</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Page
   * @generated
   */
  EClass getPage();

  /**
   * Returns the meta object for the attribute '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Page#getName <em>Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Name</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Page#getName()
   * @see #getPage()
   * @generated
   */
  EAttribute getPage_Name();

  /**
   * Returns the meta object for the containment reference list '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Page#getLinks <em>Links</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Links</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Page#getLinks()
   * @see #getPage()
   * @generated
   */
  EReference getPage_Links();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.StaticPage <em>Static Page</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Static Page</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.StaticPage
   * @generated
   */
  EClass getStaticPage();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Link <em>Link</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Link</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Link
   * @generated
   */
  EClass getLink();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.emf.refactor.examples.simpleWebModel.Link#getTarget <em>Target</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Target</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.Link#getTarget()
   * @see #getLink()
   * @generated
   */
  EReference getLink_Target();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.DynamicPage <em>Dynamic Page</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Dynamic Page</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.DynamicPage
   * @generated
   */
  EClass getDynamicPage();

  /**
   * Returns the meta object for the reference '{@link org.eclipse.emf.refactor.examples.simpleWebModel.DynamicPage#getEntity <em>Entity</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Entity</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.DynamicPage#getEntity()
   * @see #getDynamicPage()
   * @generated
   */
  EReference getDynamicPage_Entity();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.IndexPage <em>Index Page</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Index Page</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.IndexPage
   * @generated
   */
  EClass getIndexPage();

  /**
   * Returns the meta object for class '{@link org.eclipse.emf.refactor.examples.simpleWebModel.DataPage <em>Data Page</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Data Page</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.DataPage
   * @generated
   */
  EClass getDataPage();

  /**
   * Returns the meta object for enum '{@link org.eclipse.emf.refactor.examples.simpleWebModel.SimpleType <em>Simple Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for enum '<em>Simple Type</em>'.
   * @see org.eclipse.emf.refactor.examples.simpleWebModel.SimpleType
   * @generated
   */
  EEnum getSimpleType();

  /**
   * Returns the factory that creates the instances of the model.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the factory that creates the instances of the model.
   * @generated
   */
  SimpleWebModelFactory getSimpleWebModelFactory();

  /**
   * <!-- begin-user-doc -->
   * Defines literals for the meta objects that represent
   * <ul>
   *   <li>each class,</li>
   *   <li>each feature of each class,</li>
   *   <li>each enum,</li>
   *   <li>and each data type</li>
   * </ul>
   * <!-- end-user-doc -->
   * @generated
   */
  interface Literals
  {
    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.WebModelImpl <em>Web Model</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.WebModelImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getWebModel()
     * @generated
     */
    EClass WEB_MODEL = eINSTANCE.getWebModel();

    /**
     * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute WEB_MODEL__NAME = eINSTANCE.getWebModel_Name();

    /**
     * The meta object literal for the '<em><b>Data Layer</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference WEB_MODEL__DATA_LAYER = eINSTANCE.getWebModel_DataLayer();

    /**
     * The meta object literal for the '<em><b>Hypertext Layer</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference WEB_MODEL__HYPERTEXT_LAYER = eINSTANCE.getWebModel_HypertextLayer();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.DataLayerImpl <em>Data Layer</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.DataLayerImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getDataLayer()
     * @generated
     */
    EClass DATA_LAYER = eINSTANCE.getDataLayer();

    /**
     * The meta object literal for the '<em><b>Entities</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference DATA_LAYER__ENTITIES = eINSTANCE.getDataLayer_Entities();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.EntityImpl <em>Entity</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.EntityImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getEntity()
     * @generated
     */
    EClass ENTITY = eINSTANCE.getEntity();

    /**
     * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute ENTITY__NAME = eINSTANCE.getEntity_Name();

    /**
     * The meta object literal for the '<em><b>Attributes</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference ENTITY__ATTRIBUTES = eINSTANCE.getEntity_Attributes();

    /**
     * The meta object literal for the '<em><b>References</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference ENTITY__REFERENCES = eINSTANCE.getEntity_References();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.AttributeImpl <em>Attribute</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.AttributeImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getAttribute()
     * @generated
     */
    EClass ATTRIBUTE = eINSTANCE.getAttribute();

    /**
     * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute ATTRIBUTE__NAME = eINSTANCE.getAttribute_Name();

    /**
     * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute ATTRIBUTE__TYPE = eINSTANCE.getAttribute_Type();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.ReferenceImpl <em>Reference</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.ReferenceImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getReference()
     * @generated
     */
    EClass REFERENCE = eINSTANCE.getReference();

    /**
     * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute REFERENCE__NAME = eINSTANCE.getReference_Name();

    /**
     * The meta object literal for the '<em><b>Type</b></em>' reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference REFERENCE__TYPE = eINSTANCE.getReference_Type();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.HypertextLayerImpl <em>Hypertext Layer</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.HypertextLayerImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getHypertextLayer()
     * @generated
     */
    EClass HYPERTEXT_LAYER = eINSTANCE.getHypertextLayer();

    /**
     * The meta object literal for the '<em><b>Pages</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference HYPERTEXT_LAYER__PAGES = eINSTANCE.getHypertextLayer_Pages();

    /**
     * The meta object literal for the '<em><b>Start Page</b></em>' reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference HYPERTEXT_LAYER__START_PAGE = eINSTANCE.getHypertextLayer_StartPage();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.PageImpl <em>Page</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.PageImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getPage()
     * @generated
     */
    EClass PAGE = eINSTANCE.getPage();

    /**
     * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute PAGE__NAME = eINSTANCE.getPage_Name();

    /**
     * The meta object literal for the '<em><b>Links</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference PAGE__LINKS = eINSTANCE.getPage_Links();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.StaticPageImpl <em>Static Page</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.StaticPageImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getStaticPage()
     * @generated
     */
    EClass STATIC_PAGE = eINSTANCE.getStaticPage();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.LinkImpl <em>Link</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.LinkImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getLink()
     * @generated
     */
    EClass LINK = eINSTANCE.getLink();

    /**
     * The meta object literal for the '<em><b>Target</b></em>' reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference LINK__TARGET = eINSTANCE.getLink_Target();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.DynamicPageImpl <em>Dynamic Page</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.DynamicPageImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getDynamicPage()
     * @generated
     */
    EClass DYNAMIC_PAGE = eINSTANCE.getDynamicPage();

    /**
     * The meta object literal for the '<em><b>Entity</b></em>' reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference DYNAMIC_PAGE__ENTITY = eINSTANCE.getDynamicPage_Entity();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.IndexPageImpl <em>Index Page</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.IndexPageImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getIndexPage()
     * @generated
     */
    EClass INDEX_PAGE = eINSTANCE.getIndexPage();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.impl.DataPageImpl <em>Data Page</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.DataPageImpl
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getDataPage()
     * @generated
     */
    EClass DATA_PAGE = eINSTANCE.getDataPage();

    /**
     * The meta object literal for the '{@link org.eclipse.emf.refactor.examples.simpleWebModel.SimpleType <em>Simple Type</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.SimpleType
     * @see org.eclipse.emf.refactor.examples.simpleWebModel.impl.SimpleWebModelPackageImpl#getSimpleType()
     * @generated
     */
    EEnum SIMPLE_TYPE = eINSTANCE.getSimpleType();

  }

} //SimpleWebModelPackage
