/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoop;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoopLabels;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopHolder;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegmentDependency;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.OrthogonalRoutingGenerator;
import org.eclipse.elk.core.options.PortSide;

public class RoutingSlotAssigner {
    private List<HyperEdgeSegment> hyperEdgeSegments;
    private Map<SelfHyperLoop, HyperEdgeSegment> slLoopToSegmentMap;
    private Map<SelfHyperLoop, boolean[]> slLoopActivityOverPorts;

    public void assignRoutingSlots(SelfLoopHolder slHolder) {
        boolean[][] labelCrossingMatrix = this.computeLabelCrossingMatrix(slHolder);
        this.createCrossingGraph(slHolder, labelCrossingMatrix);
        OrthogonalRoutingGenerator.breakNonCriticalCycles(this.hyperEdgeSegments, (Random)slHolder.getLNode().getGraph().getProperty(InternalProperties.RANDOM));
        this.doAssignRoutingSlots(slHolder, labelCrossingMatrix);
        this.hyperEdgeSegments = null;
        this.slLoopToSegmentMap = null;
        this.slLoopActivityOverPorts = null;
    }

    private boolean[][] computeLabelCrossingMatrix(SelfLoopHolder slHolder) {
        int labelID = 0;
        for (SelfHyperLoop slLoop : slHolder.getSLHyperLoops()) {
            if (slLoop.getSLLabels() == null) continue;
            slLoop.getSLLabels().id = labelID++;
        }
        boolean[][] crossingMatrix = new boolean[labelID][labelID];
        List<SelfHyperLoop> slLoops = slHolder.getSLHyperLoops();
        int sl1Idx = 0;
        while (sl1Idx < slLoops.size()) {
            SelfHyperLoop slLoop1 = slLoops.get(sl1Idx);
            if (slLoop1.getSLLabels() != null) {
                int sl2Idx = sl1Idx + 1;
                while (sl2Idx < slLoops.size()) {
                    SelfHyperLoop slLoop2 = slLoops.get(sl2Idx);
                    if (slLoop2.getSLLabels() != null) {
                        boolean overlap;
                        crossingMatrix[slLoop1.getSLLabels().id][slLoop2.getSLLabels().id] = overlap = this.labelsOverlap(slLoop1, slLoop2);
                        crossingMatrix[slLoop2.getSLLabels().id][slLoop1.getSLLabels().id] = overlap;
                    }
                    ++sl2Idx;
                }
            }
            ++sl1Idx;
        }
        return crossingMatrix;
    }

    private boolean labelsOverlap(SelfHyperLoop slLoop1, SelfHyperLoop slLoop2) {
        assert (slLoop1 != slLoop2);
        SelfHyperLoopLabels slLabels1 = slLoop1.getSLLabels();
        SelfHyperLoopLabels slLabels2 = slLoop2.getSLLabels();
        if (slLabels1 == null || slLabels2 == null) {
            return false;
        }
        if (slLabels1.getSide() != slLabels2.getSide() || slLabels1.getSide() == PortSide.EAST || slLabels1.getSide() == PortSide.WEST) {
            return false;
        }
        double start1 = slLabels1.getPosition().x;
        double end1 = start1 + slLabels1.getSize().x;
        double start2 = slLabels2.getPosition().x;
        double end2 = start2 + slLabels2.getSize().x;
        return start1 <= end2 && end1 >= start2;
    }

    private void createCrossingGraph(SelfLoopHolder slHolder, boolean[][] labelCrossingMatrix) {
        List<SelfHyperLoop> slLoops = slHolder.getSLHyperLoops();
        this.hyperEdgeSegments = new ArrayList<HyperEdgeSegment>(slLoops.size());
        this.slLoopToSegmentMap = new HashMap<SelfHyperLoop, HyperEdgeSegment>();
        for (SelfHyperLoop slLoop : slLoops) {
            HyperEdgeSegment segment = new HyperEdgeSegment(null);
            this.hyperEdgeSegments.add(segment);
            this.slLoopToSegmentMap.put(slLoop, segment);
        }
        this.slLoopActivityOverPorts = new HashMap<SelfHyperLoop, boolean[]>();
        this.computeLoopActivity(slHolder);
        int firstIdx = 0;
        while (firstIdx < slLoops.size() - 1) {
            SelfHyperLoop slLoop1 = slHolder.getSLHyperLoops().get(firstIdx);
            int secondIdx = firstIdx + 1;
            while (secondIdx < slLoops.size()) {
                this.createDependencies(slLoop1, slHolder.getSLHyperLoops().get(secondIdx), labelCrossingMatrix);
                ++secondIdx;
            }
            ++firstIdx;
        }
    }

    private void computeLoopActivity(SelfLoopHolder slHolder) {
        List<SelfHyperLoop> slLoops = slHolder.getSLHyperLoops();
        List<LPort> lPorts = slHolder.getLNode().getPorts();
        for (SelfHyperLoop slLoop : slLoops) {
            boolean[] loopActivity = new boolean[lPorts.size()];
            this.slLoopActivityOverPorts.put(slLoop, loopActivity);
            int lPortIdx = slLoop.getLeftmostPort().getLPort().id - 1;
            int lPortTargetIdx = slLoop.getRightmostPort().getLPort().id;
            while (lPortIdx != lPortTargetIdx) {
                lPortIdx = (lPortIdx + 1) % lPorts.size();
                loopActivity[lPortIdx] = true;
            }
        }
    }

    private void createDependencies(SelfHyperLoop slLoop1, SelfHyperLoop slLoop2, boolean[][] labelCrossingMatrix) {
        int firstAboveSecondCrossings = this.countCrossings(slLoop1, slLoop2);
        int secondAboveFirstCrossings = this.countCrossings(slLoop2, slLoop1);
        HyperEdgeSegment segment1 = this.slLoopToSegmentMap.get(slLoop1);
        HyperEdgeSegment segment2 = this.slLoopToSegmentMap.get(slLoop2);
        if (firstAboveSecondCrossings < secondAboveFirstCrossings) {
            HyperEdgeSegmentDependency.createAndAddRegular(segment1, segment2, secondAboveFirstCrossings - firstAboveSecondCrossings);
        } else if (secondAboveFirstCrossings < firstAboveSecondCrossings) {
            HyperEdgeSegmentDependency.createAndAddRegular(segment2, segment1, firstAboveSecondCrossings - secondAboveFirstCrossings);
        } else if (firstAboveSecondCrossings != 0 || this.labelsOverlap(slLoop1, slLoop2, labelCrossingMatrix)) {
            HyperEdgeSegmentDependency.createAndAddRegular(segment1, segment2, 0);
            HyperEdgeSegmentDependency.createAndAddRegular(segment2, segment1, 0);
        }
    }

    private int countCrossings(SelfHyperLoop slUpperLoop, SelfHyperLoop slLowerLoop) {
        boolean[] lowerLoopActivity = this.slLoopActivityOverPorts.get(slLowerLoop);
        int crossings = 0;
        for (SelfLoopPort slPort : slUpperLoop.getSLPorts()) {
            if (!lowerLoopActivity[slPort.getLPort().id]) continue;
            ++crossings;
        }
        return crossings;
    }

    private boolean labelsOverlap(SelfHyperLoop slLoop1, SelfHyperLoop slLoop2, boolean[][] labelCrossingMatrix) {
        if (slLoop1.getSLLabels() == null || slLoop2.getSLLabels() == null) {
            return false;
        }
        return labelCrossingMatrix[slLoop1.getSLLabels().id][slLoop2.getSLLabels().id];
    }

    private void doAssignRoutingSlots(SelfLoopHolder slHolder, boolean[][] labelCrossingMatrix) {
        this.assignRawRoutingSlotsToSegments();
        this.assignRawRoutingSlotsToLoops(slHolder);
        this.shiftTowardsNode(slHolder, labelCrossingMatrix);
    }

    private void assignRawRoutingSlotsToSegments() {
        LinkedList<HyperEdgeSegment> sinks = new LinkedList<HyperEdgeSegment>();
        for (HyperEdgeSegment segment : this.hyperEdgeSegments) {
            segment.setInWeight(segment.getIncomingSegmentDependencies().size());
            segment.setOutWeight(segment.getOutgoingSegmentDependencies().size());
            if (segment.getOutWeight() != 0) continue;
            segment.setRoutingSlot(0);
            sinks.add(segment);
        }
        while (!sinks.isEmpty()) {
            HyperEdgeSegment segment;
            segment = (HyperEdgeSegment)sinks.poll();
            int nextRoutingSlot = segment.getRoutingSlot() + 1;
            for (HyperEdgeSegmentDependency inDependency : segment.getIncomingSegmentDependencies()) {
                HyperEdgeSegment sourceSegment = inDependency.getSource();
                sourceSegment.setRoutingSlot(Math.max(sourceSegment.getRoutingSlot(), nextRoutingSlot));
                sourceSegment.setOutWeight(sourceSegment.getOutWeight() - 1);
                if (sourceSegment.getOutWeight() != 0) continue;
                sinks.add(sourceSegment);
            }
        }
    }

    private void assignRawRoutingSlotsToLoops(SelfLoopHolder slHolder) {
        for (SelfHyperLoop slLoop : slHolder.getSLHyperLoops()) {
            int slot = this.slLoopToSegmentMap.get(slLoop).getRoutingSlot();
            for (PortSide portSide : slLoop.getOccupiedPortSides()) {
                slLoop.setRoutingSlot(portSide, slot);
            }
        }
    }

    private void shiftTowardsNode(SelfLoopHolder slHolder, boolean[][] labelCrossingMatrix) {
        int[] nextFreeRoutingSlotAtPort = new int[slHolder.getLNode().getPorts().size()];
        this.shiftTowardsNodeOnSide(slHolder, PortSide.NORTH, nextFreeRoutingSlotAtPort, labelCrossingMatrix);
        this.shiftTowardsNodeOnSide(slHolder, PortSide.EAST, nextFreeRoutingSlotAtPort, labelCrossingMatrix);
        this.shiftTowardsNodeOnSide(slHolder, PortSide.SOUTH, nextFreeRoutingSlotAtPort, labelCrossingMatrix);
        this.shiftTowardsNodeOnSide(slHolder, PortSide.WEST, nextFreeRoutingSlotAtPort, labelCrossingMatrix);
    }

    private void shiftTowardsNodeOnSide(SelfLoopHolder slHolder, PortSide side, int[] nextFreeRoutingSlotAtPort, boolean[][] labelCrossingMatrix) {
        List slLoops = slHolder.getSLHyperLoops().stream().filter(slLoop -> slLoop.getOccupiedPortSides().contains(side)).sorted((sl1, sl2) -> Integer.compare(sl1.getRoutingSlot(side), sl2.getRoutingSlot(side))).collect(Collectors.toList());
        int minLPortIndex = Integer.MAX_VALUE;
        int maxLPortIndex = Integer.MIN_VALUE;
        for (LPort lPort : slHolder.getLNode().getPorts()) {
            if (lPort.getSide() != side) continue;
            minLPortIndex = Math.min(minLPortIndex, lPort.id);
            maxLPortIndex = Math.max(maxLPortIndex, lPort.id);
        }
        if (minLPortIndex == Integer.MAX_VALUE) {
            int i = 0;
            while (i < slLoops.size()) {
                ((SelfHyperLoop)slLoops.get(i)).setRoutingSlot(side, i);
                ++i;
            }
        } else {
            int[] slotAssignedToLabel = new int[labelCrossingMatrix.length];
            Arrays.fill(slotAssignedToLabel, -1);
            for (SelfHyperLoop slLoop2 : slLoops) {
                boolean[] activeAtPort = this.slLoopActivityOverPorts.get(slLoop2);
                int lowestAvailableSlot = 0;
                int portIndex = minLPortIndex;
                while (portIndex <= maxLPortIndex) {
                    if (activeAtPort[portIndex]) {
                        lowestAvailableSlot = Math.max(lowestAvailableSlot, nextFreeRoutingSlotAtPort[portIndex]);
                    }
                    ++portIndex;
                }
                if (slLoop2.getSLLabels() != null) {
                    int ourLabelIdx = slLoop2.getSLLabels().id;
                    HashSet<Integer> slotsWithLabelConflicts = new HashSet<Integer>();
                    int otherLabelIdx = 0;
                    while (otherLabelIdx < labelCrossingMatrix.length) {
                        if (labelCrossingMatrix[ourLabelIdx][otherLabelIdx]) {
                            slotsWithLabelConflicts.add(slotAssignedToLabel[otherLabelIdx]);
                        }
                        ++otherLabelIdx;
                    }
                    while (slotsWithLabelConflicts.contains(lowestAvailableSlot)) {
                        ++lowestAvailableSlot;
                    }
                }
                slLoop2.setRoutingSlot(side, lowestAvailableSlot);
                portIndex = minLPortIndex;
                while (portIndex <= maxLPortIndex) {
                    if (activeAtPort[portIndex]) {
                        nextFreeRoutingSlotAtPort[portIndex] = lowestAvailableSlot + 1;
                    }
                    ++portIndex;
                }
                if (slLoop2.getSLLabels() == null) continue;
                slotAssignedToLabel[slLoop2.getSLLabels().id] = lowestAvailableSlot;
            }
        }
    }
}

